/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import org.ho.yaml.exception.YamlException;

public class Utilities {
    public static Object decodeSimpleType(String string) {
        if ("~".equals(string)) {
            return null;
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Double(string);
            }
            catch (NumberFormatException numberFormatException2) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                return new Boolean(string);
            }
            return Utilities.unescape(string);
        }
    }

    public static String quote(Object object) {
        return "\"" + object + "\"";
    }

    public static String stringify(Object object) {
        return Utilities.stringify(object, "");
    }

    public static String escape(String string) {
        string = string.replace("\b", "\\b");
        string = string.replace("\u0000", "\\0");
        string = string.replace("\t", "\\t");
        return string;
    }

    public static String unescape(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace("\\b", "\b");
        string = string.replace("\\0", "\u0000");
        string = string.replace("\\t", "\t");
        string = string.replace("\\n", "\n");
        return string;
    }

    public static String stringify(Object object, String string) {
        String string2 = Utilities.escape(object.toString());
        if (string2.indexOf(10) != -1) {
            if (string2.length() == 1) {
                return "\\n";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("|");
            String[] stringArray = string2.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                stringBuffer.append("\n" + string + string3);
            }
            if (string2.charAt(string2.length() - 1) == '\n') {
                stringBuffer.append("\n" + string);
            }
            return stringBuffer.toString();
        }
        if ("".equals(string2)) {
            return Utilities.quote(string2);
        }
        String string4 = ":[]{},\"'|";
        boolean bl = false;
        for (char c : string4.toCharArray()) {
            if (string2.indexOf(c) == -1) continue;
            bl = true;
            break;
        }
        if (string2.trim().length() != string2.length()) {
            bl = true;
        }
        if (Utilities.isNumeric(string2)) {
            bl = true;
        }
        if (bl) {
            string2 = string2.replaceAll("\\\\", "\\\\\\\\");
            string2 = string2.replaceAll("\"", "\\\\\"");
            string2 = Utilities.quote(string2);
        }
        return string2;
    }

    static boolean isNumeric(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(string);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static Object convertType(String string, Class clazz) {
        if ("~".equals(string)) {
            return null;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new Integer(string.toString());
        }
        if (clazz == String.class) {
            return Utilities.unescape(string);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return new Long(string.toString());
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return new Short(string.toString());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new Double(string.toString());
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return new Boolean(string.toString());
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            string = Utilities.unescape(string);
            return new Character(string.charAt(0));
        }
        return Utilities.decodeSimpleType(string);
    }

    public static Class getWrapperClass(Class clazz) {
        if (Integer.TYPE == clazz) {
            return Integer.class;
        }
        if (Double.TYPE == clazz) {
            return Double.class;
        }
        if (Float.TYPE == clazz) {
            return Float.class;
        }
        if (Boolean.TYPE == clazz) {
            return Boolean.class;
        }
        if (Character.TYPE == clazz) {
            return Character.class;
        }
        if (Byte.TYPE == clazz) {
            return Byte.class;
        }
        if (Long.TYPE == clazz) {
            return Long.class;
        }
        if (Short.TYPE == clazz) {
            return Short.class;
        }
        if (Character.TYPE == clazz) {
            return Character.class;
        }
        throw new YamlException(clazz + " is not a primitive type.");
    }

    public static boolean classEquals(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        if (clazz != null && clazz2 != null && (clazz.isPrimitive() || clazz2.isPrimitive())) {
            if (clazz.isPrimitive()) {
                return Utilities.getWrapperClass(clazz) == clazz2;
            }
            return clazz == Utilities.getWrapperClass(clazz2);
        }
        return false;
    }

    public static boolean same(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return true;
    }
}

