/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractPartial;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.format.DateTimeFormat;

public abstract class BasePartial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 2353678632973660L;
    private Chronology iChronology;
    private int[] iValues;

    protected BasePartial() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)null);
    }

    protected BasePartial(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    protected BasePartial(long instant) {
        this(instant, (Chronology)null);
    }

    protected BasePartial(long instant, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = chronology.get(this, instant);
    }

    protected BasePartial(Object instant, Chronology chronology) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        chronology = converter.getChronology(instant, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = converter.getPartialValues(this, instant, chronology);
    }

    protected BasePartial(int[] values, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        chronology.validate(this, values);
        this.iValues = values;
    }

    protected BasePartial(BasePartial base, int[] values) {
        this.iChronology = base.iChronology;
        this.iValues = values;
    }

    protected BasePartial(BasePartial base, Chronology chrono) {
        this.iChronology = chrono.withUTC();
        this.iValues = base.iValues;
    }

    public int getValue(int index) {
        return this.iValues[index];
    }

    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setValue(int index, int value) {
        DateTimeField field = this.getField(index);
        this.iValues = field.set(this, index, this.iValues, value);
    }

    protected void setValues(int[] values) {
        this.getChronology().validate(this, values);
        this.iValues = values;
    }

    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    public String toString(String pattern, Locale locale) throws IllegalArgumentException {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }
}

