/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDateTimeField;
import org.joda.time.field.UnsupportedDurationField;

public abstract class BaseChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = -7310865996721419676L;

    protected BaseChronology() {
    }

    public abstract DateTimeZone getZone();

    public abstract Chronology withUTC();

    public abstract Chronology withZone(DateTimeZone var1);

    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        long instant = this.year().set(0L, year);
        instant = this.monthOfYear().set(instant, monthOfYear);
        instant = this.dayOfMonth().set(instant, dayOfMonth);
        return this.millisOfDay().set(instant, millisOfDay);
    }

    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        long instant = this.year().set(0L, year);
        instant = this.monthOfYear().set(instant, monthOfYear);
        instant = this.dayOfMonth().set(instant, dayOfMonth);
        instant = this.hourOfDay().set(instant, hourOfDay);
        instant = this.minuteOfHour().set(instant, minuteOfHour);
        instant = this.secondOfMinute().set(instant, secondOfMinute);
        return this.millisOfSecond().set(instant, millisOfSecond);
    }

    public long getDateTimeMillis(long instant, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        instant = this.hourOfDay().set(instant, hourOfDay);
        instant = this.minuteOfHour().set(instant, minuteOfHour);
        instant = this.secondOfMinute().set(instant, secondOfMinute);
        return this.millisOfSecond().set(instant, millisOfSecond);
    }

    public void validate(ReadablePartial partial, int[] values) {
        int size = partial.size();
        int i = 0;
        while (i < size) {
            int value = values[i];
            DateTimeField field = partial.getField(i);
            if (value < field.getMinimumValue()) {
                throw new IllegalFieldValueException(field.getType(), (Number)new Integer(value), (Number)new Integer(field.getMinimumValue()), null);
            }
            if (value > field.getMaximumValue()) {
                throw new IllegalFieldValueException(field.getType(), (Number)new Integer(value), null, (Number)new Integer(field.getMaximumValue()));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < size) {
            int value = values[i2];
            DateTimeField field = partial.getField(i2);
            if (value < field.getMinimumValue(partial, values)) {
                throw new IllegalFieldValueException(field.getType(), (Number)new Integer(value), (Number)new Integer(field.getMinimumValue(partial, values)), null);
            }
            if (value > field.getMaximumValue(partial, values)) {
                throw new IllegalFieldValueException(field.getType(), (Number)new Integer(value), null, (Number)new Integer(field.getMaximumValue(partial, values)));
            }
            ++i2;
        }
    }

    public int[] get(ReadablePartial partial, long instant) {
        int size = partial.size();
        int[] values = new int[size];
        int i = 0;
        while (i < size) {
            values[i] = partial.getFieldType(i).getField(this).get(instant);
            ++i;
        }
        return values;
    }

    public long set(ReadablePartial partial, long instant) {
        int i = 0;
        int isize = partial.size();
        while (i < isize) {
            instant = partial.getFieldType(i).getField(this).set(instant, partial.getValue(i));
            ++i;
        }
        return instant;
    }

    public int[] get(ReadablePeriod period, long startInstant, long endInstant) {
        int size = period.size();
        int[] values = new int[size];
        if (startInstant != endInstant) {
            int i = 0;
            while (i < size) {
                DurationField field = period.getFieldType(i).getField(this);
                int value = field.getDifference(endInstant, startInstant);
                startInstant = field.add(startInstant, value);
                values[i] = value;
                ++i;
            }
        }
        return values;
    }

    public int[] get(ReadablePeriod period, long duration) {
        int size = period.size();
        int[] values = new int[size];
        if (duration != 0L) {
            long current = 0L;
            int i = 0;
            while (i < size) {
                DurationField field = period.getFieldType(i).getField(this);
                if (field.isPrecise()) {
                    int value = field.getDifference(duration, current);
                    current = field.add(current, value);
                    values[i] = value;
                }
                ++i;
            }
        }
        return values;
    }

    public long add(ReadablePeriod period, long instant, int scalar) {
        if (scalar != 0 && period != null) {
            int i = 0;
            int isize = period.size();
            while (i < isize) {
                long value = period.getValue(i);
                if (value != 0L) {
                    instant = period.getFieldType(i).getField(this).add(instant, value * (long)scalar);
                }
                ++i;
            }
        }
        return instant;
    }

    public long add(long instant, long duration, int scalar) {
        if (duration == 0L || scalar == 0) {
            return instant;
        }
        long add = FieldUtils.safeMultiply(duration, scalar);
        return FieldUtils.safeAdd(instant, add);
    }

    public DurationField millis() {
        return UnsupportedDurationField.getInstance(DurationFieldType.millis());
    }

    public DateTimeField millisOfSecond() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfSecond(), this.millis());
    }

    public DateTimeField millisOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfDay(), this.millis());
    }

    public DurationField seconds() {
        return UnsupportedDurationField.getInstance(DurationFieldType.seconds());
    }

    public DateTimeField secondOfMinute() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfMinute(), this.seconds());
    }

    public DateTimeField secondOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfDay(), this.seconds());
    }

    public DurationField minutes() {
        return UnsupportedDurationField.getInstance(DurationFieldType.minutes());
    }

    public DateTimeField minuteOfHour() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfHour(), this.minutes());
    }

    public DateTimeField minuteOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfDay(), this.minutes());
    }

    public DurationField hours() {
        return UnsupportedDurationField.getInstance(DurationFieldType.hours());
    }

    public DateTimeField hourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfDay(), this.hours());
    }

    public DateTimeField clockhourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfDay(), this.hours());
    }

    public DurationField halfdays() {
        return UnsupportedDurationField.getInstance(DurationFieldType.halfdays());
    }

    public DateTimeField hourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfHalfday(), this.hours());
    }

    public DateTimeField clockhourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfHalfday(), this.hours());
    }

    public DateTimeField halfdayOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.halfdayOfDay(), this.halfdays());
    }

    public DurationField days() {
        return UnsupportedDurationField.getInstance(DurationFieldType.days());
    }

    public DateTimeField dayOfWeek() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfWeek(), this.days());
    }

    public DateTimeField dayOfMonth() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfMonth(), this.days());
    }

    public DateTimeField dayOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfYear(), this.days());
    }

    public DurationField weeks() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weeks());
    }

    public DateTimeField weekOfWeekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekOfWeekyear(), this.weeks());
    }

    public DurationField weekyears() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weekyears());
    }

    public DateTimeField weekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyear(), this.weekyears());
    }

    public DateTimeField weekyearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyearOfCentury(), this.weekyears());
    }

    public DurationField months() {
        return UnsupportedDurationField.getInstance(DurationFieldType.months());
    }

    public DateTimeField monthOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.monthOfYear(), this.months());
    }

    public DurationField years() {
        return UnsupportedDurationField.getInstance(DurationFieldType.years());
    }

    public DateTimeField year() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.year(), this.years());
    }

    public DateTimeField yearOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfEra(), this.years());
    }

    public DateTimeField yearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfCentury(), this.years());
    }

    public DurationField centuries() {
        return UnsupportedDurationField.getInstance(DurationFieldType.centuries());
    }

    public DateTimeField centuryOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.centuryOfEra(), this.centuries());
    }

    public DurationField eras() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DateTimeField era() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.era(), this.eras());
    }

    public abstract String toString();
}

