/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -6821236822336841037L;
    private final BasicChronology iChronology;

    BasicDayOfYearDateTimeField(BasicChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfYear(), days);
        this.iChronology = chronology;
    }

    public int get(long instant) {
        return this.iChronology.getDayOfYear(instant);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.iChronology.getDaysInYearMax();
    }

    public int getMaximumValue(long instant) {
        int year = this.iChronology.getYear(instant);
        return this.iChronology.getDaysInYear(year);
    }

    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.year())) {
            int year = partial.get(DateTimeFieldType.year());
            return this.iChronology.getDaysInYear(year);
        }
        return this.iChronology.getDaysInYearMax();
    }

    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        int i = 0;
        while (i < size) {
            if (partial.getFieldType(i) == DateTimeFieldType.year()) {
                int year = values[i];
                return this.iChronology.getDaysInYear(year);
            }
            ++i;
        }
        return this.iChronology.getDaysInYearMax();
    }

    protected int getMaximumValueForSet(long instant, int value) {
        int maxLessOne = this.iChronology.getDaysInYearMax() - 1;
        return value > maxLessOne ? this.getMaximumValue(instant) : maxLessOne;
    }

    private Object readResolve() {
        return this.iChronology.dayOfYear();
    }
}

