/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDurationField;

final class BasicSingleEraDateTimeField
extends BaseDateTimeField {
    private static final int ERA_VALUE = 1;
    private final String iEraText;

    BasicSingleEraDateTimeField(String text) {
        super(DateTimeFieldType.era());
        this.iEraText = text;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long instant) {
        return 1;
    }

    public long set(long instant, int era) {
        FieldUtils.verifyValueBounds(this, era, 1, 1);
        return instant;
    }

    public long set(long instant, String text, Locale locale) {
        if (!this.iEraText.equals(text) && !"1".equals(text)) {
            throw new IllegalFieldValueException(DateTimeFieldType.era(), text);
        }
        return instant;
    }

    public long roundFloor(long instant) {
        return Long.MIN_VALUE;
    }

    public long roundCeiling(long instant) {
        return Long.MAX_VALUE;
    }

    public long roundHalfFloor(long instant) {
        return Long.MIN_VALUE;
    }

    public long roundHalfCeiling(long instant) {
        return Long.MIN_VALUE;
    }

    public long roundHalfEven(long instant) {
        return Long.MIN_VALUE;
    }

    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 1;
    }

    public String getAsText(int fieldValue, Locale locale) {
        return this.iEraText;
    }

    public int getMaximumTextLength(Locale locale) {
        return this.iEraText.length();
    }
}

