/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.StrictDateTimeField;

public final class StrictChronology
extends AssembledChronology {
    private static final long serialVersionUID = 6633006628097111960L;
    private transient Chronology iWithUTC;

    public static StrictChronology getInstance(Chronology base) {
        if (base == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        return new StrictChronology(base);
    }

    private StrictChronology(Chronology base) {
        super(base, null);
    }

    public Chronology withUTC() {
        if (this.iWithUTC == null) {
            this.iWithUTC = this.getZone() == DateTimeZone.UTC ? this : StrictChronology.getInstance(this.getBase().withUTC());
        }
        return this.iWithUTC;
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == DateTimeZone.UTC) {
            return this.withUTC();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return StrictChronology.getInstance(this.getBase().withZone(zone));
    }

    protected void assemble(AssembledChronology.Fields fields) {
        fields.year = StrictChronology.convertField(fields.year);
        fields.yearOfEra = StrictChronology.convertField(fields.yearOfEra);
        fields.yearOfCentury = StrictChronology.convertField(fields.yearOfCentury);
        fields.centuryOfEra = StrictChronology.convertField(fields.centuryOfEra);
        fields.era = StrictChronology.convertField(fields.era);
        fields.dayOfWeek = StrictChronology.convertField(fields.dayOfWeek);
        fields.dayOfMonth = StrictChronology.convertField(fields.dayOfMonth);
        fields.dayOfYear = StrictChronology.convertField(fields.dayOfYear);
        fields.monthOfYear = StrictChronology.convertField(fields.monthOfYear);
        fields.weekOfWeekyear = StrictChronology.convertField(fields.weekOfWeekyear);
        fields.weekyear = StrictChronology.convertField(fields.weekyear);
        fields.weekyearOfCentury = StrictChronology.convertField(fields.weekyearOfCentury);
        fields.millisOfSecond = StrictChronology.convertField(fields.millisOfSecond);
        fields.millisOfDay = StrictChronology.convertField(fields.millisOfDay);
        fields.secondOfMinute = StrictChronology.convertField(fields.secondOfMinute);
        fields.secondOfDay = StrictChronology.convertField(fields.secondOfDay);
        fields.minuteOfHour = StrictChronology.convertField(fields.minuteOfHour);
        fields.minuteOfDay = StrictChronology.convertField(fields.minuteOfDay);
        fields.hourOfDay = StrictChronology.convertField(fields.hourOfDay);
        fields.hourOfHalfday = StrictChronology.convertField(fields.hourOfHalfday);
        fields.clockhourOfDay = StrictChronology.convertField(fields.clockhourOfDay);
        fields.clockhourOfHalfday = StrictChronology.convertField(fields.clockhourOfHalfday);
        fields.halfdayOfDay = StrictChronology.convertField(fields.halfdayOfDay);
    }

    private static final DateTimeField convertField(DateTimeField field) {
        return StrictDateTimeField.getInstance(field);
    }

    public String toString() {
        return "StrictChronology[" + this.getBase().toString() + ']';
    }
}

