/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public class PreciseDurationField
extends BaseDurationField {
    private static final long serialVersionUID = -8346152187724495365L;
    private final long iUnitMillis;

    public PreciseDurationField(DurationFieldType type, long unitMillis) {
        super(type);
        this.iUnitMillis = unitMillis;
    }

    public final boolean isPrecise() {
        return true;
    }

    public final long getUnitMillis() {
        return this.iUnitMillis;
    }

    public long getValueAsLong(long duration, long instant) {
        return duration / this.iUnitMillis;
    }

    public long getMillis(int value, long instant) {
        return (long)value * this.iUnitMillis;
    }

    public long getMillis(long value, long instant) {
        return FieldUtils.safeMultiply(value, this.iUnitMillis);
    }

    public long add(long instant, int value) {
        long addition = (long)value * this.iUnitMillis;
        return FieldUtils.safeAdd(instant, addition);
    }

    public long add(long instant, long value) {
        long addition = FieldUtils.safeMultiply(value, this.iUnitMillis);
        return FieldUtils.safeAdd(instant, addition);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        long difference = FieldUtils.safeSubtract(minuendInstant, subtrahendInstant);
        return difference / this.iUnitMillis;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PreciseDurationField) {
            PreciseDurationField other = (PreciseDurationField)obj;
            return this.getType() == other.getType() && this.iUnitMillis == other.iUnitMillis;
        }
        return false;
    }

    public int hashCode() {
        long millis = this.iUnitMillis;
        int hash = (int)(millis ^ millis >>> 32);
        return hash += this.getType().hashCode();
    }
}

