/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;

public class DateTimeFormat {
    static final int FULL = 0;
    static final int LONG = 1;
    static final int MEDIUM = 2;
    static final int SHORT = 3;
    static final int NONE = 4;
    static final int DATE = 0;
    static final int TIME = 1;
    static final int DATETIME = 2;
    private static final Map cPatternedCache = new HashMap(7);
    private static final DateTimeFormatter[] cStyleCache = new DateTimeFormatter[25];

    public static DateTimeFormatter forPattern(String pattern) {
        return DateTimeFormat.createFormatterForPattern(pattern);
    }

    public static DateTimeFormatter forStyle(String style) {
        return DateTimeFormat.createFormatterForStyle(style);
    }

    public static DateTimeFormatter shortDate() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 4);
    }

    public static DateTimeFormatter shortTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 3);
    }

    public static DateTimeFormatter shortDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 3);
    }

    public static DateTimeFormatter mediumDate() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 4);
    }

    public static DateTimeFormatter mediumTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 2);
    }

    public static DateTimeFormatter mediumDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 2);
    }

    public static DateTimeFormatter longDate() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 4);
    }

    public static DateTimeFormatter longTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 1);
    }

    public static DateTimeFormatter longDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 1);
    }

    public static DateTimeFormatter fullDate() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 4);
    }

    public static DateTimeFormatter fullTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 0);
    }

    public static DateTimeFormatter fullDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 0);
    }

    static void appendPatternTo(DateTimeFormatterBuilder builder, String pattern) {
        DateTimeFormat.parsePatternTo(builder, pattern);
    }

    protected DateTimeFormat() {
    }

    private static void parsePatternTo(DateTimeFormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        int i = 0;
        while (i < length) {
            indexRef[0] = i;
            String token = DateTimeFormat.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            block0 : switch (c) {
                case 'G': {
                    builder.appendEraText();
                    break;
                }
                case 'C': {
                    builder.appendCenturyOfEra(tokenLen, tokenLen);
                    break;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (tokenLen == 2) {
                        boolean lenientParse = true;
                        if (i + 1 < length) {
                            indexRef[0] = indexRef[0] + 1;
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(pattern, indexRef))) {
                                lenientParse = false;
                            }
                            indexRef[0] = indexRef[0] - 1;
                        }
                        switch (c) {
                            case 'x': {
                                builder.appendTwoDigitWeekyear(new DateTime().getWeekyear() - 30, lenientParse);
                                break block0;
                            }
                        }
                        builder.appendTwoDigitYear(new DateTime().getYear() - 30, lenientParse);
                        break;
                    }
                    int maxDigits = 9;
                    if (i + 1 < length) {
                        indexRef[0] = indexRef[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(pattern, indexRef))) {
                            maxDigits = tokenLen;
                        }
                        indexRef[0] = indexRef[0] - 1;
                    }
                    switch (c) {
                        case 'x': {
                            builder.appendWeekyear(tokenLen, maxDigits);
                            break;
                        }
                        case 'y': {
                            builder.appendYear(tokenLen, maxDigits);
                            break;
                        }
                        case 'Y': {
                            builder.appendYearOfEra(tokenLen, maxDigits);
                        }
                    }
                    break;
                }
                case 'M': {
                    if (tokenLen >= 3) {
                        if (tokenLen >= 4) {
                            builder.appendMonthOfYearText();
                            break;
                        }
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    builder.appendMonthOfYear(tokenLen);
                    break;
                }
                case 'd': {
                    builder.appendDayOfMonth(tokenLen);
                    break;
                }
                case 'a': {
                    builder.appendHalfdayOfDayText();
                    break;
                }
                case 'h': {
                    builder.appendClockhourOfHalfday(tokenLen);
                    break;
                }
                case 'H': {
                    builder.appendHourOfDay(tokenLen);
                    break;
                }
                case 'k': {
                    builder.appendClockhourOfDay(tokenLen);
                    break;
                }
                case 'K': {
                    builder.appendHourOfHalfday(tokenLen);
                    break;
                }
                case 'm': {
                    builder.appendMinuteOfHour(tokenLen);
                    break;
                }
                case 's': {
                    builder.appendSecondOfMinute(tokenLen);
                    break;
                }
                case 'S': {
                    builder.appendFractionOfSecond(tokenLen, tokenLen);
                    break;
                }
                case 'e': {
                    builder.appendDayOfWeek(tokenLen);
                    break;
                }
                case 'E': {
                    if (tokenLen >= 4) {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    builder.appendDayOfWeekShortText();
                    break;
                }
                case 'D': {
                    builder.appendDayOfYear(tokenLen);
                    break;
                }
                case 'w': {
                    builder.appendWeekOfWeekyear(tokenLen);
                    break;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        builder.appendTimeZoneName();
                        break;
                    }
                    builder.appendTimeZoneShortName();
                    break;
                }
                case 'Z': {
                    if (tokenLen == 1) {
                        builder.appendTimeZoneOffset(null, false, 2, 2);
                        break;
                    }
                    if (tokenLen == 2) {
                        builder.appendTimeZoneOffset(null, true, 2, 2);
                        break;
                    }
                    builder.appendTimeZoneId();
                    break;
                }
                case '\'': {
                    String sub = token.substring(1);
                    if (sub.length() == 1) {
                        builder.appendLiteral(sub.charAt(0));
                        break;
                    }
                    builder.appendLiteral(new String(sub));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + token);
                }
            }
            ++i;
        }
    }

    private static String parseToken(String pattern, int[] indexRef) {
        StringBuffer buf = new StringBuffer();
        int i = indexRef[0];
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            buf.append(c);
            while (i + 1 < length) {
                char peek = pattern.charAt(i + 1);
                if (peek == c) {
                    buf.append(c);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            while (i < length) {
                c = pattern.charAt(i);
                if (c == '\'') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        buf.append(c);
                    } else {
                        inLiteral = !inLiteral;
                    }
                } else {
                    if (!inLiteral && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) break;
                    buf.append(c);
                }
                ++i;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }

    private static boolean isNumericToken(String token) {
        int tokenLen = token.length();
        if (tokenLen > 0) {
            char c = token.charAt(0);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (tokenLen > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static DateTimeFormatter createFormatterForPattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter formatter = null;
        Map map = cPatternedCache;
        synchronized (map) {
            formatter = (DateTimeFormatter)cPatternedCache.get(pattern);
            if (formatter == null) {
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
                DateTimeFormat.parsePatternTo(builder, pattern);
                formatter = builder.toFormatter();
                cPatternedCache.put(pattern, formatter);
            }
        }
        return formatter;
    }

    private static DateTimeFormatter createFormatterForStyle(String style) {
        if (style == null || style.length() != 2) {
            throw new IllegalArgumentException("Invalid style specification: " + style);
        }
        int dateStyle = DateTimeFormat.selectStyle(style.charAt(0));
        int timeStyle = DateTimeFormat.selectStyle(style.charAt(1));
        if (dateStyle == 4 && timeStyle == 4) {
            throw new IllegalArgumentException("Style '--' is invalid");
        }
        return DateTimeFormat.createFormatterForStyleIndex(dateStyle, timeStyle);
    }

    private static DateTimeFormatter createFormatterForStyleIndex(int dateStyle, int timeStyle) {
        int index = dateStyle * 5 + timeStyle;
        DateTimeFormatter f = null;
        DateTimeFormatter[] dateTimeFormatterArray = cStyleCache;
        synchronized (dateTimeFormatterArray) {
            f = cStyleCache[index];
            if (f == null) {
                int type = 2;
                if (dateStyle == 4) {
                    type = 1;
                } else if (timeStyle == 4) {
                    type = 0;
                }
                StyleFormatter llf = new StyleFormatter(dateStyle, timeStyle, type);
                DateTimeFormat.cStyleCache[index] = f = new DateTimeFormatter(llf, llf);
            }
        }
        return f;
    }

    private static int selectStyle(char ch) {
        switch (ch) {
            case 'S': {
                return 3;
            }
            case 'M': {
                return 2;
            }
            case 'L': {
                return 1;
            }
            case 'F': {
                return 0;
            }
            case '-': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid style character: " + ch);
    }

    static class StyleFormatter
    implements DateTimePrinter,
    DateTimeParser {
        private static final Map cCache = new HashMap();
        private final int iDateStyle;
        private final int iTimeStyle;
        private final int iType;

        StyleFormatter(int dateStyle, int timeStyle, int type) {
            this.iDateStyle = dateStyle;
            this.iTimeStyle = timeStyle;
            this.iType = type;
        }

        public int estimatePrintedLength() {
            return 40;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            DateTimePrinter p = this.getFormatter(locale).getPrinter();
            p.printTo(buf, instant, chrono, displayOffset, displayZone, locale);
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            DateTimePrinter p = this.getFormatter(locale).getPrinter();
            p.printTo(out, instant, chrono, displayOffset, displayZone, locale);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            DateTimePrinter p = this.getFormatter(locale).getPrinter();
            p.printTo(buf, partial, locale);
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            DateTimePrinter p = this.getFormatter(locale).getPrinter();
            p.printTo(out, partial, locale);
        }

        public int estimateParsedLength() {
            return 40;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            DateTimeParser p = this.getFormatter(bucket.getLocale()).getParser();
            return p.parseInto(bucket, text, position);
        }

        private DateTimeFormatter getFormatter(Locale locale) {
            locale = locale == null ? Locale.getDefault() : locale;
            String key = Integer.toString(this.iType + (this.iDateStyle << 4) + (this.iTimeStyle << 8)) + locale.toString();
            DateTimeFormatter f = null;
            Map map = cCache;
            synchronized (map) {
                f = (DateTimeFormatter)cCache.get(key);
                if (f == null) {
                    String pattern = this.getPattern(locale);
                    f = DateTimeFormat.forPattern(pattern);
                    cCache.put(key, f);
                }
            }
            return f;
        }

        private String getPattern(Locale locale) {
            DateFormat f = null;
            switch (this.iType) {
                case 0: {
                    f = DateFormat.getDateInstance(this.iDateStyle, locale);
                    break;
                }
                case 1: {
                    f = DateFormat.getTimeInstance(this.iTimeStyle, locale);
                    break;
                }
                case 2: {
                    f = DateFormat.getDateTimeInstance(this.iDateStyle, this.iTimeStyle, locale);
                }
            }
            if (!(f instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("No datetime pattern for locale: " + locale);
            }
            return ((SimpleDateFormat)f).toPattern();
        }
    }
}

