/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lang;

import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;

public class PackageMap
extends AbstractMap {
    private Package pkg;

    public PackageMap(Package pkg) {
        this.pkg = pkg;
    }

    public Object get(Object key) {
        String symbol = ((String)key).intern();
        NamedValue value = this.pkg.lookup(symbol);
        if (value != null) {
            return value.get();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        String symbol = ((String)key).intern();
        NamedValue binding = this.pkg.lookup(symbol);
        if (binding != null) {
            Object old = binding.get();
            binding.set(value);
            return old;
        }
        this.pkg.set(symbol, value);
        return null;
    }

    public int size() {
        return this.pkg.size();
    }

    public Set entrySet() {
        Enumeration e = this.pkg.bindings();
        HashSet<NamedValueEntry> set = new HashSet<NamedValueEntry>();
        while (e.hasMoreElements()) {
            NamedValue binding = (NamedValue)e.nextElement();
            set.add(new NamedValueEntry(binding));
        }
        return set;
    }

    static class NamedValueEntry
    implements Map.Entry {
        private NamedValue binding;

        NamedValueEntry(NamedValue binding) {
            this.binding = binding;
        }

        public Object getKey() {
            return this.binding.getName();
        }

        public Object getValue() {
            return this.binding.get();
        }

        public Object setValue(Object newValue) {
            Object old = this.binding.get();
            this.binding.set(newValue);
            return old;
        }

        public int hashCode() {
            return this.binding.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NamedValueEntry) {
                NamedValueEntry e = (NamedValueEntry)obj;
                return this.binding.equals(e.binding);
            }
            return false;
        }
    }
}

