/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lang;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pnuts.lang.DefaultParseEnv;
import pnuts.compiler.ClassFile;
import pnuts.compiler.Compiler;
import pnuts.lang.Context;
import pnuts.lang.ParseException;
import pnuts.lang.PnutsParser;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

public class PnutsClassLoader
extends ClassLoader {
    private static final boolean DEBUG = false;
    private static final String DEFAULT_PREFIX = "";
    private static final String DEFAULT_SUFFIX = ".pnc";
    private String prefix = "";
    private String suffix = ".pnc";
    private String encoding;
    private Context context;
    private Map table = new HashMap();

    public PnutsClassLoader(Context context) {
        this.context = context;
    }

    public PnutsClassLoader(ClassLoader parent, Context context) {
        super(parent);
        this.context = context;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected String getScriptResourceName(String className) {
        int idx = className.lastIndexOf(46);
        if (idx < 0) {
            return this.prefix + className + this.suffix;
        }
        return this.prefix + className.replace('.', '/') + this.suffix;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = this.encoding;
    }

    protected SimpleNode parse(InputStream in, URL url) throws IOException, ParseException {
        BufferedReader reader = this.encoding != null ? new BufferedReader(new InputStreamReader(in, this.encoding)) : new BufferedReader(new InputStreamReader(in));
        return PnutsClassLoader.parse(reader, url);
    }

    public static SimpleNode parse(Reader reader, URL url) throws IOException, ParseException {
        DefaultParseEnv env = DefaultParseEnv.getInstance(url);
        return new PnutsParser(reader).ClassScript(env);
    }

    private static void dump(String name, byte[] code) {
        try {
            FileOutputStream fout = new FileOutputStream("c:/tmp/" + name + ".class");
            fout.write(code);
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void attachContext(Class cls) {
        try {
            Method m = cls.getMethod("attach", Context.class);
            m.invoke(null, new Context(this.context));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List compile(String className, URL url) throws IOException, ParseException {
        InputStream in = url.openStream();
        if (in != null) {
            try {
                if (this.context.isVerbose()) {
                    PrintWriter writer = this.context.getErrorWriter();
                    writer.println("compiling " + url);
                }
                List list = this.compile(className, this.parse(in, url), url);
                return list;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List compile(String className, SimpleNode node, Object scriptSource) throws IOException {
        ArrayList helperClassFiles = new ArrayList();
        ClassFile classFile = new Compiler(className, false, true).compileClassScript(node, scriptSource, helperClassFiles);
        ArrayList classes = new ArrayList();
        int n = helperClassFiles.size();
        for (int i = 0; i < n; ++i) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ClassFile cf = (ClassFile)helperClassFiles.get(i);
            cf.write(bout);
            byte[] bytecode = bout.toByteArray();
            try {
                Class<?> cls = this.defineClass(cf.getClassName(), bytecode, 0, bytecode.length);
                classes.add(cls);
                continue;
            }
            catch (Throwable e) {
                return null;
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        classFile.write(bout);
        byte[] bytecode = bout.toByteArray();
        try {
            Class<?> cls = this.defineClass(className, bytecode, 0, bytecode.length);
            if (this.context != null && this.context != Runtime.getThreadContext()) {
                this.attachContext(cls);
            }
            this.table.put(className, cls);
            classes.add(cls);
        }
        catch (Throwable e) {
            e.printStackTrace();
            List list = null;
            return list;
        }
        return classes;
    }

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    protected void handleParseException(ParseException e) {
        e.printStackTrace();
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        Class cls = (Class)this.table.get(className);
        if (cls != null) {
            return cls;
        }
        try {
            return super.findClass(className);
        }
        catch (ClassNotFoundException cfe) {
            String resource = this.getScriptResourceName(className);
            URL url = this.getResource(resource);
            if (url != null) {
                try {
                    List classes = this.compile(className, url);
                    if (classes != null && classes.size() > 0) {
                        return (Class)classes.get(classes.size() - 1);
                    }
                }
                catch (IOException e1) {
                    return super.findClass(className);
                }
                catch (ParseException e2) {
                    this.handleParseException(e2);
                    return super.findClass(className);
                }
            }
            return super.findClass(className);
        }
    }
}

