/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.pnuts.lang.SubtypeGenerator;
import pnuts.compiler.ClassFile;
import pnuts.lang.Runtime;

public class Signature
extends Runtime
implements Cloneable {
    public static final int THIS = 1;
    public static final int SUPER = 2;
    String methodName;
    Class returnType;
    int modifiers;
    Class[] parameterTypes;
    Class[] exceptionTypes;
    public Object nodeInfo;

    public Signature(String methodName) {
        this(methodName, null, null, null);
    }

    public Signature(String methodName, Class returnType, Class[] parameterTypes, Class[] exceptionTypes) {
        this(methodName, returnType, parameterTypes, exceptionTypes, null);
    }

    public Signature(String methodName, Class returnType, Class[] parameterTypes, Class[] exceptionTypes, Object nodeInfo) {
        this.methodName = methodName;
        this.returnType = returnType;
        if (parameterTypes != null) {
            this.parameterTypes = (Class[])parameterTypes.clone();
        }
        if (exceptionTypes != null) {
            this.exceptionTypes = (Class[])exceptionTypes.clone();
        }
        this.nodeInfo = nodeInfo;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void generateMethod(ClassFile cf, int mode) {
        String sig = this.toString();
        SubtypeGenerator.defineMethod(cf, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.methodName, sig, mode);
    }

    boolean match(String methodName, Class returnType, Class[] parameterTypes, Class[] exceptionTypes) {
        if (this.methodName != null && !methodName.equals(this.methodName)) {
            return false;
        }
        if (this.returnType != null && !returnType.equals(this.returnType)) {
            return false;
        }
        if (this.parameterTypes != null && this.parameterTypes.length != parameterTypes.length) {
            return false;
        }
        if (this.parameterTypes != null) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class t = this.parameterTypes[i];
                if (t == null || parameterTypes[i].equals(t)) continue;
                return false;
            }
        }
        if (this.exceptionTypes != null) {
            HashSet<Class> s1 = new HashSet<Class>();
            for (int i = 0; i < exceptionTypes.length; ++i) {
                s1.add(exceptionTypes[i]);
            }
            HashSet<Class> s2 = new HashSet<Class>();
            for (int i = 0; i < this.exceptionTypes.length; ++i) {
                s2.add(this.exceptionTypes[i]);
            }
            if (!s1.equals(s2)) {
                return false;
            }
        }
        return true;
    }

    public boolean resolve(Class superClass, Class[] interfaces, Collection methods) {
        HashSet<String> signatures = new HashSet<String>();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Class _interface = interfaces[i];
                Method[] _methods = _interface.getMethods();
                for (int j = 0; j < _methods.length; ++j) {
                    Method m = _methods[j];
                    int modifiers = m.getModifiers();
                    if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                    Class[] parameterTypes = m.getParameterTypes();
                    Class[] exceptionTypes = m.getExceptionTypes();
                    String signature = this.methodName + ClassFile.signature(parameterTypes);
                    if (!this.match(m.getName(), m.getReturnType(), parameterTypes, exceptionTypes) || !signatures.add(ClassFile.signature(parameterTypes))) continue;
                    methods.add(m);
                }
            }
        }
        if (superClass == null) {
            Class clazz = superClass = Object.class;
        }
        while (superClass != null) {
            Method[] _methods = SubtypeGenerator.getInheritableMethods(superClass);
            for (int j = 0; j < _methods.length; ++j) {
                Method m = _methods[j];
                int modifiers = m.getModifiers();
                if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                Class[] parameterTypes = m.getParameterTypes();
                Class[] exceptionTypes = m.getExceptionTypes();
                String signature = this.methodName + ClassFile.signature(parameterTypes);
                if (!this.match(m.getName(), m.getReturnType(), parameterTypes, exceptionTypes) || !signatures.add(ClassFile.signature(parameterTypes))) continue;
                methods.add(m);
            }
            superClass = superClass.getSuperclass();
        }
        return !methods.isEmpty();
    }

    static void getInheritableConstructors(Class cls, Set signatures, Set results) {
        Constructor<?>[] c = cls.getDeclaredConstructors();
        for (int j = 0; j < c.length; ++j) {
            String sig;
            Constructor<?> cons = c[j];
            int modifiers = cons.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || !signatures.add(sig = ClassFile.signature(cons.getParameterTypes()))) continue;
            results.add(cons);
        }
    }

    static Constructor[] getInheritableConstructors(Class cls) {
        HashSet s = new HashSet();
        HashSet sig = new HashSet();
        Signature.getInheritableConstructors(cls, sig, s);
        return s.toArray(new Constructor[s.size()]);
    }

    public boolean resolveAsConstructor(Class cls, Collection constructors) {
        Constructor[] c = Signature.getInheritableConstructors(cls);
        for (int i = 0; i < c.length; ++i) {
            Class[] exceptionTypes;
            Constructor cons = c[i];
            Class[] parameterTypes = cons.getParameterTypes();
            if (!this.match(null, null, parameterTypes, exceptionTypes = cons.getExceptionTypes())) continue;
            constructors.add(cons);
        }
        return !constructors.isEmpty();
    }

    static String makeSignature(Class[] parameterTypes) {
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type = parameterTypes[i];
            if (type == null) {
                type = class$java$lang$Object == null ? Signature.class$("java.lang.Object") : class$java$lang$Object;
            }
            buf.append(Signature.makeSignature(type));
        }
        buf.append(")");
        return buf.toString();
    }

    static String makeSignature(Class[] parameterTypes, Class returnType) {
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type = parameterTypes[i];
            if (type == null) {
                type = class$java$lang$Object == null ? Signature.class$("java.lang.Object") : class$java$lang$Object;
            }
            buf.append(Signature.makeSignature(type));
        }
        buf.append(")");
        if (returnType == null) {
            returnType = Object.class;
        }
        buf.append(Signature.makeSignature(returnType));
        return buf.toString();
    }

    public static String makeSignature(Class type) {
        if (type == Integer.TYPE) {
            return "I";
        }
        if (type == Byte.TYPE) {
            return "B";
        }
        if (type == Long.TYPE) {
            return "J";
        }
        if (type == Character.TYPE) {
            return "C";
        }
        if (type == Short.TYPE) {
            return "S";
        }
        if (type == Float.TYPE) {
            return "F";
        }
        if (type == Double.TYPE) {
            return "D";
        }
        if (type == Boolean.TYPE) {
            return "Z";
        }
        if (type == Void.TYPE) {
            return "V";
        }
        if (type.isArray()) {
            return "[" + Signature.makeSignature(type.getComponentType());
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        if (this.methodName != null) {
            return this.methodName.hashCode() * this.parameterTypes.length;
        }
        return this.parameterTypes.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Signature) {
            Signature sig = (Signature)obj;
            return sig.toString().equals(this.toString());
        }
        return false;
    }

    public String toString() {
        if (this.methodName != null) {
            return (this.methodName + Signature.makeSignature(this.parameterTypes)).intern();
        }
        return Signature.makeSignature(this.parameterTypes).intern();
    }
}

