/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pnuts.lang.ClassFileLoader;
import org.pnuts.lang.Signature;
import pnuts.compiler.ClassFile;
import pnuts.compiler.ClassGenerator;
import pnuts.compiler.Compiler;
import pnuts.compiler.MultiClassLoader;
import pnuts.lang.Context;
import pnuts.lang.Function;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

public class SubtypeGenerator
extends Runtime {
    private static final boolean DEBUG = false;
    public static final int THIS = 1;
    public static final int SUPER = 2;
    private static final String SUPER_PROXY_NAME = "pnuts.compiler.ClassGenerator$SuperCallProxy";

    protected SubtypeGenerator() {
    }

    public static Class generateSubclass(Class superClass, Class[] interfaces, Package pkg, Context context, int mode) {
        String superClassName = superClass.getName();
        String className = superClassName.replace('.', '_') + "__adapter";
        return SubtypeGenerator.generateSubclass(className, superClass, interfaces, pkg, context, mode);
    }

    public static Class generateSubclass(String className, Class superClass, Class[] interfaces, Package pkg, Context context, int mode) {
        return SubtypeGenerator.generateSubclass(className, superClass, interfaces, null, pkg, context, mode);
    }

    public static Class generateSubclass(String className, Class superClass, Class[] interfaces, Signature[] sigs, Package pkg, Context context, int mode) {
        return SubtypeGenerator.generateSubclass(className, superClass, interfaces, sigs, pkg, null, context, mode);
    }

    public static Class generateSubclass(String className, Class superClass, Class[] interfaces, Signature[] sigs, Package pkg, Map typeMap, Context context, int mode) {
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ClassFileLoader handler = new ClassFileLoader(classLoader);
        handler.setup(pkg, context);
        ClassFile cf = SubtypeGenerator.getClassFileForSubclass(className, superClass, interfaces, pkg, typeMap, context, mode, sigs);
        return (Class)handler.handle(cf);
    }

    public static Object instantiateSubtype(Context context, Class superClass, Class[] interfaces, Package pkg, Object[] args) {
        try {
            if (superClass == null) {
                superClass = Object.class;
            }
            Class cls = SubtypeGenerator.generateSubclass(superClass, interfaces, pkg, context, 0);
            return Runtime.callConstructor(context, cls, args, null);
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
    }

    public static ClassFile getClassFileForSubclass(String className, Class superClass, Class[] interfaces, Package pkg, Context context, int mode) {
        return SubtypeGenerator.getClassFileForSubclass(className, superClass, interfaces, pkg, null, context, mode, null);
    }

    public static ClassFile getClassFileForSubclass(String className, Class superClass, Class[] interfaces, Package pkg, Map typeMap, Context context, int mode, Signature[] signatures) {
        ClassFile cf = ClassGenerator.createClassFile(className, superClass, interfaces, mode);
        SubtypeGenerator.constructor(cf, superClass);
        cf.openMethod("attach", "(Lpnuts/lang/Context;Lpnuts/lang/Package;)V", (short)9);
        cf.add((byte)42);
        cf.add((byte)-77, className, "_context", "Lpnuts/lang/Context;");
        cf.add((byte)43);
        cf.add((byte)-77, className, "_package", "Lpnuts/lang/Package;");
        cf.add((byte)-79);
        cf.closeMethod();
        if (typeMap != null) {
            Iterator it = typeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Class type = (Class)entry.getValue();
                cf.addField(name, Signature.makeSignature(type), (short)2);
            }
        }
        if (signatures != null && typeMap != null) {
            SubtypeGenerator.defineMethods(cf, pkg, superClass, interfaces, context, mode, signatures);
            HashSet<Signature> sigset = new HashSet<Signature>();
            for (int i = 0; i < signatures.length; ++i) {
                sigset.add(signatures[i]);
            }
            Iterator it = typeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Class type = (Class)entry.getValue();
                Signature s = Compiler.getterSignature(type, name);
                if (!sigset.contains(s)) {
                    Compiler.generateGetter(cf, name, type, s.getMethodName());
                }
                if (sigset.contains(s = Compiler.setterSignature(type, name))) continue;
                Compiler.generateSetter(cf, name, type, s.getMethodName());
            }
        } else {
            SubtypeGenerator.defineMethods(cf, pkg, superClass, interfaces, context, mode);
        }
        return cf;
    }

    static void defineMethods(ClassFile cf, Package pkg, Class superClass, Class[] interfaces, Context context, int mode, Signature[] signatures) {
        for (int i = 0; i < signatures.length; ++i) {
            Signature s = signatures[i];
            Object value = pkg.get(s.toString(), context);
            if (!(value instanceof PnutsFunction)) continue;
            PnutsFunction func = (PnutsFunction)value;
            ArrayList methods = new ArrayList();
            if (s.resolve(superClass, interfaces, methods)) {
                String sig = s.toString();
                Class returnType = s.returnType;
                if (returnType == null) {
                    returnType = class$java$lang$Object == null ? SubtypeGenerator.class$("java.lang.Object") : class$java$lang$Object;
                }
                SubtypeGenerator.defineMethod(cf, s.parameterTypes, returnType, s.exceptionTypes, s.modifiers, s.methodName, sig, mode);
                continue;
            }
            Enumeration e = SubtypeGenerator.getFunctions(func);
            while (e.hasMoreElements()) {
                Signature s2 = (Signature)s.clone();
                Function f = (Function)e.nextElement();
                int n = f.getNumberOfParameter();
                if ((mode & 1) == 1) {
                    --n;
                }
                if ((mode & 2) == 2) {
                    --n;
                }
                if (s.parameterTypes == null) {
                    Class[] p = new Class[n];
                    for (int j = 0; j < n; ++j) {
                        p[j] = class$java$lang$Object == null ? SubtypeGenerator.class$("java.lang.Object") : class$java$lang$Object;
                    }
                    s2.parameterTypes = p;
                } else {
                    for (int j = 0; j < n; ++j) {
                        if (s2.parameterTypes[j] != null) continue;
                        s2.parameterTypes[j] = class$java$lang$Object == null ? SubtypeGenerator.class$("java.lang.Object") : class$java$lang$Object;
                    }
                }
                if (s2.returnType == null) {
                    s2.returnType = class$java$lang$Object == null ? SubtypeGenerator.class$("java.lang.Object") : class$java$lang$Object;
                }
                String sig = s.methodName + Signature.makeSignature(s2.parameterTypes, s2.returnType);
                sig = sig.intern();
                pkg.set(sig, func, context);
                SubtypeGenerator.defineMethod(cf, s2.parameterTypes, s2.returnType, s.exceptionTypes, 1, s2.methodName, sig, mode);
            }
        }
    }

    static void defineMethods(ClassFile cf, Package pkg, Class superClass, Class[] interfaces, Context context, int mode) {
        Enumeration e = pkg.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = pkg.get(name, context);
            if (!(value instanceof PnutsFunction)) continue;
            PnutsFunction func = (PnutsFunction)value;
            String sig = name;
            String methodName = name;
            int idx = methodName.indexOf(40);
            if (idx >= 0) {
                methodName = methodName.substring(0, idx);
            }
            SubtypeGenerator.defineMethods(cf, methodName, sig, func, superClass, interfaces, context, mode);
        }
    }

    static int parseTypes(String sig, Context context, List types) {
        int idx = sig.indexOf(40);
        if (idx >= 0) {
            try {
                return SubtypeGenerator.parseParameterSignature(sig.substring(idx + 1), types, context) + idx + 1;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return -1;
    }

    static List returnTypeAndExceptions(String sig, Context context) {
        ArrayList types = new ArrayList();
        try {
            SubtypeGenerator.parseParameterSignature(sig, types, context);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return types;
    }

    public static void constructor(ClassFile cf, Class superClass) {
        SubtypeGenerator.constructor(cf, superClass, null, null, null);
    }

    public static void constructor(ClassFile cf, Class superClass, Compiler compiler, Context cc, List assignments) {
        String className = cf.getClassName();
        cf.addField("_superCallProxy", "Lpnuts/lang/AbstractData;", (short)2);
        if (superClass == null) {
            superClass = Object.class;
        }
        Constructor<?>[] constructors = superClass.getDeclaredConstructors();
        int count = 0;
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> cons = constructors[i];
            Class[] parameterTypes = cons.getParameterTypes();
            String sig = ClassFile.signature(parameterTypes);
            int mod = cons.getModifiers();
            if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod)) continue;
            ++count;
            cf.openMethod("<init>", sig + "V", (short)1);
            cf.add((byte)42);
            int k = 0;
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class type = parameterTypes[j];
                if (type == Integer.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Boolean.TYPE) {
                    cf.iloadLocal(1 + j + k);
                    continue;
                }
                if (type == Long.TYPE) {
                    cf.lloadLocal(1 + j + k);
                    ++k;
                    continue;
                }
                if (type == Float.TYPE) {
                    cf.floadLocal(1 + j + k);
                    continue;
                }
                if (type == Double.TYPE) {
                    cf.dloadLocal(1 + j + k);
                    ++k;
                    continue;
                }
                cf.loadLocal(1 + j + k);
            }
            cf.add((byte)-73, superClass.getName(), "<init>", sig, "V");
            SubtypeGenerator.assignSuperCallProxy(cf, className);
            if (compiler != null) {
                SubtypeGenerator.declareFields(cf, cc, compiler, assignments);
            }
            cf.add((byte)-79);
            cf.closeMethod();
        }
        if (count == 0) {
            cf.openMethod("<init>", "()V", (short)1);
            cf.add((byte)42);
            cf.add((byte)-73, superClass.getName(), "<init>", "()", "V");
            SubtypeGenerator.assignSuperCallProxy(cf, className);
            if (compiler != null) {
                SubtypeGenerator.declareFields(cf, cc, compiler, assignments);
            }
            cf.add((byte)-79);
            cf.closeMethod();
        }
    }

    private static void declareFields(ClassFile cf, Context cc, Compiler compiler, List assignments) {
        String className = cf.getClassName();
        int n = assignments.size();
        for (int i = 0; i < n; ++i) {
            SimpleNode assign = (SimpleNode)assignments.get(i);
            SimpleNode lhs = assign.jjtGetChild(0);
            SimpleNode rhs = assign.jjtGetChild(1);
            cf.add((byte)-78, className, "_context", "Lpnuts/lang/Context;");
            cf.add((byte)42);
            cf.add((byte)18, cf.addConstant(lhs.str));
            rhs.accept(compiler, cc);
            cf.add((byte)-72, "pnuts.lang.Runtime", "putField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)", "V");
        }
    }

    private static void assignSuperCallProxy(ClassFile cf, String className) {
        cf.add((byte)42);
        cf.add((byte)-69, SUPER_PROXY_NAME);
        cf.add((byte)89);
        cf.add((byte)42);
        cf.add((byte)-73, SUPER_PROXY_NAME, "<init>", "(Ljava/lang/Object;)", "V");
        cf.add((byte)-75, className, "_superCallProxy", "Lpnuts/lang/AbstractData;");
    }

    private static void defineMethods(ClassFile cf, String name, String sig, PnutsFunction func, Class superClass, Class[] interfaces, Context context, int mode) {
        Enumeration ee;
        Hashtable<String, String> methods = new Hashtable<String, String>();
        int count = 0;
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Class _interface = interfaces[i];
                Method[] _methods = _interface.getMethods();
                for (int j = 0; j < _methods.length; ++j) {
                    Method m = _methods[j];
                    int modifiers = m.getModifiers();
                    if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                    Class[] parameterTypes = m.getParameterTypes();
                    Class[] exceptionTypes = m.getExceptionTypes();
                    String signature = name + ClassFile.signature(parameterTypes);
                    int expected_args = parameterTypes.length;
                    if ((mode & 1) == 1) {
                        ++expected_args;
                    }
                    if ((mode & 2) == 2) {
                        ++expected_args;
                    }
                    if (!m.getName().equals(name) || !func.defined(expected_args)) continue;
                    if (sig == name) {
                        if (methods.get(signature) != null) continue;
                        SubtypeGenerator.defineMethod(cf, parameterTypes, m.getReturnType(), exceptionTypes, 1, name, sig, mode);
                        methods.put(signature, signature);
                        ++count;
                        continue;
                    }
                    if (!sig.equals(signature) || methods.get(signature) != null) continue;
                    SubtypeGenerator.defineMethod(cf, parameterTypes, m.getReturnType(), exceptionTypes, 1, name, sig, mode);
                    methods.put(signature, signature);
                    ++count;
                }
            }
        }
        if (superClass == null) {
            Class clazz = superClass = Object.class;
        }
        while (superClass != null) {
            Method[] _methods = SubtypeGenerator.getInheritableMethods(superClass);
            for (int j = 0; j < _methods.length; ++j) {
                Method m = _methods[j];
                int modifiers = m.getModifiers();
                if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                Class[] parameterTypes = m.getParameterTypes();
                Class[] exceptionTypes = m.getExceptionTypes();
                String signature = name + ClassFile.signature(parameterTypes);
                int expected_args = parameterTypes.length;
                if ((mode & 1) == 1) {
                    ++expected_args;
                }
                if ((mode & 2) == 2) {
                    ++expected_args;
                }
                if (!m.getName().equals(name) || !func.defined(expected_args)) continue;
                if (sig == name) {
                    if (methods.get(signature) != null) continue;
                    SubtypeGenerator.defineMethod(cf, parameterTypes, m.getReturnType(), exceptionTypes, 1, name, sig, mode);
                    methods.put(signature, signature);
                    ++count;
                    continue;
                }
                if (!sig.equals(signature) || methods.get(signature) != null) continue;
                SubtypeGenerator.defineMethod(cf, parameterTypes, m.getReturnType(), exceptionTypes, 1, name, sig, mode);
                methods.put(signature, signature);
                ++count;
            }
            superClass = superClass.getSuperclass();
        }
        if (count == 0 && (ee = SubtypeGenerator.getFunctions(func)) != null) {
            Class returnType;
            Function f = (Function)ee.nextElement();
            int narg = f.getNumberOfParameter();
            if ((mode & 1) == 1 && narg > 0) {
                --narg;
            }
            if ((mode & 2) == 2 && narg > 0) {
                --narg;
            }
            Class[] parameterTypes = new Class[narg];
            Class[] exceptionTypes = null;
            List types = null;
            int pos = -1;
            if (sig != name) {
                types = new ArrayList();
                pos = SubtypeGenerator.parseTypes(sig, context, types);
            }
            if (pos == -1) {
                for (int i = 0; i < narg; ++i) {
                    parameterTypes[i] = class$java$lang$Object == null ? SubtypeGenerator.class$("java.lang.Object") : class$java$lang$Object;
                }
                returnType = Object.class;
            } else {
                int i;
                for (i = 0; i < narg; ++i) {
                    parameterTypes[i] = (Class)types.get(i);
                }
                types = SubtypeGenerator.returnTypeAndExceptions(sig.substring(pos), context);
                returnType = (Class)types.get(0);
                if (types.size() > 1) {
                    exceptionTypes = new Class[types.size() - 1];
                    for (i = 0; i < exceptionTypes.length; ++i) {
                        exceptionTypes[i] = (Class)types.get(1 + i);
                    }
                }
            }
            SubtypeGenerator.defineMethod(cf, parameterTypes, returnType, exceptionTypes, 1, name, sig, mode);
        }
    }

    static Method[] getInheritableMethods(Class cls) {
        HashSet s = new HashSet();
        HashSet m = new HashSet();
        for (Class c = cls; c != null; c = c.getSuperclass()) {
            SubtypeGenerator.getInheritableMethods(c, s, m);
        }
        Method[] results = new Method[m.size()];
        return m.toArray(results);
    }

    static void getInheritableMethods(Class cls, Set signatures, Set methods) {
        Method[] _methods = cls.getDeclaredMethods();
        for (int j = 0; j < _methods.length; ++j) {
            String sig;
            Method m = _methods[j];
            int modifiers = m.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || !signatures.add(sig = m.getName() + ClassFile.signature(m.getParameterTypes()))) continue;
            methods.add(m);
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int j = 0; j < interfaces.length; ++j) {
            SubtypeGenerator.getInheritableMethods(interfaces[j], signatures, methods);
        }
    }

    public static void defineMethod(ClassFile cf, Class[] parameterTypes, Class returnType, Class[] exceptionTypes, int modifiers, String methodName, String sig, int mode) {
        ClassGenerator.defineMethod(cf, parameterTypes, returnType, exceptionTypes, modifiers, methodName, sig, mode);
    }

    private static int parseParameterSignature(String signature, List types, Context context) throws ClassNotFoundException {
        char[] c = signature.toCharArray();
        int index = 0;
        int dim = 0;
        block14: while (index < c.length) {
            switch (c[index]) {
                case 'V': {
                    types.add(Void.TYPE);
                    dim = 0;
                    ++index;
                    break;
                }
                case 'J': {
                    types.add(Runtime.arrayType(Long.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case 'D': {
                    types.add(Runtime.arrayType(Double.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case 'B': {
                    types.add(Runtime.arrayType(Byte.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case 'S': {
                    types.add(Runtime.arrayType(Short.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case 'C': {
                    types.add(Runtime.arrayType(Character.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case 'I': {
                    types.add(Runtime.arrayType(Integer.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case 'Z': {
                    types.add(Runtime.arrayType(Boolean.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case 'F': {
                    types.add(Runtime.arrayType(Float.TYPE, dim));
                    dim = 0;
                    ++index;
                    break;
                }
                case '[': {
                    while (c[index] == '[') {
                        ++dim;
                        ++index;
                    }
                    continue block14;
                }
                case 'L': {
                    int start = index + 1;
                    while (c[index++] != ';') {
                    }
                    String cn = new String(c, start, index - start - 1);
                    types.add(Runtime.arrayType(Pnuts.loadClass(cn.replace('/', '.'), context), dim));
                    dim = 0;
                    break;
                }
                case ')': {
                    ++index;
                    break block14;
                }
                default: {
                    throw new PnutsException("illegal method signature", context);
                }
            }
        }
        return index;
    }

    public static Class generateInterface(String name, Class[] superInterfaces, String[] signatures, Context context) {
        return SubtypeGenerator.generateInterface(name, superInterfaces, signatures, context, (short)513);
    }

    public static Class generateInterface(String name, Class[] superInterfaces, String[] signatures, Context context, short modifiers) {
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ClassFileLoader handler = new ClassFileLoader(classLoader);
        ClassFile cf = SubtypeGenerator.getClassFileForInterface(name, superInterfaces, signatures, context, modifiers);
        return (Class)handler.handle(cf);
    }

    public static ClassFile getClassFileForInterface(String name, Class[] superInterfaces, String[] signatures, Context context, short modifiers) {
        int i;
        ClassFile cf = new ClassFile(name, "java.lang.Object", null, modifiers);
        if (superInterfaces != null) {
            for (i = 0; i < superInterfaces.length; ++i) {
                cf.addInterface(superInterfaces[i].getName());
            }
        }
        if (signatures != null) {
            for (i = 0; i < signatures.length; ++i) {
                String sig = signatures[i];
                ArrayList types = new ArrayList();
                int idx0 = sig.indexOf(40);
                if (idx0 < 0) continue;
                String methodName = sig.substring(0, idx0);
                int idx = SubtypeGenerator.parseTypes(sig, context, types);
                Class[] parameterTypes = new Class[types.size()];
                types.toArray(parameterTypes);
                if (idx <= 0) continue;
                List types2 = SubtypeGenerator.returnTypeAndExceptions(sig.substring(idx), context);
                Class returnType = (Class)types2.get(0);
                String[] exceptionTypeInfo = null;
                if (types2.size() > 1) {
                    exceptionTypeInfo = new String[types2.size() - 1];
                    for (int j = 0; j < exceptionTypeInfo.length; ++j) {
                        exceptionTypeInfo[j] = ((Class)types2.get(j + 1)).getName();
                    }
                }
                cf.openMethod(methodName, Signature.makeSignature(parameterTypes, returnType), (short)1025, exceptionTypeInfo);
                cf.closeMethod();
            }
        }
        return cf;
    }

    public static ClassLoader mergeClassLoader(Class[] types, ClassLoader loader) {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            try {
                if (loader.loadClass(type.getName()) == type) {
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            classLoaders.add(type.getClassLoader());
        }
        int size = classLoaders.size();
        if (size > 0) {
            ClassLoader[] cl = new ClassLoader[size];
            classLoaders.toArray(cl);
            return new MultiClassLoader(loader, cl);
        }
        return loader;
    }
}

