/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.lang;

import pnuts.lang.Context;
import pnuts.lang.SimpleNode;
import pnuts.lang.Visitor;

public class UnparseVisitor
implements Visitor {
    private StringBuffer sbuf;
    private boolean escape;
    private static String indent = " ";
    private int nest = 0;

    public UnparseVisitor(StringBuffer sbuf) {
        this(sbuf, false);
    }

    public UnparseVisitor(StringBuffer sbuf, boolean escape) {
        this.sbuf = sbuf;
        this.escape = escape;
    }

    void operand(SimpleNode node, int idx) {
        int id = node.jjtGetChild((int)idx).id;
        if (id == 7 || id == 25 || id == 33 || id == 29 || id == 31 || id == 32 || id == 28 || id == 30 || id == 78 || id == 34 || id == 35 || id == 36 || id == 37 || id == 38 || id == 39 || id == 40) {
            this.accept(node, idx);
        } else if (id == 4) {
            this.paramList(node.jjtGetChild(idx));
        } else {
            this.sbuf.append('(');
            this.accept(node, idx);
            this.sbuf.append(')');
        }
    }

    Object binary(SimpleNode node, String operator) {
        this.operand(node, 0);
        this.sbuf.append(' ');
        this.sbuf.append(operator);
        this.sbuf.append(' ');
        this.operand(node, 1);
        return null;
    }

    public Object startSet(SimpleNode node, Context context) {
        this.expressionList(node, context, '\n');
        return null;
    }

    public Object start(SimpleNode node, Context context) {
        node.jjtGetChild(0).accept(this, context);
        return null;
    }

    public Object expressionList(SimpleNode node, Context context) {
        this.expressionList(node, context, ';');
        return null;
    }

    public Object expressionList(SimpleNode node, Context context, char delimiter) {
        int num = node.jjtGetNumChildren();
        if (num > 0) {
            this.accept(node, 0);
            for (int i = 1; i < num; ++i) {
                this.sbuf.append(delimiter);
                this.accept(node, i);
            }
        }
        return null;
    }

    static String strip(String name) {
        if (name == null) {
            return null;
        }
        int idx = name.indexOf(33);
        if (idx < 0) {
            return name;
        }
        if (idx == 0) {
            return null;
        }
        return name.substring(0, idx);
    }

    public Object idNode(SimpleNode node, Context context) {
        String s = UnparseVisitor.strip(node.str);
        if (s == null) {
            return null;
        }
        this.sbuf.append(s);
        int dim = node.jjtGetNumChildren();
        for (int i = 0; i < dim; ++i) {
            this.sbuf.append("[]");
        }
        return null;
    }

    public Object global(SimpleNode node, Context context) {
        this.sbuf.append("::");
        this.sbuf.append(node.str);
        return null;
    }

    public Object className(SimpleNode node, Context context) {
        this.sbuf.append(node.jjtGetChild((int)0).str);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            this.sbuf.append('.');
            this.sbuf.append(node.jjtGetChild((int)i).str);
        }
        return null;
    }

    public Object arrayType(SimpleNode node, Context context) {
        this.accept(node, 0);
        this.sbuf.append("[]");
        return null;
    }

    public Object listElements(SimpleNode node, Context context) {
        return this.listElements(node, context, "[", "]");
    }

    public Object mapNode(SimpleNode node, Context context) {
        this.sbuf.append('{');
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            SimpleNode c = node.jjtGetChild(0);
            this.accept(c, 0);
            this.sbuf.append(" => ");
            this.accept(c, 1);
        }
        for (int i = 1; i < n; ++i) {
            this.sbuf.append(", ");
            SimpleNode c = node.jjtGetChild(i);
            this.accept(c, 0);
            this.sbuf.append(" => ");
            this.accept(c, 1);
        }
        this.sbuf.append('}');
        return null;
    }

    public Object listElements(SimpleNode node, Context context, String d1, String d2) {
        int n;
        if (d1 != null) {
            this.sbuf.append(d1);
        }
        if ((n = node.jjtGetNumChildren()) > 0) {
            this.accept(node, 0);
            for (int i = 1; i < n; ++i) {
                this.sbuf.append(", ");
                this.accept(node, i);
            }
        }
        if (d2 != null) {
            this.sbuf.append(d2);
        }
        return null;
    }

    void paramList(SimpleNode args) {
        int nargs = args.jjtGetNumChildren();
        if (nargs > 0) {
            this.sbuf.append(UnparseVisitor.strip(args.jjtGetChild((int)0).str));
        }
        for (int i = 1; i < nargs; ++i) {
            this.sbuf.append(", ");
            this.sbuf.append(UnparseVisitor.strip(args.jjtGetChild((int)i).str));
        }
    }

    public Object castExpression(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 2) {
            this.sbuf.append('(');
            SimpleNode target = node.jjtGetChild(1);
            int id = target.id;
            if (id == 7 || id == 25 || id == 33 || id == 29 || id == 31 || id == 32 || id == 28 || id == 30 || id == 78 || id == 34 || id == 35 || id == 36 || id == 37 || id == 38 || id == 39 || id == 40) {
                this.type(node.jjtGetChild(0));
                this.sbuf.append(')');
                target.accept(this, context);
            } else {
                this.type(node.jjtGetChild(0));
                this.sbuf.append(")(");
                target.accept(this, context);
                this.sbuf.append(')');
            }
        } else {
            this.accept(node, 0);
        }
        return null;
    }

    public Object classNode(SimpleNode node, Context context) {
        int i;
        this.sbuf.append("class");
        int n = node.jjtGetNumChildren();
        if (node.str != null) {
            this.sbuf.append(' ');
            this.sbuf.append(node.str);
        }
        int dim = 0;
        for (i = 0; i < n; ++i) {
            SimpleNode ch = node.jjtGetChild(i);
            if (ch.id == 27) {
                this.sbuf.append('.');
                this.sbuf.append(ch.str);
                continue;
            }
            if (ch.id != 24) continue;
            ++dim;
        }
        for (i = 0; i < dim; ++i) {
            this.sbuf.append("[]");
        }
        return null;
    }

    public Object newNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        SimpleNode n0 = node.jjtGetChild(0);
        this.sbuf.append("new ");
        if (n == 3 && node.jjtGetChild((int)2).id == 21) {
            this.type(n0);
            this.listElements(node.jjtGetChild(1), context, "(", ")");
            SimpleNode classDefBody = node.jjtGetChild(2);
            classDefBody.accept(this, context);
        } else if (n0.id == 25) {
            SimpleNode n1 = n0;
            while (n1.id == 25) {
                n1 = n1.jjtGetChild(0);
            }
            this.type(n1);
            for (n1 = n1.jjtGetParent(); n1 != n0; n1 = n1.jjtGetParent()) {
                this.sbuf.append('[');
                this.accept(n1, 1);
                this.sbuf.append(']');
            }
            this.sbuf.append('[');
            this.accept(n1, 1);
            this.sbuf.append(']');
        } else if (n0.id == 24) {
            this.arrayType(n0, context);
        } else if (n0.id == 20) {
            this.type(n0.jjtGetChild(0));
            this.listElements(n0.jjtGetChild(1), context, "{", "}");
        } else {
            this.type(node.jjtGetChild(0));
            this.listElements(node.jjtGetChild(1), context, "(", ")");
        }
        return null;
    }

    public Object classScript(SimpleNode node, Context context) {
        return null;
    }

    public Object classDef(SimpleNode node, Context context) {
        this.sbuf.append("class ");
        this.className(node.jjtGetChild(0), context);
        SimpleNode ext = node.jjtGetChild(1);
        SimpleNode impl = node.jjtGetChild(2);
        SimpleNode classDefBody = node.jjtGetChild(3);
        if (ext.jjtGetNumChildren() > 0) {
            this.sbuf.append(" extends ");
            this.className(ext.jjtGetChild(0), context);
        }
        if (impl.jjtGetNumChildren() > 0) {
            this.sbuf.append(" implements ");
            int num = impl.jjtGetNumChildren();
            if (num > 0) {
                this.className(impl.jjtGetChild(0), context);
            }
            for (int i = 1; i < num; ++i) {
                this.sbuf.append(", ");
                this.className(impl.jjtGetChild(i), context);
            }
        }
        classDefBody.accept(this, context);
        return null;
    }

    public Object classDefBody(SimpleNode node, Context context) {
        this.sbuf.append("{");
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            this.sbuf.append("\n");
            SimpleNode c = node.jjtGetChild(i);
            if (c.id == 22) {
                SimpleNode c2 = c.jjtGetChild(0);
                this.type(c2);
                this.sbuf.append(" ");
                this.sbuf.append(c.str);
                if (c.jjtGetNumChildren() <= 1) continue;
                SimpleNode c3 = c.jjtGetChild(1);
                this.sbuf.append(" = ");
                c3.accept(this, context);
                continue;
            }
            this.methodDef(c, context);
        }
        this.sbuf.append("\n}");
        return null;
    }

    public Object methodDef(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 2) {
            this.sbuf.append(node.str);
            this.typedParamList(node.jjtGetChild(0), context);
            node.jjtGetChild(1).accept(this, context);
        } else if (n == 3) {
            this.type(node.jjtGetChild(0));
            this.typedParamList(node.jjtGetChild(1), context);
            node.jjtGetChild(2).accept(this, context);
        } else {
            throw new InternalError();
        }
        return null;
    }

    public Object typedParamList(SimpleNode node, Context context) {
        this.sbuf.append("(");
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            SimpleNode p = node.jjtGetChild(0);
            this.typedParam(p, context);
        }
        for (int i = 1; i < n; ++i) {
            this.sbuf.append(",");
            SimpleNode p = node.jjtGetChild(i);
            this.typedParam(p, context);
        }
        this.sbuf.append(")");
        return null;
    }

    public Object typedParam(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 2) {
            SimpleNode t = node.jjtGetChild(0);
            this.type(t);
            this.sbuf.append(' ');
            this.sbuf.append(node.jjtGetChild((int)1).str);
        } else if (n == 1) {
            this.sbuf.append(node.jjtGetChild((int)0).str);
        } else {
            throw new InternalError();
        }
        return null;
    }

    public Object primitiveNode(SimpleNode node, Context context) {
        this.sbuf.append(node.str);
        return null;
    }

    public Object packageNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        this.sbuf.append("package");
        if (node.str != null) {
            this.sbuf.append("(");
            if (n > 0) {
                node.jjtGetChild(0).accept(this, context);
            }
        } else {
            this.sbuf.append(" ");
            SimpleNode p0 = node.jjtGetChild(0);
            this.sbuf.append(p0.str);
            for (int i = 1; i < n; ++i) {
                this.sbuf.append(".");
                this.sbuf.append(node.jjtGetChild((int)i).str);
            }
        }
        if (node.str != null) {
            this.sbuf.append(")");
        } else {
            this.sbuf.append("\n");
        }
        return null;
    }

    public Object importNode(SimpleNode node, Context context) {
        int n;
        this.sbuf.append("import ");
        if ("static".equals(node.info)) {
            this.sbuf.append("static ");
        }
        if ((n = node.jjtGetNumChildren()) == 0 && "*".equals(node.str)) {
            this.sbuf.append('*');
            return null;
        }
        if ("(".equals(node.str)) {
            this.sbuf.append('(');
            if (n == 1) {
                this.accept(node, 0);
            }
            this.sbuf.append(')');
            return null;
        }
        this.sbuf.append(node.jjtGetChild((int)0).str);
        for (int i = 1; i < n; ++i) {
            this.sbuf.append('.');
            this.sbuf.append(node.jjtGetChild((int)i).str);
        }
        if ("*".equals(node.str)) {
            this.sbuf.append(".*");
        }
        return null;
    }

    public Object rangeNode(SimpleNode node, Context context) {
        if (node.jjtGetNumChildren() == 3) {
            this.accept(node, 0);
            this.sbuf.append('[');
            this.accept(node, 1);
            this.sbuf.append("..");
            this.accept(node, 2);
            this.sbuf.append(']');
        } else {
            this.accept(node, 0);
            this.sbuf.append('[');
            this.accept(node, 1);
            this.sbuf.append("..]");
        }
        return null;
    }

    public Object indexNode(SimpleNode node, Context context) {
        this.accept(node, 0);
        this.sbuf.append('[');
        this.accept(node, 1);
        this.sbuf.append(']');
        return null;
    }

    public Object methodNode(SimpleNode node, Context context) {
        int id = node.jjtGetChild((int)0).id;
        if (id == 34 || id == 35) {
            this.sbuf.append('(');
            this.accept(node, 0);
            this.sbuf.append(')');
        } else {
            this.accept(node, 0);
        }
        this.sbuf.append('.');
        this.sbuf.append(node.str);
        this.listElements(node.jjtGetChild(1), context, "(", ")");
        return null;
    }

    public Object staticMethodNode(SimpleNode node, Context context) {
        this.accept(node, 0);
        this.sbuf.append("::");
        this.sbuf.append(node.str);
        this.listElements(node.jjtGetChild(1), context, "(", ")");
        return null;
    }

    public Object memberNode(SimpleNode node, Context context) {
        int id = node.jjtGetChild((int)0).id;
        if (id == 34 || id == 35) {
            this.sbuf.append('(');
            this.accept(node, 0);
            this.sbuf.append(')');
        } else {
            this.accept(node, 0);
        }
        this.sbuf.append('.');
        this.sbuf.append(node.str);
        return null;
    }

    public Object staticMemberNode(SimpleNode node, Context context) {
        this.accept(node, 0);
        this.sbuf.append("::");
        this.sbuf.append(node.str);
        return null;
    }

    public Object applicationNode(SimpleNode node, Context context) {
        SimpleNode n0 = node.jjtGetChild(0);
        if (n0.str != null && n0.str.startsWith("!<closure")) {
            this.sbuf.append("yield ");
            this.listElements(node.jjtGetChild(1), context, "", "");
        } else {
            this.accept(node, 0);
            this.listElements(node.jjtGetChild(1), context, "(", ")");
        }
        return null;
    }

    public Object integerNode(SimpleNode node, Context context) {
        this.sbuf.append(node.str);
        return null;
    }

    public Object floatingNode(SimpleNode node, Context context) {
        this.sbuf.append(node.str);
        return null;
    }

    public Object characterNode(SimpleNode node, Context context) {
        this.sbuf.append(node.str);
        return null;
    }

    String unparseString(String value, boolean escape) {
        if (escape) {
            this.sbuf.append('\\');
        }
        this.sbuf.append('\"');
        char[] c = value.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\"') {
                this.sbuf.append("\\\"");
                continue;
            }
            if (c[i] == '\\') {
                this.sbuf.append("\\\\");
                continue;
            }
            if (c[i] == '\n') {
                this.sbuf.append("\\n");
                continue;
            }
            if (c[i] == '\t') {
                this.sbuf.append("\\t");
                continue;
            }
            if (c[i] == '\r') {
                this.sbuf.append("\\r");
                continue;
            }
            if (c[i] == '\f') {
                this.sbuf.append("\\f");
                continue;
            }
            if (c[i] == '\b') {
                this.sbuf.append("\\b");
                continue;
            }
            if (c[i] == '\u0000') {
                this.sbuf.append("\\0");
                continue;
            }
            this.sbuf.append(c[i]);
        }
        if (escape) {
            this.sbuf.append('\\');
        }
        this.sbuf.append('\"');
        return null;
    }

    public Object stringNode(SimpleNode node, Context context) {
        return this.unparseString(node.str, this.escape);
    }

    public Object trueNode(SimpleNode node, Context context) {
        this.sbuf.append("true");
        return null;
    }

    public Object falseNode(SimpleNode node, Context context) {
        this.sbuf.append("false");
        return null;
    }

    public Object nullNode(SimpleNode node, Context context) {
        this.sbuf.append("null");
        return null;
    }

    public Object assignment(SimpleNode node, Context context) {
        return this.binary(node, "=");
    }

    public Object assignmentTA(SimpleNode node, Context context) {
        return this.binary(node, "*=");
    }

    public Object assignmentMA(SimpleNode node, Context context) {
        return this.binary(node, "%=");
    }

    public Object assignmentDA(SimpleNode node, Context context) {
        return this.binary(node, "/=");
    }

    public Object assignmentPA(SimpleNode node, Context context) {
        return this.binary(node, "+=");
    }

    public Object assignmentSA(SimpleNode node, Context context) {
        return this.binary(node, "-=");
    }

    public Object assignmentLA(SimpleNode node, Context context) {
        return this.binary(node, "<<=");
    }

    public Object assignmentRA(SimpleNode node, Context context) {
        return this.binary(node, ">>=");
    }

    public Object assignmentRAA(SimpleNode node, Context context) {
        return this.binary(node, ">>>=");
    }

    public Object assignmentAA(SimpleNode node, Context context) {
        return this.binary(node, "&=");
    }

    public Object assignmentEA(SimpleNode node, Context context) {
        return this.binary(node, "^=");
    }

    public Object assignmentOA(SimpleNode node, Context context) {
        return this.binary(node, "|=");
    }

    public Object logAndNode(SimpleNode node, Context context) {
        return this.binary(node, "&&");
    }

    public Object logOrNode(SimpleNode node, Context context) {
        return this.binary(node, "||");
    }

    public Object logNotNode(SimpleNode node, Context context) {
        this.sbuf.append('!');
        this.operand(node, 0);
        return null;
    }

    public Object orNode(SimpleNode node, Context context) {
        return this.binary(node, "|");
    }

    public Object xorNode(SimpleNode node, Context context) {
        return this.binary(node, "^");
    }

    public Object andNode(SimpleNode node, Context context) {
        return this.binary(node, "&");
    }

    public Object equalNode(SimpleNode node, Context context) {
        return this.binary(node, "==");
    }

    public Object notEqNode(SimpleNode node, Context context) {
        return this.binary(node, "!=");
    }

    void type(SimpleNode node) {
        int i;
        int dim = 0;
        while (node.id == 24) {
            ++dim;
            node = node.jjtGetChild(0);
        }
        SimpleNode ch = node.jjtGetChild(0);
        this.sbuf.append(ch.str);
        int n = node.jjtGetNumChildren();
        for (i = 1; i < n; ++i) {
            ch = node.jjtGetChild(i);
            if (ch.id != 27) continue;
            this.sbuf.append('.');
            this.sbuf.append(ch.str);
        }
        for (i = 0; i < dim; ++i) {
            this.sbuf.append("[]");
        }
    }

    public Object instanceofExpression(SimpleNode node, Context context) {
        this.accept(node, 0);
        this.sbuf.append(" instanceof ");
        this.type(node.jjtGetChild(1));
        return null;
    }

    public Object ltNode(SimpleNode node, Context context) {
        return this.binary(node, "<");
    }

    public Object gtNode(SimpleNode node, Context context) {
        return this.binary(node, ">");
    }

    public Object leNode(SimpleNode node, Context context) {
        return this.binary(node, "<=");
    }

    public Object geNode(SimpleNode node, Context context) {
        return this.binary(node, ">=");
    }

    public Object shiftLeftNode(SimpleNode node, Context context) {
        return this.binary(node, "<<");
    }

    public Object shiftRightNode(SimpleNode node, Context context) {
        return this.binary(node, ">>");
    }

    public Object shiftArithmeticNode(SimpleNode node, Context context) {
        return this.binary(node, ">>>");
    }

    public Object addNode(SimpleNode node, Context context) {
        return this.binary(node, "+");
    }

    public Object subtractNode(SimpleNode node, Context context) {
        return this.binary(node, "-");
    }

    public Object multNode(SimpleNode node, Context context) {
        return this.binary(node, "*");
    }

    public Object divideNode(SimpleNode node, Context context) {
        return this.binary(node, "/");
    }

    public Object modNode(SimpleNode node, Context context) {
        return this.binary(node, "%");
    }

    public Object negativeNode(SimpleNode node, Context context) {
        this.sbuf.append('-');
        this.operand(node, 0);
        return null;
    }

    public Object preIncrNode(SimpleNode node, Context context) {
        this.sbuf.append("++");
        this.operand(node, 0);
        return null;
    }

    public Object preDecrNode(SimpleNode node, Context context) {
        this.sbuf.append("--");
        this.operand(node, 0);
        return null;
    }

    public Object postIncrNode(SimpleNode node, Context context) {
        this.operand(node, 0);
        this.sbuf.append("++");
        return null;
    }

    public Object postDecrNode(SimpleNode node, Context context) {
        this.operand(node, 0);
        this.sbuf.append("--");
        return null;
    }

    public Object notNode(SimpleNode node, Context context) {
        this.sbuf.append('~');
        this.operand(node, 0);
        return null;
    }

    public Object continueNode(SimpleNode node, Context context) {
        this.sbuf.append("continue");
        return null;
    }

    public Object breakNode(SimpleNode node, Context context) {
        this.sbuf.append("break");
        if (node.jjtGetNumChildren() > 0) {
            this.accept(node, 0);
        }
        return null;
    }

    public Object returnNode(SimpleNode node, Context context) {
        this.sbuf.append("return");
        int n = node.jjtGetNumChildren();
        if (n == 1) {
            this.sbuf.append(' ');
            this.accept(node, 0);
        }
        return null;
    }

    public Object yieldNode(SimpleNode node, Context context) {
        this.sbuf.append("yield");
        int n = node.jjtGetNumChildren();
        if (n == 1) {
            this.sbuf.append(' ');
            this.accept(node, 0);
        }
        return null;
    }

    public Object catchNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            this.sbuf.append("catch");
            return null;
        }
        this.sbuf.append("catch");
        this.sbuf.append('(');
        this.accept(node, 0);
        this.sbuf.append(", ");
        this.accept(node, 1);
        this.sbuf.append(')');
        return null;
    }

    public Object throwNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            this.sbuf.append("throw");
        } else {
            this.sbuf.append("throw ");
            this.accept(node, 0);
        }
        return null;
    }

    public Object finallyNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            this.sbuf.append("finally");
            return null;
        }
        this.sbuf.append("finally(");
        if (n == 1) {
            this.accept(node, 0);
            this.sbuf.append(')');
        } else if (n == 2) {
            this.accept(node, 0);
            this.sbuf.append(", ");
            this.accept(node, 1);
            this.sbuf.append(')');
        }
        return null;
    }

    public Object tryStatement(SimpleNode node, Context context) {
        this.sbuf.append("try ");
        this.accept(node, 0);
        int n = node.jjtGetNumChildren();
        for (int i = 1; i < n; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            if (c.id == 96) {
                this.sbuf.append(" finally ");
                this.accept(c, 0);
                break;
            }
            if (c.id != 92) continue;
            this.sbuf.append(" catch (");
            SimpleNode type = c.jjtGetChild(0);
            int n2 = type.jjtGetNumChildren();
            this.sbuf.append(type.jjtGetChild((int)0).str);
            for (int j = 1; j < n2; ++j) {
                this.sbuf.append('.');
                this.sbuf.append(type.jjtGetChild((int)j).str);
            }
            this.sbuf.append(' ');
            this.sbuf.append(c.str);
            this.sbuf.append(") ");
            this.accept(c, 1);
        }
        return null;
    }

    public Object catchBlock(SimpleNode node, Context context) {
        return null;
    }

    public Object blockNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n >= 1) {
            int i;
            Object s = null;
            if (this.escape) {
                this.sbuf.append("{\\n");
            } else {
                this.sbuf.append("{\n");
            }
            ++this.nest;
            for (i = 0; i < this.nest; ++i) {
                this.sbuf.append(indent);
            }
            this.accept(node, 0);
            for (i = 1; i < n; ++i) {
                if (this.escape) {
                    this.sbuf.append("\\n");
                } else {
                    this.sbuf.append('\n');
                }
                for (int j = 0; j < this.nest; ++j) {
                    this.sbuf.append(indent);
                }
                this.accept(node, i);
            }
            --this.nest;
            if (this.escape) {
                this.sbuf.append("\\n");
            } else {
                this.sbuf.append('\n');
            }
            for (i = 0; i < this.nest; ++i) {
                this.sbuf.append(indent);
            }
            this.sbuf.append('}');
        } else {
            this.sbuf.append("{}");
        }
        return null;
    }

    public Object ifStatement(SimpleNode node, Context context) {
        this.sbuf.append("if (");
        this.accept(node, 0);
        this.sbuf.append(") ");
        this.accept(node, 1);
        int n = node.jjtGetNumChildren();
        for (int i = 2; i < n; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            if (c.id == 88) {
                this.sbuf.append(" else if (");
                this.accept(c, 0);
                this.sbuf.append(") ");
                this.accept(c, 1);
                continue;
            }
            if (c.id != 89) continue;
            this.sbuf.append(" else ");
            this.accept(c, 0);
        }
        return null;
    }

    public Object doStatement(SimpleNode node, Context context) {
        this.sbuf.append("do {");
        this.accept(node, 0);
        this.sbuf.append("} while (");
        this.accept(node, 1);
        this.sbuf.append(')');
        return null;
    }

    public Object whileStatement(SimpleNode node, Context context) {
        this.sbuf.append("while (");
        this.accept(node, 0);
        this.sbuf.append(") ");
        this.accept(node, 1);
        return null;
    }

    public Object forStatement(SimpleNode node, Context context) {
        SimpleNode initNode = null;
        SimpleNode condNode = null;
        SimpleNode updateNode = null;
        SimpleNode blockNode = null;
        this.sbuf.append("for (");
        int j = 0;
        SimpleNode n = node.jjtGetChild(j);
        if (n.id == 99) {
            SimpleNode node0 = n.jjtGetChild(0);
            if (node0.id == 4) {
                int nc2 = node0.jjtGetNumChildren();
                if (nc2 > 0) {
                    this.sbuf.append(node0.jjtGetChild((int)0).str);
                    for (int i = 1; i < nc2; ++i) {
                        this.sbuf.append(',');
                        this.sbuf.append(node0.jjtGetChild((int)i).str);
                    }
                }
            } else {
                this.sbuf.append(UnparseVisitor.strip(n.str));
            }
            this.sbuf.append(':');
            int nc = n.jjtGetNumChildren();
            if (node0.id == 4) {
                this.accept(n, 1);
            } else {
                this.accept(n, 0);
                if (nc == 2) {
                    this.sbuf.append("..");
                    this.accept(n, 1);
                }
            }
            this.sbuf.append(')');
            ++j;
        } else {
            if (n.id == 100) {
                initNode = n;
                ++j;
            }
            n = node.jjtGetChild(j);
            if (n.id != 101 && n.id != 9) {
                condNode = n;
                ++j;
            }
            n = node.jjtGetChild(j);
            if (n.id == 101) {
                updateNode = n;
                ++j;
            }
            if (initNode != null) {
                int num = initNode.jjtGetNumChildren();
                SimpleNode sn = null;
                if (num > 0) {
                    sn = initNode.jjtGetChild(0);
                    this.sbuf.append(UnparseVisitor.strip(sn.str));
                    this.sbuf.append('=');
                    this.accept(sn, 0);
                }
                for (int i = 1; i < num; ++i) {
                    sn = initNode.jjtGetChild(i);
                    this.sbuf.append(',');
                    this.sbuf.append(UnparseVisitor.strip(sn.str));
                    this.sbuf.append('=');
                    this.accept(sn, 0);
                }
            }
            this.sbuf.append(';');
            if (condNode != null) {
                condNode.accept(this, context);
            }
            this.sbuf.append(';');
            if (updateNode != null) {
                this.expressionList(updateNode, context, ',');
            }
            this.sbuf.append(") ");
        }
        blockNode = node.jjtGetChild(j);
        blockNode.accept(this, context);
        return null;
    }

    public Object foreachStatement(SimpleNode node, Context context) {
        this.sbuf.append("foreach ");
        this.sbuf.append(UnparseVisitor.strip(node.str));
        this.sbuf.append(" (");
        this.accept(node, 0);
        this.sbuf.append(") ");
        this.accept(node, 1);
        return null;
    }

    public Object switchStatement(SimpleNode node, Context context) {
        this.sbuf.append("switch (");
        this.accept(node, 0);
        this.sbuf.append("){");
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode n = node.jjtGetChild(i);
            if (n.jjtGetNumChildren() == 1) {
                this.sbuf.append("case ");
                this.accept(n, 0);
                this.sbuf.append(": ");
                this.accept(node, ++i);
            } else {
                this.sbuf.append("default: ");
                this.accept(node, ++i);
            }
            this.sbuf.append("; ");
        }
        this.sbuf.append('}');
        return null;
    }

    public Object switchBlock(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            this.accept(node, 0);
            for (int i = 1; i < n; ++i) {
                this.sbuf.append("; ");
                this.accept(node, i);
            }
        }
        return null;
    }

    public Object functionStatement(SimpleNode node, Context context) {
        int pid = 0;
        if (node.jjtGetParent() != null && ((pid = node.jjtGetParent().id) == 32 || pid == 28)) {
            this.sbuf.append('(');
        }
        this.sbuf.append("function ");
        if (node.str != null) {
            this.sbuf.append(node.str);
        }
        SimpleNode args = node.jjtGetChild(0);
        int nargs = args.jjtGetNumChildren();
        boolean varargs = "[".equals(args.str);
        this.sbuf.append('(');
        Object n0 = null;
        if (nargs > 0) {
            this.paramList(args);
            if (varargs) {
                this.sbuf.append("[]");
            }
        }
        this.sbuf.append(") ");
        this.accept(node, 1);
        if (pid == 32 || pid == 28) {
            this.sbuf.append(')');
        }
        return null;
    }

    public Object ternary(SimpleNode node, Context context) {
        this.sbuf.append('(');
        this.accept(node, 0);
        this.sbuf.append(" ? ");
        this.accept(node, 1);
        this.sbuf.append(" : ");
        this.accept(node, 2);
        this.sbuf.append(')');
        return null;
    }

    final void accept(SimpleNode node, int idx) {
        node.jjtGetChild(idx).accept(this, null);
    }
}

