/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.pnuts.lang.Signature;
import pnuts.compiler.ClassFile;
import pnuts.compiler.Compiler;
import pnuts.compiler.Label;
import pnuts.compiler.ScopeAnalyzer;
import pnuts.lang.AbstractData;
import pnuts.lang.Context;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

public class ClassGenerator {
    public static final int THIS_BIT = 1;
    public static final int SUPER_BIT = 2;
    private static final String SUPER_PROXY_NAME = "pnuts.compiler.ClassGenerator$SuperCallProxy";

    public static ClassFile createClassFile(String className, Class superClass, Class[] interfaces, int mode) {
        if (superClass == null) {
            superClass = Object.class;
        }
        ClassFile cf = new ClassFile(className, superClass.getName(), null, 1);
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                cf.addInterface(interfaces[i].getName());
            }
        }
        cf.addField("_context", "Lpnuts/lang/Context;", (short)10);
        cf.addField("_package", "Lpnuts/lang/Package;", (short)10);
        if ((mode & 2) == 2) {
            ClassGenerator.superCall(cf, superClass);
        }
        Class[] intf = ClassGenerator.getImplicitInterfaces(superClass);
        if (interfaces == null) {
            interfaces = intf;
        } else if (intf.length > 0) {
            int i;
            Class[] c = new Class[interfaces.length + intf.length];
            for (i = 0; i < interfaces.length; ++i) {
                c[i] = interfaces[i];
            }
            for (i = 0; i < intf.length; ++i) {
                c[interfaces.length + i] = intf[i];
            }
            interfaces = c;
        }
        return cf;
    }

    public static void constructor(ClassFile cf, Class superClass, Compiler compiler, Context cc, List signatures, List assignments, int mode) {
        Class[] exceptionTypes;
        Class[] parameterTypes;
        int i;
        boolean hasThis;
        String className = cf.getClassName();
        boolean hasSuper = (mode & 2) == 2;
        boolean bl = hasThis = (mode & 1) == 1;
        if (hasSuper) {
            cf.addField("_superCallProxy", "Lpnuts/lang/AbstractData;", (short)2);
        }
        HashSet protected_constructors = new HashSet();
        ClassGenerator.getProtectedConstructors(superClass, new HashSet(), protected_constructors);
        Constructor<?>[] public_constructors = superClass.getConstructors();
        HashSet<Signature> generated_constructors = new HashSet<Signature>();
        int num_constructors = 0;
        int n = signatures.size();
        for (i = 0; i < n; ++i) {
            Class[] exceptionTypes2;
            Class[] parameterTypes2;
            Signature sig = (Signature)signatures.get(i);
            SimpleNode fnode = (SimpleNode)sig.nodeInfo;
            int modifiers = sig.getModifiers();
            ArrayList constructors = new ArrayList();
            if (sig.resolveAsConstructor(superClass, constructors)) {
                int n2 = constructors.size();
                for (int j = 0; j < n2; ++j) {
                    Constructor cons = (Constructor)constructors.get(j);
                    parameterTypes2 = cons.getParameterTypes();
                    exceptionTypes2 = cons.getExceptionTypes();
                    ClassGenerator.constructor(cf, cc, compiler, superClass, parameterTypes2, exceptionTypes2, (short)1, hasThis, hasSuper, assignments);
                    generated_constructors.add(new Signature(null, Void.TYPE, parameterTypes2, exceptionTypes2));
                    ++num_constructors;
                }
                continue;
            }
            parameterTypes2 = sig.getParameterTypes();
            exceptionTypes2 = sig.getExceptionTypes();
            ClassGenerator.constructor(cf, cc, compiler, superClass, parameterTypes2, exceptionTypes2, (short)1, hasThis, hasSuper, assignments);
            generated_constructors.add(new Signature(null, Void.TYPE, parameterTypes2, exceptionTypes2));
            ++num_constructors;
        }
        for (i = 0; i < public_constructors.length; ++i) {
            Constructor<?> cons = public_constructors[i];
            parameterTypes = cons.getParameterTypes();
            Signature sig = new Signature(null, Void.TYPE, parameterTypes, exceptionTypes = cons.getExceptionTypes());
            if (generated_constructors.contains(sig)) continue;
            ClassGenerator.constructor(cf, cc, compiler, superClass, parameterTypes, exceptionTypes, (short)1, hasSuper, assignments);
            ++num_constructors;
        }
        if (num_constructors == 0) {
            cf.openMethod("<init>", "()V", (short)1);
            cf.add((byte)42);
            cf.add((byte)-73, superClass.getName(), "<init>", "()", "V");
            if (hasSuper) {
                ClassGenerator.assignSuperCallProxy(cf, className);
            }
            if (compiler != null) {
                ClassGenerator.declareFields(cf, cc, compiler, assignments);
            }
            cf.add((byte)-79);
            cf.closeMethod();
            generated_constructors.add(new Signature(null, Void.TYPE, new Class[0], new Class[0]));
        }
        Iterator it = protected_constructors.iterator();
        while (it.hasNext()) {
            Constructor cons = (Constructor)it.next();
            parameterTypes = cons.getParameterTypes();
            Signature sig = new Signature(null, Void.TYPE, parameterTypes, exceptionTypes = cons.getExceptionTypes());
            if (generated_constructors.contains(sig)) continue;
            ClassGenerator.constructor(cf, cc, compiler, superClass, parameterTypes, exceptionTypes, (short)4, hasSuper, assignments);
        }
    }

    static void constructor(ClassFile cf, Context cc, Compiler compiler, Class superClass, Class[] parameterTypes, Class[] exceptionTypes, short modifier, boolean hasSuper, List assignments) {
        String sig = ClassFile.signature(parameterTypes);
        String[] exceptionTypeInfo = null;
        if (exceptionTypes != null && exceptionTypes.length > 0) {
            exceptionTypeInfo = new String[exceptionTypes.length];
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionTypeInfo[j] = exceptionTypes[j].getName();
            }
        }
        cf.openMethod("<init>", sig + "V", modifier, exceptionTypeInfo);
        cf.add((byte)42);
        int pos = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class type = parameterTypes[i];
            if (type.isPrimitive()) {
                if (type == Long.TYPE) {
                    cf.lloadLocal(pos);
                    pos += 2;
                    continue;
                }
                if (type == Double.TYPE) {
                    cf.dloadLocal(pos);
                    pos += 2;
                    continue;
                }
                if (type == Float.TYPE) {
                    cf.floadLocal(pos++);
                    continue;
                }
                if (type != Integer.TYPE && type != Byte.TYPE && type != Short.TYPE && type != Character.TYPE && type != Boolean.TYPE) continue;
                cf.iloadLocal(pos++);
                continue;
            }
            cf.loadLocal(pos++);
        }
        cf.add((byte)-73, superClass.getName(), "<init>", sig, "V");
        if (hasSuper) {
            ClassGenerator.assignSuperCallProxy(cf, cf.getClassName());
        }
        ClassGenerator.declareFields(cf, cc, compiler, assignments);
        cf.add((byte)-79);
        cf.closeMethod();
    }

    static void constructor(ClassFile cf, Context cc, Compiler compiler, Class superClass, Class[] parameterTypes, Class[] exceptionTypes, short modifier, boolean hasThis, boolean hasSuper, List assignments) {
        String className = cf.getClassName();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) continue;
            parameterTypes[i] = class$java$lang$Object == null ? ClassGenerator.class$("java.lang.Object") : class$java$lang$Object;
        }
        String sig = ClassFile.signature(parameterTypes);
        String[] exceptionTypeInfo = null;
        if (exceptionTypes != null && exceptionTypes.length > 0) {
            exceptionTypeInfo = new String[exceptionTypes.length];
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionTypeInfo[j] = exceptionTypes[j].getName();
            }
        }
        cf.openMethod("<init>", sig + "V", modifier, exceptionTypeInfo);
        cf.add((byte)42);
        cf.add((byte)-73, superClass.getName(), "<init>", "()", "V");
        if (hasSuper) {
            ClassGenerator.assignSuperCallProxy(cf, className);
        }
        ClassGenerator.declareFields(cf, cc, compiler, assignments);
        cf.add((byte)-78, className, "_package", "Lpnuts/lang/Package;");
        cf.add((byte)18, cf.addConstant(sig.toString()));
        cf.add((byte)-74, "java.lang.String", "intern", "()", "Ljava/lang/String;");
        cf.add((byte)-78, className, "_context", "Lpnuts/lang/Context;");
        cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        int f = cf.getLocal();
        cf.storeLocal(f);
        cf.loadLocal(f);
        Label nonnull = cf.getLabel();
        cf.add((byte)-57, nonnull);
        cf.add((byte)-79);
        nonnull.fix();
        cf.loadLocal(f);
        cf.add((byte)-64, "pnuts.lang.PnutsFunction");
        int nargs = parameterTypes.length;
        if (nargs <= Short.MIN_VALUE || nargs >= 32768) {
            throw new RuntimeException("too many parameters");
        }
        Label catchStart = cf.getLabel(true);
        int k = 0;
        int nargs2 = nargs;
        if (hasThis) {
            ++nargs2;
            ++k;
        }
        if (hasSuper) {
            ++nargs2;
            ++k;
        }
        cf.pushInteger(nargs2);
        cf.add((byte)-67, "java.lang.Object");
        int tmp = cf.getLocal();
        for (int j = 0; j < nargs; ++j) {
            cf.add((byte)89);
            cf.pushInteger(j + k);
            Class paramType = parameterTypes[j];
            if (paramType != null && paramType.isPrimitive()) {
                ClassGenerator.loadPrimitive(cf, paramType, j + 1);
                if (paramType.equals(Long.TYPE) || paramType.equals(Double.TYPE)) {
                    ++j;
                }
            } else {
                cf.loadLocal(j + 1);
            }
            cf.add((byte)83);
        }
        k = 0;
        if (hasThis) {
            cf.add((byte)89);
            cf.pushInteger(k++);
            cf.loadLocal(0);
            cf.add((byte)83);
        }
        if (hasSuper) {
            cf.add((byte)89);
            cf.pushInteger(k++);
            cf.loadLocal(0);
            cf.add((byte)-76, className, "_superCallProxy", "Lpnuts/lang/AbstractData;");
            cf.add((byte)83);
        }
        cf.add((byte)-78, className, "_context", "Lpnuts/lang/Context;");
        cf.add((byte)-74, "pnuts.lang.PnutsFunction", "call", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        cf.add((byte)87);
        cf.add((byte)-79);
        Label catchEnd = cf.getLabel(true);
        Label catchTarget = cf.getLabel(true);
        cf.reserveStack(1);
        int pex = cf.getLocal();
        cf.storeLocal(pex);
        cf.loadLocal(pex);
        cf.add((byte)-74, "pnuts.lang.PnutsException", "getThrowable", "()", "Ljava/lang/Throwable;");
        int ex = cf.getLocal();
        cf.storeLocal(ex);
        if (exceptionTypeInfo != null) {
            for (int i = 0; i < exceptionTypeInfo.length; ++i) {
                Label next = cf.getLabel();
                cf.loadLocal(ex);
                cf.add((byte)-63, exceptionTypeInfo[i]);
                cf.add((byte)-103, next);
                cf.loadLocal(ex);
                cf.add((byte)-65);
                next.fix();
            }
        }
        cf.loadLocal(pex);
        cf.add((byte)-65);
        cf.addExceptionHandler(catchStart, catchEnd, catchTarget, "pnuts.lang.PnutsException");
        cf.closeMethod();
    }

    private static void declareFields(ClassFile cf, Context cc, Compiler compiler, List assignments) {
        String className = cf.getClassName();
        int n = assignments.size();
        for (int i = 0; i < n; ++i) {
            SimpleNode assign = (SimpleNode)assignments.get(i);
            SimpleNode lhs = assign.jjtGetChild(0);
            SimpleNode rhs = assign.jjtGetChild(1);
            cf.add((byte)-78, className, "_context", "Lpnuts/lang/Context;");
            cf.add((byte)42);
            cf.add((byte)18, cf.addConstant(lhs.str));
            rhs.accept(compiler, cc);
            cf.add((byte)-72, "pnuts.lang.Runtime", "putField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)", "V");
        }
    }

    static void assignSuperCallProxy(ClassFile cf, String className) {
        cf.add((byte)42);
        cf.add((byte)-69, SUPER_PROXY_NAME);
        cf.add((byte)89);
        cf.add((byte)42);
        cf.add((byte)-73, SUPER_PROXY_NAME, "<init>", "(Ljava/lang/Object;)", "V");
        cf.add((byte)-75, className, "_superCallProxy", "Lpnuts/lang/AbstractData;");
    }

    private static void superCall(ClassFile cf, Class superClass) {
        Method[] methods = ClassGenerator.getInheritableMethods(superClass);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            int modifiers = m.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) continue;
            String methodName = m.getName();
            Class[] parameterTypes = m.getParameterTypes();
            Class<?> returnType = m.getReturnType();
            cf.openMethod("$super$" + methodName, ClassFile.signature(parameterTypes) + ClassFile.signature(returnType), (short)1);
            cf.add((byte)42);
            int nparams = parameterTypes.length;
            int k = 0;
            for (int j = 0; j < nparams; ++j) {
                Class type = parameterTypes[j];
                if (type.isPrimitive()) {
                    if (type == Integer.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Boolean.TYPE || type == Character.TYPE) {
                        cf.iloadLocal(j + k + 1);
                        continue;
                    }
                    if (type == Long.TYPE) {
                        cf.lloadLocal(j + k + 1);
                        ++k;
                        continue;
                    }
                    if (type == Float.TYPE) {
                        cf.floadLocal(j + k + 1);
                        continue;
                    }
                    if (type != Double.TYPE) continue;
                    cf.dloadLocal(j + k + 1);
                    ++k;
                    continue;
                }
                cf.loadLocal(j + k + 1);
            }
            cf.add((byte)-73, m.getDeclaringClass().getName(), methodName, ClassFile.signature(parameterTypes), ClassFile.signature(returnType));
            if (returnType.isPrimitive()) {
                if (returnType == Integer.TYPE || returnType == Byte.TYPE || returnType == Short.TYPE || returnType == Boolean.TYPE || returnType == Character.TYPE) {
                    cf.add((byte)-84);
                } else if (returnType == Long.TYPE) {
                    cf.add((byte)-83);
                } else if (returnType == Float.TYPE) {
                    cf.add((byte)-82);
                } else if (returnType == Double.TYPE) {
                    cf.add((byte)-81);
                } else if (returnType == Void.TYPE) {
                    cf.add((byte)-79);
                }
            } else {
                cf.add((byte)-80);
            }
            cf.closeMethod();
        }
    }

    private static Class[] getImplicitInterfaces(Class cls) {
        ArrayList list = new ArrayList();
        for (Class c = cls; c != null; c = c.getSuperclass()) {
            ClassGenerator.getImplicitInterfaces(c, list);
        }
        Class[] results = new Class[list.size()];
        return list.toArray(results);
    }

    private static void getImplicitInterfaces(Class cls, List list) {
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            list.add(interfaces[i]);
        }
    }

    static Constructor[] getProtectedConstructors(Class cls) {
        HashSet s = new HashSet();
        HashSet cons = new HashSet();
        for (Class c = cls; c != null; c = c.getSuperclass()) {
            ClassGenerator.getProtectedConstructors(c, s, cons);
        }
        return cons.toArray(new Constructor[cons.size()]);
    }

    static void getProtectedConstructors(Class cls, Set signatures, Set constructors) {
        Constructor<?>[] _constructors = cls.getDeclaredConstructors();
        for (int j = 0; j < _constructors.length; ++j) {
            String sig;
            Constructor<?> c = _constructors[j];
            int modifiers = c.getModifiers();
            if (!Modifier.isProtected(modifiers) || Modifier.isFinal(modifiers) || !signatures.add(sig = ClassFile.signature(c.getParameterTypes()))) continue;
            constructors.add(c);
        }
    }

    static Method[] getInheritableMethods(Class cls) {
        HashSet s = new HashSet();
        HashSet m = new HashSet();
        while (cls != null) {
            ClassGenerator.getInheritableMethods(cls, s, m);
            cls = cls.getSuperclass();
        }
        return m.toArray(new Method[m.size()]);
    }

    static void getInheritableMethods(Class cls, Set signatures, Set methods) {
        Method[] _methods = cls.getDeclaredMethods();
        for (int j = 0; j < _methods.length; ++j) {
            String sig;
            Method m = _methods[j];
            int modifiers = m.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || !signatures.add(sig = m.getName() + ClassFile.signature(m.getParameterTypes()))) continue;
            methods.add(m);
        }
    }

    public static void defineMethod(ClassFile cf, Class[] parameterTypes, Class returnType, Class[] exceptionTypes, int modifiers, String methodName, String sig, int mode) {
        String className = cf.getClassName();
        String[] exceptionTypeInfo = null;
        if (exceptionTypes != null && exceptionTypes.length > 0) {
            exceptionTypeInfo = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                exceptionTypeInfo[i] = exceptionTypes[i].getName();
            }
        }
        cf.openMethod(methodName, ClassFile.signature(parameterTypes) + ClassFile.signature(returnType), (short)(modifiers & 5), exceptionTypeInfo);
        cf.add((byte)-78, className, "_package", "Lpnuts/lang/Package;");
        cf.add((byte)18, cf.addConstant(sig));
        cf.add((byte)-74, "java.lang.String", "intern", "()", "Ljava/lang/String;");
        cf.add((byte)-78, className, "_context", "Lpnuts/lang/Context;");
        cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        int f = cf.getLocal();
        cf.add((byte)-64, "pnuts.lang.PnutsFunction");
        int nargs = parameterTypes.length;
        if (nargs <= Short.MIN_VALUE || nargs >= 32768) {
            throw new RuntimeException("too many parameters");
        }
        boolean hasThis = (mode & 1) == 1;
        boolean hasSuper = (mode & 2) == 2;
        int i = 0;
        Label catchStart = cf.getLabel(true);
        int nargs2 = nargs;
        if (hasThis) {
            ++nargs2;
            ++i;
        }
        if (hasSuper) {
            ++nargs2;
            ++i;
        }
        cf.pushInteger(nargs2);
        cf.add((byte)-67, "java.lang.Object");
        int tmp = cf.getLocal();
        int j = 0;
        for (int k = 0; k < nargs; ++k) {
            cf.add((byte)89);
            cf.pushInteger(k + i);
            Class paramType = parameterTypes[k];
            if (paramType.isPrimitive()) {
                ClassGenerator.loadPrimitive(cf, paramType, j + 1);
                if (paramType.equals(Long.TYPE) || paramType.equals(Double.TYPE)) {
                    ++j;
                }
            } else {
                cf.loadLocal(j + 1);
            }
            cf.add((byte)83);
            ++j;
        }
        i = 0;
        if (hasThis) {
            cf.add((byte)89);
            cf.pushInteger(i++);
            cf.loadLocal(0);
            cf.add((byte)83);
        }
        if (hasSuper) {
            cf.add((byte)89);
            cf.pushInteger(i++);
            cf.loadLocal(0);
            cf.add((byte)-76, className, "_superCallProxy", "Lpnuts/lang/AbstractData;");
            cf.add((byte)83);
        }
        cf.add((byte)-78, className, "_context", "Lpnuts/lang/Context;");
        cf.add((byte)-74, "pnuts.lang.PnutsFunction", "call", "([Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        if (returnType == Void.TYPE) {
            cf.add((byte)87);
            cf.add((byte)-79);
        } else if (returnType.isPrimitive()) {
            ClassGenerator.returnPrimitive(cf, returnType);
        } else {
            if (returnType != Object.class) {
                cf.add((byte)-64, returnType.getName());
            }
            cf.add((byte)-80);
        }
        Label catchEnd = cf.getLabel(true);
        Label catchTarget = cf.getLabel(true);
        cf.reserveStack(1);
        int pex = cf.getLocal();
        cf.storeLocal(pex);
        cf.loadLocal(pex);
        cf.add((byte)-74, "pnuts.lang.PnutsException", "getThrowable", "()", "Ljava/lang/Throwable;");
        int ex = cf.getLocal();
        cf.storeLocal(ex);
        if (exceptionTypeInfo != null) {
            for (i = 0; i < exceptionTypeInfo.length; ++i) {
                Label next = cf.getLabel();
                cf.loadLocal(ex);
                cf.add((byte)-63, exceptionTypeInfo[i]);
                cf.add((byte)-103, next);
                cf.loadLocal(ex);
                cf.add((byte)-65);
                next.fix();
            }
        }
        cf.loadLocal(pex);
        cf.add((byte)-65);
        cf.addExceptionHandler(catchStart, catchEnd, catchTarget, "pnuts.lang.PnutsException");
        cf.closeMethod();
    }

    private static void loadPrimitive(ClassFile cf, Class primitive, int index) {
        if (primitive == Integer.TYPE) {
            cf.add((byte)-69, "java.lang.Integer");
            cf.add((byte)89);
            cf.iloadLocal(index);
            cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
        } else if (primitive == Byte.TYPE) {
            cf.add((byte)-69, "java.lang.Byte");
            cf.add((byte)89);
            cf.iloadLocal(index);
            cf.add((byte)-73, "java.lang.Byte", "<init>", "(B)", "V");
        } else if (primitive == Short.TYPE) {
            cf.add((byte)-69, "java.lang.Short");
            cf.add((byte)89);
            cf.iloadLocal(index);
            cf.add((byte)-73, "java.lang.Short", "<init>", "(S)", "V");
        } else if (primitive == Character.TYPE) {
            cf.add((byte)-69, "java.lang.Character");
            cf.add((byte)89);
            cf.iloadLocal(index);
            cf.add((byte)-73, "java.lang.Character", "<init>", "(C)", "V");
        } else if (primitive == Long.TYPE) {
            cf.add((byte)-69, "java.lang.Long");
            cf.add((byte)89);
            cf.lloadLocal(index);
            cf.add((byte)-73, "java.lang.Long", "<init>", "(J)", "V");
        } else if (primitive == Float.TYPE) {
            cf.add((byte)-69, "java.lang.Float");
            cf.add((byte)89);
            cf.floadLocal(index);
            cf.add((byte)-73, "java.lang.Float", "<init>", "(F)", "V");
        } else if (primitive == Double.TYPE) {
            cf.add((byte)-69, "java.lang.Double");
            cf.add((byte)89);
            cf.dloadLocal(index);
            cf.add((byte)-73, "java.lang.Double", "<init>", "(D)", "V");
        } else if (primitive == Boolean.TYPE) {
            cf.add((byte)-69, "java.lang.Boolean");
            cf.add((byte)89);
            cf.iloadLocal(index);
            cf.add((byte)-73, "java.lang.Boolean", "<init>", "(Z)", "V");
        }
    }

    private static void returnPrimitive(ClassFile cf, Class type) {
        if (type == Integer.TYPE) {
            cf.add((byte)-64, "java.lang.Integer");
            cf.add((byte)-74, "java.lang.Integer", "intValue", "()", "I");
            cf.add((byte)-84);
        } else if (type == Byte.TYPE) {
            cf.add((byte)-64, "java.lang.Byte");
            cf.add((byte)-74, "java.lang.Byte", "byteValue", "()", "B");
            cf.add((byte)-84);
        } else if (type == Short.TYPE) {
            cf.add((byte)-64, "java.lang.Short");
            cf.add((byte)-74, "java.lang.Short", "shortValue", "()", "S");
            cf.add((byte)-84);
        } else if (type == Character.TYPE) {
            cf.add((byte)-64, "java.lang.Character");
            cf.add((byte)-74, "java.lang.Character", "charValue", "()", "C");
            cf.add((byte)-84);
        } else if (type == Long.TYPE) {
            cf.add((byte)-64, "java.lang.Long");
            cf.add((byte)-74, "java.lang.Long", "longValue", "()", "L");
            cf.add((byte)-83);
        } else if (type == Float.TYPE) {
            cf.add((byte)-64, "java.lang.Float");
            cf.add((byte)-74, "java.lang.Float", "floatValue", "()", "F");
            cf.add((byte)-82);
        } else if (type == Double.TYPE) {
            cf.add((byte)-64, "java.lang.Double");
            cf.add((byte)-74, "java.lang.Double", "doubleValue", "()", "D");
            cf.add((byte)-81);
        } else if (type == Boolean.TYPE) {
            cf.add((byte)-64, "java.lang.Boolean");
            cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
            cf.add((byte)-84);
        } else {
            throw new InternalError();
        }
    }

    private static void populateMembers(SimpleNode classDefBody, Set methods, Set fields) {
        int n = classDefBody.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode c = classDefBody.jjtGetChild(i);
            if (c.id == 23) {
                int arity;
                SimpleNode typedParamList;
                String name = c.str;
                int num = c.jjtGetNumChildren();
                if (num == 2) {
                    typedParamList = c.jjtGetChild(0);
                    arity = typedParamList.jjtGetNumChildren();
                } else if (num == 3) {
                    typedParamList = c.jjtGetChild(1);
                    arity = typedParamList.jjtGetNumChildren();
                } else {
                    throw new InternalError();
                }
                methods.add(new MethodArity(name, arity));
                continue;
            }
            if (c.id != 22) continue;
            fields.add(c.str);
        }
    }

    private static void populateMethodArities(Class cls, Set methods) {
        Method[] m = cls.getMethods();
        for (int i = 0; i < m.length; ++i) {
            MethodArity a = new MethodArity(m[i].getName(), m[i].getParameterTypes().length);
            methods.add(a);
        }
    }

    private static void populateFieldNames(Class cls, Set fields) {
        try {
            BeanInfo binfo = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] p = binfo.getPropertyDescriptors();
            for (int i = 0; i < p.length; ++i) {
                fields.add(p[i].getName());
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    private static void transformApplicationNode(SimpleNode node) {
        node.id = 28;
        SimpleNode n0 = node.jjtGetChild(0);
        node.str = n0.str;
        n0.str = Compiler.THIS;
    }

    private static void transformApplicationNode(SimpleNode node, Set methods, Set fields) {
        HashSet nodes = new HashSet();
        new ThisTransformer(methods, fields, nodes).analyze(node);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            SimpleNode n = (SimpleNode)it.next();
            if (n.id == 32) {
                ClassGenerator.transformApplicationNode(n);
                continue;
            }
            if (n.id != 7) continue;
            ClassGenerator.transformIdNode(n);
        }
    }

    static void transformIdNode(SimpleNode node) {
        node.id = 30;
        SimpleNode c = new SimpleNode(7);
        c.str = Compiler.THIS;
        node.jjtAddChild(c, 0);
        c.jjtSetParent(node);
    }

    public static int transformClassDefBody(SimpleNode classDefBody, Class superclass) {
        HashSet methods = new HashSet();
        HashSet fields = new HashSet();
        ClassGenerator.populateMethodArities(superclass, methods);
        ClassGenerator.populateFieldNames(superclass, fields);
        ClassGenerator.populateMembers(classDefBody, methods, fields);
        ClassGenerator.transformApplicationNode(classDefBody, methods, fields);
        return ClassGenerator.findThisAndSuper(classDefBody);
    }

    static int findThisAndSuper(SimpleNode node) {
        return ClassGenerator.findThisAndSuper(node, 0);
    }

    static int findThisAndSuper(SimpleNode node, int mode) {
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode c = node.jjtGetChild(i);
            if (c.id == 7) {
                SimpleNode parent = c.jjtGetParent();
                if (parent.id == 32) continue;
                if (c.str == Compiler.SUPER) {
                    mode |= 2;
                    continue;
                }
                if (c.str == Compiler.THIS) {
                    mode |= 1;
                    continue;
                }
                if (!Compiler.THIS.equals(c.str)) continue;
                throw new InternalError();
            }
            mode |= ClassGenerator.findThisAndSuper(c, mode);
        }
        return mode;
    }

    public static class SuperCallProxy
    implements AbstractData {
        private Object target;

        public SuperCallProxy(Object target) {
            this.target = target;
        }

        public Object get(String name, Context context) {
            throw new UnsupportedOperationException();
        }

        public void set(String name, Object value, Context context) {
            throw new UnsupportedOperationException();
        }

        public Object invoke(String name, Object[] args, Context context) {
            return Runtime.callMethod(context, this.target.getClass(), "$super$" + name, args, null, this.target);
        }
    }

    private static class ThisTransformer
    extends ScopeAnalyzer {
        private Set methods;
        private Set fields;
        private Set nodesNeedTransformation;

        ThisTransformer(Set methods, Set fields, Set nodesNeedTransformation) {
            this.methods = methods;
            this.fields = fields;
            this.nodesNeedTransformation = nodesNeedTransformation;
        }

        protected void handleFreeVariable(SimpleNode node, Context context) {
            SimpleNode parent = node.jjtGetParent();
            if (parent != null && parent.id == 32) {
                String symbol = node.str;
                SimpleNode argNode = parent.jjtGetChild(1);
                int n = argNode.jjtGetNumChildren();
                MethodArity arity = new MethodArity(symbol, n);
                if (this.methods.contains(arity)) {
                    this.nodesNeedTransformation.add(parent);
                }
            } else if (parent != null && parent.id != 30 && this.fields.contains(node.str)) {
                this.nodesNeedTransformation.add(node);
            }
        }
    }

    static class MethodArity {
        String name;
        int nargs;

        MethodArity(String name, int nargs) {
            this.name = name;
            this.nargs = nargs;
        }

        public int hashCode() {
            return this.name.hashCode() * this.nargs;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodArity) {
                MethodArity a = (MethodArity)obj;
                return a.nargs == this.nargs && a.name.equals(this.name);
            }
            return false;
        }
    }
}

