/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pnuts.compiler.BranchEnv;
import pnuts.compiler.LocalInfo;
import pnuts.compiler.Reference;
import pnuts.compiler.SymbolSet;

class Frame
implements Cloneable {
    Frame parent;
    SymbolSet symbolSet;
    SymbolSet bottom;
    String fname;
    String[] locals;
    List imports = new ArrayList();
    Map exports = new HashMap();
    boolean leaf = true;
    Object attr;
    boolean finallySet;
    BranchEnv branch_env;

    Frame() {
        this.openLocal();
    }

    Frame(String[] locals, String fname, Frame parent, boolean leaf) {
        this.parent = parent;
        if (fname != null) {
            this.fname = fname.intern();
        }
        for (int i = 0; i < locals.length; ++i) {
            locals[i] = locals[i].intern();
        }
        this.locals = locals;
        this.symbolSet = this.bottom = new SymbolSet(null);
        this.leaf = leaf;
        this.openLocal();
    }

    void openLocal() {
        this.symbolSet = new SymbolSet(this.symbolSet);
    }

    void closeLocal() {
        this.symbolSet = this.symbolSet.parent;
    }

    LocalInfo lookup(String sym) {
        if (this.branch_env != null) {
            LocalInfo info = this.symbolSet.assoc(sym);
            if (info == null) {
                info = this.branch_env.lookup(sym);
            }
            return info;
        }
        return this.symbolSet.assoc(sym);
    }

    LocalInfo assoc(String sym) {
        if (this.branch_env != null) {
            LocalInfo info = this.symbolSet.assoc(sym);
            if (info == null) {
                info = this.branch_env.assoc(sym);
            }
            return info;
        }
        return this.symbolSet.assoc(sym);
    }

    boolean setReference(String sym) {
        LocalInfo info = this.assoc(sym);
        if (info != null) {
            info.initialized = true;
            return true;
        }
        return false;
    }

    Reference findReference(String sym) {
        return this.getReference(sym, true);
    }

    Reference getReference(String sym) {
        return this.getReference(sym, false);
    }

    Reference getReference(String sym, boolean flag) {
        LocalInfo info;
        if (flag) {
            info = this.lookup(sym);
            if (info != null) {
                if (this.branch_env != null) {
                    this.branch_env.declare(sym, info.map, info.index);
                } else {
                    this.symbolSet.add(sym, info.map, info.index);
                }
            }
        } else {
            info = this.assoc(sym);
        }
        if (info != null) {
            return new Reference(sym, info);
        }
        if (this.locals != null) {
            for (int i = 0; i < this.locals.length; ++i) {
                if (this.locals[i] != sym) continue;
                return new Reference(sym, 1, i, true);
            }
        }
        return null;
    }

    public void declare(String symbol, int key, int idx) {
        if (this.branch_env != null) {
            this.branch_env.declare(symbol, key, idx);
        } else {
            this.bottom.add(symbol, key, idx);
        }
    }

    public void declare(String symbol, int key) {
        if (this.branch_env != null) {
            this.branch_env.declare(symbol, key);
        } else {
            this.bottom.add(symbol, key);
        }
    }

    public void _declare(String symbol, int key, int idx) {
        this.symbolSet.add(symbol, key, idx);
    }

    public void _declare(String symbol, int key) {
        this.symbolSet.add(symbol, key);
    }

    public void _declare_frame(String symbol, int key) {
        this.symbolSet.add(symbol, key, this);
    }

    void openBranchEnv() {
        this.branch_env = new BranchEnv(this.branch_env, this.symbolSet);
    }

    void addBranch() {
        this.branch_env.addBranch(this.symbolSet);
    }

    void closeBranchEnv() {
        this.branch_env.close();
        if (this.branch_env.parent == null && this.bottom != null) {
            Iterator it = this.branch_env.symbolToLocalInfo.values().iterator();
            while (it.hasNext()) {
                LocalInfo info = (LocalInfo)it.next();
                this.bottom.add(info.symbol, info.map, info.index);
            }
        }
        this.branch_env = this.branch_env.parent;
    }

    public Object clone() {
        try {
            Frame frame = (Frame)super.clone();
            return frame;
        }
        catch (Throwable t) {
            throw new InternalError();
        }
    }
}

