/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import pnuts.compiler.ClassFile;
import pnuts.compiler.IntArray;

public class Label {
    ClassFile cf;
    int target_pc = -1;
    IntArray pc = new IntArray();
    int size;

    Label(ClassFile cf) {
        this.cf = cf;
    }

    Label(ClassFile cf, int pc) {
        this.cf = cf;
        this.target_pc = pc;
    }

    public void fix() {
        this.target_pc = this.cf.codeBuffer.size();
        this.setRelativePosition(this.target_pc);
    }

    public Label shift(int offset) {
        return new Label(this.cf, this.target_pc + offset);
    }

    void setOffset(int offset) {
        this.setRelativePosition(this.target_pc + offset);
    }

    public void setRelativePosition(int tgt) {
        int[] array = this.pc.getArray();
        int sz = this.pc.size();
        for (int i = 0; i < sz; ++i) {
            if (this.size == 2) {
                this.cf.codeBuffer.set((short)(tgt - array[i]), array[i] + 1);
                continue;
            }
            if (this.size != 4) continue;
            this.cf.codeBuffer.set(tgt - array[i], array[i] + 1);
        }
    }

    public void setPosition(int tgt) {
        int[] array = this.pc.getArray();
        int sz = this.pc.size();
        for (int i = 0; i < sz; ++i) {
            if (this.size == 2) {
                this.cf.codeBuffer.set((short)tgt, array[i]);
                continue;
            }
            if (this.size != 4) continue;
            this.cf.codeBuffer.set(tgt, array[i]);
        }
    }

    short getPC() {
        return (short)this.target_pc;
    }

    void setPC(short pos) {
        this.target_pc = pos;
    }

    public void register(int pos, int size) {
        this.pc.add(pos);
        this.size = size;
        if (this.target_pc > 0) {
            this.setRelativePosition(this.target_pc);
        } else if (size == 2) {
            this.cf.codeBuffer.add((short)0);
        } else if (size == 4) {
            this.cf.codeBuffer.add(0);
        }
    }
}

