/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.util.HashSet;
import java.util.Set;
import pnuts.compiler.Frame;
import pnuts.compiler.Reference;
import pnuts.lang.Context;

class TranslateContext
extends Context {
    Frame rootEnv;
    Frame env;

    TranslateContext() {
        this.env = this.rootEnv = new Frame();
    }

    void openFrame(String func, String[] locals) {
        this.env = new Frame(locals, func, this.env, false);
    }

    void closeFrame() {
        this.env = this.env.parent;
    }

    Reference findReference(String symbol) {
        String sym = symbol.intern();
        Frame f = this.env;
        while (f != null) {
            Reference r = f.findReference(sym);
            if (r != null) {
                return r;
            }
            f = f.parent;
        }
        return null;
    }

    Reference getReference(String symbol) {
        String sym = symbol.intern();
        Frame f = this.env;
        while (f != null) {
            Reference r = f.getReference(sym, true);
            if (r != null) {
                return r;
            }
            f = f.parent;
        }
        return null;
    }

    int declare(String symbol) {
        this.env.declare(symbol, 0, 0);
        return 0;
    }

    void openScope(String[] locals) {
        this.env.openLocal();
        for (int i = 0; i < locals.length; ++i) {
            this.env._declare(locals[i], 0);
        }
    }

    void closeScope() {
        this.env.closeLocal();
    }

    void openBranchEnv() {
        this.env.openBranchEnv();
    }

    void addBranch() {
        this.env.addBranch();
    }

    void closeBranchEnv() {
        this.env.closeBranchEnv();
    }

    void addToFreeVarSet(String symbol) {
        Frame f = this.env;
        while (f.parent != this.rootEnv) {
            f = f.parent;
        }
        HashSet<String> set = (HashSet<String>)f.attr;
        if (set == null) {
            f.attr = set = new HashSet<String>();
        }
        set.add(symbol);
    }

    Set getFreeVarSet() {
        return (Set)this.env.attr;
    }
}

