/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import pnuts.compiler.ClassFile;
import pnuts.compiler.ClassFileHandler;

public class ZipWriterHandler
implements ClassFileHandler {
    private ZipOutputStream zout;
    private ByteArrayOutputStream bout;
    private DataOutputStream dout;
    private boolean verbose;

    public ZipWriterHandler(ZipOutputStream zout) {
        this.zout = zout;
        this.bout = new ByteArrayOutputStream();
        this.dout = new DataOutputStream(this.bout);
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    protected void handleException(Exception e) {
        e.printStackTrace();
    }

    public Object handle(ClassFile cf) {
        try {
            this.bout.reset();
            cf.write(this.dout);
            ZipEntry entry = new ZipEntry(cf.getClassName().replace('.', '/') + ".class");
            this.zout.putNextEntry(entry);
            this.bout.writeTo(this.zout);
            if (this.verbose) {
                System.out.println(entry);
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return null;
    }
}

