/*
 * Decompiled with CFR 0.152.
 */
package pnuts.ext;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import pnuts.compiler.Compiler;
import pnuts.lang.Context;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.Runtime;
import pnuts.lang.Visitor;

public class CachedScript
extends Pnuts {
    protected URL scriptURL;
    protected long parsedTime;
    protected Pnuts script;
    protected String encoding;

    public CachedScript(URL scriptURL) throws IOException, ParseException {
        this(scriptURL, null, null);
    }

    public CachedScript(URL scriptURL, String encoding, Context context) throws IOException, ParseException {
        this.scriptURL = scriptURL;
        this.encoding = encoding;
        this.update(context);
    }

    public String unparse() {
        return this.script.unparse();
    }

    public Object run(Context c) {
        try {
            if (this.needToUpdate()) {
                this.update(c);
            }
        }
        catch (PnutsException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PnutsException(e, c);
        }
        return this.script.run(c);
    }

    public Object accept(Visitor v, Context c) {
        try {
            if (this.needToUpdate()) {
                this.update(c);
            }
        }
        catch (PnutsException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PnutsException(e, c);
        }
        return this.script.accept(v, c);
    }

    protected boolean needToUpdate() {
        long modified = CachedScript.lastModified(this.scriptURL);
        return modified < 0L || modified > this.parsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long lastModified(URL scriptURL) {
        long l;
        URLConnection conn = scriptURL.openConnection();
        InputStream in = conn.getInputStream();
        try {
            l = conn.getLastModified();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                return -1L;
            }
        }
        in.close();
        return l;
    }

    protected Compiler getCompiler() {
        Compiler compiler = new Compiler(null, false, true);
        compiler.setConstantFolding(true);
        return compiler;
    }

    protected void update(Context context) throws IOException, ParseException {
        Reader reader = this.encoding != null ? new InputStreamReader(this.scriptURL.openStream(), this.encoding) : (context != null ? Runtime.getScriptReader(this.scriptURL.openStream(), context) : new InputStreamReader(this.scriptURL.openStream()));
        this.script = Pnuts.parse(reader);
        this.script.setScriptSource(this.scriptURL);
        if (context == null) {
            context = new Context();
        }
        Compiler compiler = this.getCompiler();
        this.script = compiler.compile(this.script, context);
        this.parsedTime = System.currentTimeMillis();
    }
}

