/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import pnuts.lang.Numeric;
import pnuts.lang.Runtime;

public abstract class BooleanOperator
implements Serializable {
    protected boolean op_boolean(boolean b1, boolean b2) {
        throw new IllegalArgumentException(b1 + ", " + b2);
    }

    protected boolean op_int(int i1, int i2) {
        throw new IllegalArgumentException(i1 + ", " + i2);
    }

    protected boolean op_long(long l1, long l2) {
        throw new IllegalArgumentException(l1 + ", " + l2);
    }

    protected boolean op_float(float f1, float f2) {
        throw new IllegalArgumentException(f1 + ", " + f2);
    }

    protected boolean op_double(double d1, double d2) {
        throw new IllegalArgumentException(d1 + ", " + d2);
    }

    protected boolean op_bdec(BigDecimal d1, BigDecimal d2) {
        throw new IllegalArgumentException(d1 + ", " + d2);
    }

    protected boolean op_bint(BigInteger b1, BigInteger b2) {
        throw new IllegalArgumentException(b1 + ", " + b2);
    }

    protected boolean op_numeric(Numeric n1, Object n2) {
        throw new IllegalArgumentException(n1 + ", " + n2);
    }

    protected boolean op_numeric(Object n1, Numeric n2) {
        throw new IllegalArgumentException(n1 + ", " + n2);
    }

    protected boolean op_object(Object o1, Object o2) {
        throw new IllegalArgumentException(o1 + ", " + o2);
    }

    protected boolean op_string(String o1, Object o2) {
        throw new IllegalArgumentException(o1 + ", " + o2);
    }

    protected boolean op_string(Object o1, String o2) {
        throw new IllegalArgumentException(o1 + ", " + o2);
    }

    public boolean operateOn(Object n1, Object n2) {
        int t1 = n1 instanceof Integer ? 1 : (n1 instanceof Character ? 2 : (n1 instanceof Byte ? 4 : (n1 instanceof Short ? 8 : (n1 instanceof Long ? 16 : (n1 instanceof Float ? 32 : (n1 instanceof Double ? 64 : (n1 instanceof String ? 128 : (n1 instanceof BigDecimal ? 256 : (n1 instanceof BigInteger ? 512 : (n1 instanceof Boolean ? 1024 : (n1 instanceof Numeric ? 2048 : 0)))))))))));
        int t2 = n2 instanceof Integer ? 1 : (n2 instanceof Character ? 2 : (n2 instanceof Byte ? 4 : (n2 instanceof Short ? 8 : (n2 instanceof Long ? 16 : (n2 instanceof Float ? 32 : (n2 instanceof Double ? 64 : (n2 instanceof String ? 128 : (n2 instanceof BigDecimal ? 256 : (n2 instanceof BigInteger ? 512 : (n2 instanceof Boolean ? 1024 : (n2 instanceof Numeric ? 2048 : 0)))))))))));
        switch (t1 << 16 | t2) {
            case 65540: 
            case 65544: 
            case 262145: 
            case 262148: 
            case 262152: 
            case 524289: 
            case 524292: 
            case 524296: {
                return this.op_int(((Number)n1).intValue(), ((Number)n2).intValue());
            }
            case 65537: {
                return this.op_int((Integer)n1, (Integer)n2);
            }
            case 262146: 
            case 524290: {
                return this.op_int(((Number)n1).intValue(), ((Character)n2).charValue());
            }
            case 65538: {
                return this.op_int((Integer)n1, ((Character)n2).charValue());
            }
            case 65552: 
            case 0x100001: 
            case 0x100010: {
                return this.op_long(((Number)n1).longValue(), ((Number)n2).longValue());
            }
            case 131076: 
            case 131080: {
                return this.op_int(((Character)n1).charValue(), ((Number)n2).intValue());
            }
            case 131073: {
                return this.op_int(((Character)n1).charValue(), (Integer)n2);
            }
            case 131074: {
                return this.op_int(((Character)n1).charValue(), ((Character)n2).charValue());
            }
            case 131088: {
                return this.op_long(((Character)n1).charValue(), (Long)n2);
            }
            case 0x100002: {
                return this.op_long((Long)n1, ((Character)n2).charValue());
            }
            case 65568: 
            case 0x100020: 
            case 0x200001: 
            case 0x200010: 
            case 0x200020: {
                return this.op_float(((Number)n1).floatValue(), ((Number)n2).floatValue());
            }
            case 65600: 
            case 0x100040: 
            case 0x200040: 
            case 0x400001: 
            case 0x400010: 
            case 0x400020: 
            case 0x400040: {
                return this.op_double(((Number)n1).doubleValue(), ((Number)n2).doubleValue());
            }
            case 131104: {
                return this.op_float(((Character)n1).charValue(), ((Float)n2).floatValue());
            }
            case 0x200002: {
                return this.op_float(((Float)n1).floatValue(), ((Character)n2).charValue());
            }
            case 131136: {
                return this.op_double(((Character)n1).charValue(), (Double)n2);
            }
            case 0x400002: {
                return this.op_double((Double)n1, ((Character)n2).charValue());
            }
            case 66048: 
            case 262656: 
            case 524800: 
            case 0x100200: {
                return this.op_bint(BigInteger.valueOf(((Number)n1).longValue()), (BigInteger)n2);
            }
            case 131584: {
                return this.op_bint(BigInteger.valueOf(((Character)n1).charValue()), (BigInteger)n2);
            }
            case 0x2000001: 
            case 0x2000004: 
            case 0x2000008: 
            case 0x2000010: {
                return this.op_bint((BigInteger)n1, BigInteger.valueOf(((Number)n2).longValue()));
            }
            case 0x2000002: {
                return this.op_bint((BigInteger)n1, BigInteger.valueOf(((Character)n2).charValue()));
            }
            case 0x2000200: {
                return this.op_bint((BigInteger)n1, (BigInteger)n2);
            }
            case 0x2000020: {
                float ff = ((Float)n2).floatValue();
                return this.op_bdec(new BigDecimal((BigInteger)n1), BooleanOperator.doubleToDecimal(ff));
            }
            case 0x2000040: {
                double dd = (Double)n2;
                return this.op_bdec(new BigDecimal((BigInteger)n1), BooleanOperator.doubleToDecimal(dd));
            }
            case 0x200200: {
                float ff = ((Float)n1).floatValue();
                return this.op_bdec(BooleanOperator.doubleToDecimal(ff), new BigDecimal((BigInteger)n2));
            }
            case 0x400200: {
                double dd = (Double)n1;
                return this.op_bdec(BooleanOperator.doubleToDecimal(dd), new BigDecimal((BigInteger)n2));
            }
            case 65792: 
            case 262400: 
            case 524544: 
            case 0x100100: {
                return this.op_bdec(new BigDecimal(((Number)n1).doubleValue()), (BigDecimal)n2);
            }
            case 131328: {
                return this.op_bdec(new BigDecimal((double)((Character)n1).charValue()), (BigDecimal)n2);
            }
            case 0x200100: {
                float ff = ((Float)n1).floatValue();
                return this.op_bdec(BooleanOperator.doubleToDecimal(ff), (BigDecimal)n2);
            }
            case 0x400100: {
                double dd = (Double)n1;
                return this.op_bdec(BooleanOperator.doubleToDecimal(dd), (BigDecimal)n2);
            }
            case 0x1000001: 
            case 0x1000004: 
            case 0x1000008: 
            case 0x1000010: {
                return this.op_bdec((BigDecimal)n1, new BigDecimal(((Number)n2).doubleValue()));
            }
            case 0x1000002: {
                return this.op_bdec((BigDecimal)n1, new BigDecimal((double)((Character)n2).charValue()));
            }
            case 0x1000020: {
                float ff = ((Float)n2).floatValue();
                return this.op_bdec((BigDecimal)n1, BooleanOperator.doubleToDecimal(ff));
            }
            case 0x1000040: {
                double dd = (Double)n2;
                return this.op_bdec((BigDecimal)n1, BooleanOperator.doubleToDecimal(dd));
            }
            case 0x1000100: {
                return this.op_bdec((BigDecimal)n1, (BigDecimal)n2);
            }
            case 0x4000400: {
                return this.op_boolean((Boolean)n1, (Boolean)n2);
            }
            case 0x800000: 
            case 0x800001: 
            case 0x800002: 
            case 0x800004: 
            case 0x800008: 
            case 0x800010: 
            case 0x800020: 
            case 0x800040: 
            case 0x800080: 
            case 0x800100: 
            case 0x800200: 
            case 0x800400: 
            case 0x800800: {
                return this.op_string((String)n1, n2);
            }
            case 128: 
            case 65664: 
            case 131200: 
            case 262272: 
            case 524416: 
            case 0x100080: 
            case 0x200080: 
            case 0x400080: 
            case 0x1000080: 
            case 0x2000080: 
            case 0x4000080: 
            case 0x8000080: {
                return this.op_string(n1, (String)n2);
            }
            case 0x8000001: 
            case 0x8000002: 
            case 0x8000004: 
            case 0x8000008: 
            case 0x8000010: 
            case 0x8000020: 
            case 0x8000040: 
            case 0x8000100: 
            case 0x8000200: 
            case 0x8000800: {
                return this.op_numeric((Numeric)n1, n2);
            }
            case 67584: 
            case 133120: 
            case 264192: 
            case 526336: 
            case 0x100800: 
            case 0x200800: 
            case 0x400800: 
            case 0x1000800: 
            case 0x2000800: {
                return this.op_numeric(n1, (Numeric)n2);
            }
        }
        return this.op_object(n1, n2);
    }

    static BigDecimal doubleToDecimal(double d) {
        return (BigDecimal)Runtime.decimalNumber("" + d, 10);
    }

    public static class LT
    extends BooleanOperator {
        static LT instance = new LT();

        public boolean op_int(int i1, int i2) {
            return i1 < i2;
        }

        public boolean op_long(long l1, long l2) {
            return l1 < l2;
        }

        public boolean op_float(float f1, float f2) {
            return f1 < f2;
        }

        public boolean op_double(double d1, double d2) {
            return d1 < d2;
        }

        public boolean op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.compareTo(d2) < 0;
        }

        public boolean op_bint(BigInteger b1, BigInteger b2) {
            return b1.compareTo(b2) < 0;
        }

        public boolean op_numeric(Numeric n1, Object n2) {
            return n1.compareTo(n2) < 0;
        }

        public boolean op_numeric(Object n1, Numeric n2) {
            return n2.compareTo(n1) > 0;
        }

        public boolean op_string(Object o, String s) {
            if (s != null && o != null) {
                return s.compareTo((String)o) > 0;
            }
            return super.op_string(o, s);
        }

        public boolean op_string(String s, Object o) {
            if (s != null && o != null) {
                return s.compareTo((String)o) < 0;
            }
            return super.op_string(s, o);
        }

        public boolean op_object(Object n1, Object n2) {
            return Runtime.compareObjects(n1, n2) < 0;
        }
    }

    public static class LE
    extends BooleanOperator {
        static LE instance = new LE();

        public boolean op_int(int i1, int i2) {
            return i1 <= i2;
        }

        public boolean op_long(long l1, long l2) {
            return l1 <= l2;
        }

        public boolean op_float(float f1, float f2) {
            return f1 <= f2;
        }

        public boolean op_double(double d1, double d2) {
            return d1 <= d2;
        }

        public boolean op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.compareTo(d2) <= 0;
        }

        public boolean op_bint(BigInteger b1, BigInteger b2) {
            return b1.compareTo(b2) <= 0;
        }

        public boolean op_numeric(Numeric n1, Object n2) {
            return n1.compareTo(n2) <= 0;
        }

        public boolean op_numeric(Object n1, Numeric n2) {
            return n2.compareTo(n1) >= 0;
        }

        public boolean op_string(Object o, String s) {
            if (s != null && o != null) {
                return s.compareTo((String)o) >= 0;
            }
            return super.op_string(o, s);
        }

        public boolean op_string(String s, Object o) {
            if (s != null && o != null) {
                return s.compareTo((String)o) <= 0;
            }
            return super.op_string(s, o);
        }

        public boolean op_object(Object n1, Object n2) {
            return Runtime.compareObjects(n1, n2) <= 0;
        }
    }

    public static class GT
    extends BooleanOperator {
        static GT instance = new GT();

        public boolean op_int(int i1, int i2) {
            return i1 > i2;
        }

        public boolean op_long(long l1, long l2) {
            return l1 > l2;
        }

        public boolean op_float(float f1, float f2) {
            return f1 > f2;
        }

        public boolean op_double(double d1, double d2) {
            return d1 > d2;
        }

        public boolean op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.compareTo(d2) > 0;
        }

        public boolean op_bint(BigInteger b1, BigInteger b2) {
            return b1.compareTo(b2) > 0;
        }

        public boolean op_numeric(Numeric n1, Object n2) {
            return n1.compareTo(n2) > 0;
        }

        public boolean op_numeric(Object n1, Numeric n2) {
            return n2.compareTo(n1) < 0;
        }

        public boolean op_string(Object o, String s) {
            if (s != null && o != null) {
                return s.compareTo((String)o) < 0;
            }
            return super.op_string(o, s);
        }

        public boolean op_string(String s, Object o) {
            if (s != null && o != null) {
                return s.compareTo((String)o) > 0;
            }
            return super.op_string(s, o);
        }

        public boolean op_object(Object n1, Object n2) {
            return Runtime.compareObjects(n1, n2) > 0;
        }
    }

    public static class GE
    extends BooleanOperator {
        static GE instance = new GE();

        public boolean op_int(int i1, int i2) {
            return i1 >= i2;
        }

        public boolean op_long(long l1, long l2) {
            return l1 >= l2;
        }

        public boolean op_float(float f1, float f2) {
            return f1 >= f2;
        }

        public boolean op_double(double d1, double d2) {
            return d1 >= d2;
        }

        public boolean op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.compareTo(d2) >= 0;
        }

        public boolean op_bint(BigInteger b1, BigInteger b2) {
            return b1.compareTo(b2) >= 0;
        }

        public boolean op_numeric(Numeric n1, Object n2) {
            return n1.compareTo(n2) >= 0;
        }

        public boolean op_numeric(Object n1, Numeric n2) {
            return n2.compareTo(n1) <= 0;
        }

        public boolean op_string(Object o, String s) {
            if (s != null && o != null) {
                return s.compareTo((String)o) < 0;
            }
            return super.op_string(o, s);
        }

        public boolean op_string(String s, Object o) {
            if (s != null && o != null) {
                return s.compareTo((String)o) >= 0;
            }
            return super.op_string(s, o);
        }

        public boolean op_object(Object n1, Object n2) {
            return Runtime.compareObjects(n1, n2) >= 0;
        }
    }

    public static class EQ
    extends BooleanOperator {
        static EQ instance = new EQ();

        public boolean op_int(int i1, int i2) {
            return i1 == i2;
        }

        public boolean op_long(long l1, long l2) {
            return l1 == l2;
        }

        public boolean op_float(float f1, float f2) {
            return f1 == f2;
        }

        public boolean op_double(double d1, double d2) {
            return d1 == d2;
        }

        public boolean op_bdec(BigDecimal d1, BigDecimal d2) {
            return d1.compareTo(d2) == 0;
        }

        public boolean op_bint(BigInteger b1, BigInteger b2) {
            return b1.compareTo(b2) == 0;
        }

        public boolean op_boolean(boolean b1, boolean b2) {
            return b1 == b2;
        }

        public boolean op_object(Object n1, Object n2) {
            if (n1 == null) {
                return n2 == null;
            }
            if (n2 == null) {
                return false;
            }
            if (Runtime.isArray(n1) && Runtime.isArray(n2)) {
                int len = 0;
                len = Runtime.getArrayLength(n2);
                if (len == Runtime.getArrayLength(n1)) {
                    for (int i = 0; i < len; ++i) {
                        Object e1 = Array.get(n1, i);
                        Object e2 = Array.get(n2, i);
                        if (!(e1 == null ? e2 != null : (Runtime.isArray(e1) ? !this.operateOn(e1, e2) : !e1.equals(e2)))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return n1.equals(n2);
        }

        public boolean op_numeric(Numeric n1, Object n2) {
            if (n1 == null) {
                return n2 == null;
            }
            if (n2 == null) {
                return false;
            }
            return n1.equals(n2);
        }

        public boolean op_numeric(Object n1, Numeric n2) {
            if (n1 == null) {
                return n2 == null;
            }
            if (n2 == null) {
                return false;
            }
            return n1.equals(n2);
        }

        public boolean op_string(String s, Object o) {
            return s.equals(o);
        }

        public boolean op_string(Object o, String s) {
            return s.equals(o);
        }
    }
}

