/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pnuts.util.Cache;
import org.pnuts.util.ComparableArrayList;
import org.pnuts.util.MemoryCache;
import pnuts.lang.BinaryOperator;
import pnuts.lang.BooleanOperator;
import pnuts.lang.Callable;
import pnuts.lang.Context;
import pnuts.lang.Java2Configuration;
import pnuts.lang.MerlinConfiguration;
import pnuts.lang.PnutsException;
import pnuts.lang.Runtime;
import pnuts.lang.TigerConfiguration;
import pnuts.lang.UnaryOperator;

public abstract class Configuration
implements Serializable {
    protected static final Configuration normalConfiguration;
    private static Configuration defaultConfiguration;
    protected BinaryOperator _add;
    protected BinaryOperator _subtract;
    protected BinaryOperator _multiply;
    protected BinaryOperator _mod;
    protected BinaryOperator _divide;
    protected BinaryOperator _shiftArithmetic;
    protected BinaryOperator _shiftLeft;
    protected BinaryOperator _shiftRight;
    protected BinaryOperator _and;
    protected BinaryOperator _or;
    protected BinaryOperator _xor;
    protected UnaryOperator _add1;
    protected UnaryOperator _subtract1;
    protected UnaryOperator _not;
    protected UnaryOperator _negate;
    protected BooleanOperator _eq;
    protected BooleanOperator _lt;
    protected BooleanOperator _le;
    protected BooleanOperator _gt;
    protected BooleanOperator _ge;
    String[] _imports;
    private static final String[] DEFAULT_IMPORTS;
    private transient Cache mtab = new MemoryCache();
    private transient Cache ctab = new MemoryCache();

    public static Configuration getDefault() {
        return defaultConfiguration;
    }

    static Configuration getDefault(Properties properties) {
        String property = properties.getProperty("pnuts.lang.defaultConfiguration");
        return Configuration.getInstance(property);
    }

    static Configuration getInstance(String className) {
        try {
            if (className != null && !className.equals("pnuts.lang.Configuration")) {
                Class<?> cls = Class.forName(className);
                return (Configuration)cls.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return normalConfiguration;
    }

    public Configuration() {
        this.initializeOperators();
    }

    protected String[] getDefaultImports() {
        return DEFAULT_IMPORTS;
    }

    protected void initializeOperators() {
        this._add = BinaryOperator.Add.instance;
        this._subtract = BinaryOperator.Subtract.instance;
        this._multiply = BinaryOperator.Multiply.instance;
        this._mod = BinaryOperator.Mod.instance;
        this._divide = BinaryOperator.Divide.instance;
        this._shiftArithmetic = BinaryOperator.ShiftArithmetic.instance;
        this._shiftLeft = BinaryOperator.ShiftLeft.instance;
        this._shiftRight = BinaryOperator.ShiftRight.instance;
        this._and = BinaryOperator.And.instance;
        this._or = BinaryOperator.Or.instance;
        this._xor = BinaryOperator.Xor.instance;
        this._add1 = UnaryOperator.Add1.instance;
        this._subtract1 = UnaryOperator.Subtract1.instance;
        this._not = UnaryOperator.Not.instance;
        this._negate = UnaryOperator.Negate.instance;
        this._eq = BooleanOperator.EQ.instance;
        this._lt = BooleanOperator.LT.instance;
        this._le = BooleanOperator.LE.instance;
        this._gt = BooleanOperator.GT.instance;
        this._ge = BooleanOperator.GE.instance;
    }

    public abstract Object getStaticField(Context var1, Class var2, String var3);

    public abstract void putStaticField(Context var1, Class var2, String var3, Object var4);

    public abstract Object getElement(Context var1, Object var2, Object var3);

    public abstract void setElement(Context var1, Object var2, Object var3, Object var4);

    public abstract Object callMethod(Context var1, Class var2, String var3, Object[] var4, Class[] var5, Object var6);

    public abstract Object callConstructor(Context var1, Class var2, Object[] var3, Class[] var4);

    public abstract Method[] getMethods(Class var1);

    public abstract Constructor[] getConstructors(Class var1);

    public abstract Object getRange(Context var1, Object var2, Object var3, Object var4);

    public abstract Object setRange(Context var1, Object var2, Object var3, Object var4, Object var5);

    public abstract Object getField(Context var1, Object var2, String var3);

    public abstract void putField(Context var1, Object var2, String var3, Object var4);

    public abstract Enumeration toEnumeration(Object var1);

    public abstract Callable toCallable(Object var1);

    public Object handleUndefinedSymbol(String symbol, Context context) {
        throw new PnutsException("not.defined", new Object[]{symbol}, context);
    }

    public Object makeArray(Object[] parameters, Context context) {
        return parameters;
    }

    public Map createMap(int size, Context context) {
        return new HashMap(size);
    }

    public List createList() {
        return new ComparableArrayList();
    }

    public String formatObject(Object obj) {
        return Runtime.format(obj, 64);
    }

    protected static Object invokeMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        return context.runtime._callMethod(context, c, name, args, types, target);
    }

    synchronized Method[] _getMethods(Class cls, String name) {
        Object v;
        Cache cache = (Cache)this.mtab.get(cls);
        if (cache == null) {
            cache = new MemoryCache();
            this.mtab.put(cls, cache);
        }
        if ((v = cache.get(name)) instanceof Method[]) {
            return (Method[])v;
        }
        Method[] m = this.getMethods(cls);
        if (m == null) {
            throw new NoClassDefFoundError("" + cls);
        }
        int j = 0;
        for (int i = 0; i < m.length; ++i) {
            String m_name = m[i].getName();
            if (!m_name.equals(name) || i < j) continue;
            m[j] = m[i];
            ++j;
        }
        Method[] m2 = new Method[j];
        System.arraycopy(m, 0, m2, 0, j);
        cache.put(name, m2);
        return m2;
    }

    synchronized Constructor[] _getConstructors(Class cls) {
        Object v = this.ctab.get(cls);
        if (v instanceof Constructor[]) {
            return (Constructor[])v;
        }
        Constructor[] con = this.getConstructors(cls);
        this.ctab.put(cls, con);
        return con;
    }

    Object reInvoke(IllegalAccessException t, Method method, Object target, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return normalConfiguration.reInvoke(t, method, target, args);
    }

    protected ClassLoader getInitialClassLoader() {
        return null;
    }

    void replace(StringBuffer buf, int start, int end, String str) {
        normalConfiguration.replace(buf, start, end, str);
    }

    BigDecimal longToBigDecimal(long lval) {
        return new BigDecimal(BigInteger.valueOf(lval));
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.mtab = new MemoryCache();
        this.ctab = new MemoryCache();
    }

    static {
        boolean hasIterable = false;
        try {
            Class.forName("java.lang.Iterable");
            hasIterable = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean hasCharSequence = false;
        try {
            Class.forName("java.lang.CharSequence");
            hasCharSequence = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        normalConfiguration = hasIterable ? new TigerConfiguration() : (hasCharSequence ? new MerlinConfiguration() : new Java2Configuration());
        defaultConfiguration = Configuration.getInstance(Runtime.getProperty("pnuts.lang.defaultConfiguration"));
        DEFAULT_IMPORTS = new String[]{"*", "java.lang.*"};
    }
}

