/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.pnuts.util.Cell;
import pnuts.lang.AutoloadHook;
import pnuts.lang.BinaryOperator;
import pnuts.lang.Binding;
import pnuts.lang.BooleanOperator;
import pnuts.lang.Configuration;
import pnuts.lang.Executable;
import pnuts.lang.Function;
import pnuts.lang.Implementation;
import pnuts.lang.ImportEnv;
import pnuts.lang.ModuleList;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsImpl;
import pnuts.lang.QuantityFactory;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.StackFrame;
import pnuts.lang.SymbolTable;
import pnuts.lang.UnaryOperator;
import pnuts.lang.Value;

public class Context
implements Cloneable {
    private static final boolean DEBUG = false;
    public static final PrintWriter defaultOutputStream;
    public static final PrintWriter defaultTerminalStream;
    public static final PrintWriter defaultErrorStream;
    private static final Object UNDEF;
    static String exceptionHandlerTableSymbol;
    static String finallyFunctionSymbol;
    private ImportEnv defaultImports;
    static Configuration defaultConfig;
    static boolean defaultVerboseMode;
    private static Runtime defaultRuntime;
    private static PnutsImpl defaultPnutsImpl;
    Implementation pnutsImpl = defaultPnutsImpl;
    boolean eval = false;
    Context parent;
    protected int depth = 0;
    Function frame;
    StackFrame stackFrame;
    protected Cell loadingResource;
    protected int beginLine = -1;
    protected int endLine = -1;
    protected int beginColumn = -1;
    protected ImportEnv importEnv;
    protected ModuleList moduleList;
    ModuleList localModuleList;
    private Set pendingModules;
    protected SymbolTable provideTable = new SymbolTable();
    protected Hashtable unitTable;
    protected SymbolTable environment;
    String encoding;
    static SymbolTable globals;
    private PrintWriter outputWriter;
    private OutputStream outputStream;
    private PrintWriter errorWriter;
    private PrintWriter terminalWriter;
    private String name;
    ClassLoader[] classLoader;
    boolean[] namespaceRefreshed = new boolean[]{false};
    Runtime runtime = defaultRuntime;
    boolean inGeneratorClosure;
    BinaryOperator _add;
    BinaryOperator _subtract;
    BinaryOperator _multiply;
    BinaryOperator _mod;
    BinaryOperator _divide;
    BinaryOperator _shiftArithmetic;
    BinaryOperator _shiftLeft;
    BinaryOperator _shiftRight;
    BinaryOperator _and;
    BinaryOperator _or;
    BinaryOperator _xor;
    UnaryOperator _add1;
    UnaryOperator _subtract1;
    UnaryOperator _not;
    UnaryOperator _negate;
    BooleanOperator _eq;
    BooleanOperator _lt;
    BooleanOperator _le;
    BooleanOperator _gt;
    BooleanOperator _ge;
    Executable exitHook;
    Package currentPackage = Package.getGlobalPackage();
    Package rootPackage;
    Configuration config;
    boolean verbose;
    static Map primitiveTypes;

    public Context() {
        this(Package.getGlobalPackage());
    }

    public Context(String pkg) {
        this(Package.getPackage(pkg, null));
    }

    public Context(Package pkg) {
        this.setConfiguration(defaultConfig);
        this.currentPackage.init(this);
        this.rootPackage = this.currentPackage;
        this.verbose = defaultVerboseMode;
        if (pkg != null) {
            this.setCurrentPackage(pkg);
        }
        this.outputWriter = defaultOutputStream;
        this.outputStream = System.out;
        this.terminalWriter = defaultTerminalStream;
        this.errorWriter = defaultErrorStream;
        this.classLoader = new ClassLoader[]{this.config.getInitialClassLoader()};
        this.importEnv = this.defaultImports;
    }

    public Context(Context context) {
        this.setConfiguration(defaultConfig);
        this.currentPackage.init(this);
        this.rootPackage = this.currentPackage;
        this.verbose = defaultVerboseMode;
        this.outputWriter = context.outputWriter;
        this.errorWriter = context.errorWriter;
        this.terminalWriter = context.terminalWriter;
        this.currentPackage = context.currentPackage;
        this.pnutsImpl = context.pnutsImpl;
        this.encoding = context.encoding;
        this.setConfiguration(context.config);
        this.classLoader = new ClassLoader[]{context.classLoader[0]};
        this.namespaceRefreshed = new boolean[]{context.namespaceRefreshed[0]};
        this.importEnv = (ImportEnv)context.importEnv.clone();
        if (context.moduleList != null) {
            this.moduleList = (ModuleList)context.moduleList.clone();
        }
        if (context.localModuleList != null) {
            this.localModuleList = (ModuleList)context.localModuleList.clone();
        }
        if (context.unitTable != null) {
            this.unitTable = (Hashtable)context.unitTable.clone();
        }
        if (context.environment != null) {
            this.environment = (SymbolTable)context.environment.clone();
        }
        this.provideTable = (SymbolTable)context.provideTable.clone();
    }

    public Context(Properties properties) {
        this.setConfiguration(defaultConfig);
        this.currentPackage.init(this);
        this.rootPackage = this.currentPackage;
        this.verbose = defaultVerboseMode;
        this.setConfiguration(Configuration.getDefault(properties));
        this.setImplementation(PnutsImpl.getDefault(properties));
    }

    public Object clone() {
        return this.clone(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone(boolean clear_attributes, boolean clear_locals) {
        Context context = this;
        synchronized (context) {
            if (this.moduleList == null) {
                this.moduleList = new ModuleList(this.currentPackage);
            }
        }
        try {
            Context ret = (Context)super.clone();
            if (clear_locals) {
                if (this.stackFrame != null) {
                    ret.stackFrame = new StackFrame();
                }
                ret.parent = this;
                if (this.environment != null) {
                    ret.environment = new SymbolTable(this.environment);
                }
            }
            if (clear_attributes) {
                ret.eval = false;
                ret.frame = null;
                ret.importEnv = this.defaultImports;
                ret.currentPackage = this.rootPackage;
                ret.beginLine = -1;
                ret.beginColumn = -1;
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new PnutsException(e, this);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPnutsImpl(PnutsImpl impl) {
        this.setImplementation(impl);
    }

    public PnutsImpl getPnutsImpl() {
        return (PnutsImpl)this.getImplementation();
    }

    public void setImplementation(Implementation impl) {
        if (impl != null) {
            this.pnutsImpl = impl;
        }
    }

    public Implementation getImplementation() {
        return this.pnutsImpl;
    }

    public Object get(String symbol) {
        NamedValue v;
        if (this.environment != null && (v = this.environment.lookup(symbol)) != null) {
            return v.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String symbol, Object value) {
        Context context = this;
        synchronized (context) {
            if (this.environment == null) {
                this.environment = new SymbolTable();
            }
        }
        this.environment.set(symbol, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration keys() {
        Context context = this;
        synchronized (context) {
            if (this.environment == null) {
                this.environment = new SymbolTable();
            }
        }
        return this.environment.keys();
    }

    public void setOutputStream(Object out, boolean autoFlush) {
        if (out instanceof PrintWriter || out == null) {
            this.outputWriter = (PrintWriter)out;
            this.outputStream = null;
        } else if (out instanceof OutputStream) {
            this.outputStream = (OutputStream)out;
            this.outputWriter = new PrintWriter((OutputStream)out, autoFlush);
        } else if (out instanceof Writer) {
            this.outputStream = null;
            this.outputWriter = new PrintWriter((Writer)out, autoFlush);
        } else {
            throw new IllegalArgumentException(Runtime.getMessage("pnuts.lang.pnuts", "illegal.streamType", PnutsException.NO_PARAM));
        }
    }

    public void setOutputStream(Object outputStream) {
        this.setOutputStream(outputStream, false);
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
        this.outputWriter = out == null ? null : new PrintWriter(out, false);
    }

    public void setWriter(Writer out) {
        this.setWriter(out, false);
    }

    public void setWriter(Writer out, boolean autoFlush) {
        this.outputStream = null;
        this.outputWriter = out instanceof PrintWriter || out == null ? (PrintWriter)out : new PrintWriter(out, autoFlush);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() {
        return this.outputWriter;
    }

    public void setTerminalStream(Object str, boolean autoFlush) {
        if (str == null) {
            this.terminalWriter = null;
        } else if (str instanceof OutputStream) {
            this.terminalWriter = new PrintWriter((OutputStream)str, autoFlush);
        } else if (str instanceof Writer) {
            this.terminalWriter = new PrintWriter((Writer)str, autoFlush);
        } else {
            throw new IllegalArgumentException(Runtime.getMessage("pnuts.lang.pnuts", "illegal.streamType", PnutsException.NO_PARAM));
        }
    }

    public void setTerminalStream(Object stream) {
        if (stream == null) {
            this.terminalWriter = null;
        } else if (stream instanceof PrintWriter) {
            this.terminalWriter = (PrintWriter)stream;
        } else if (stream instanceof Writer) {
            this.terminalWriter = new PrintWriter((Writer)stream, true);
        } else if (stream instanceof OutputStream) {
            this.terminalWriter = new PrintWriter((OutputStream)stream, true);
        } else {
            throw new IllegalArgumentException(String.valueOf(stream));
        }
    }

    public void setTerminalWriter(Writer w) {
        this.terminalWriter = w instanceof PrintWriter || w == null ? (PrintWriter)w : new PrintWriter(w);
    }

    public void setTerminalWriter(Writer w, boolean autoFlush) {
        this.terminalWriter = w == null ? null : new PrintWriter(w, autoFlush);
    }

    public PrintWriter getTerminalStream() {
        return this.terminalWriter;
    }

    public PrintWriter getTerminalWriter() {
        return this.terminalWriter;
    }

    public void setErrorStream(Object errorStream, boolean autoFlush) {
        if (errorStream == null) {
            this.errorWriter = null;
        } else if (errorStream instanceof OutputStream) {
            this.errorWriter = new PrintWriter((OutputStream)errorStream, autoFlush);
        } else if (errorStream instanceof Writer) {
            this.errorWriter = new PrintWriter((Writer)errorStream, autoFlush);
        } else {
            throw new IllegalArgumentException(Runtime.getMessage("pnuts.lang.pnuts", "illegal.streamType", PnutsException.NO_PARAM));
        }
    }

    public void setErrorStream(Object errorStream) {
        if (errorStream == null) {
            this.errorWriter = null;
        } else if (errorStream instanceof OutputStream) {
            this.errorWriter = new PrintWriter((OutputStream)errorStream, false);
        } else if (errorStream instanceof PrintWriter) {
            this.errorWriter = (PrintWriter)errorStream;
        } else if (errorStream instanceof Writer) {
            this.errorWriter = new PrintWriter((Writer)errorStream, false);
        } else {
            throw new IllegalArgumentException(String.valueOf(errorStream));
        }
    }

    public void setErrorWriter(Writer w, boolean autoFlush) {
        this.errorWriter = w instanceof PrintWriter || w == null ? (PrintWriter)w : new PrintWriter(w, autoFlush);
    }

    public void setErrorWriter(Writer w) {
        if (w instanceof PrintWriter || w == null) {
            this.errorWriter = (PrintWriter)w;
        } else {
            this.setErrorWriter(w, false);
        }
    }

    public PrintWriter getErrorStream() {
        return this.errorWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public Package getCurrentPackage() {
        return this.currentPackage;
    }

    public void setCurrentPackage(Package pkg) {
        pkg.init(this);
        this.currentPackage = pkg;
        Package root = pkg.root;
        if (root != null) {
            this.rootPackage = root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassLoader(ClassLoader loader) {
        this.classLoader[0] = loader;
        boolean[] blArray = this.namespaceRefreshed;
        synchronized (this.namespaceRefreshed) {
            this.namespaceRefreshed[0] = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader[0];
    }

    public void setConfiguration(Configuration config) {
        if (config == null) {
            return;
        }
        this.config = config;
        this.defaultImports = Runtime.getDefaultImports(this);
        if (this.importEnv == null) {
            this.importEnv = this.defaultImports;
        }
        this._add = config._add;
        this._add1 = config._add1;
        this._subtract = config._subtract;
        this._subtract1 = config._subtract1;
        this._multiply = config._multiply;
        this._mod = config._mod;
        this._divide = config._divide;
        this._shiftArithmetic = config._shiftArithmetic;
        this._shiftLeft = config._shiftLeft;
        this._shiftRight = config._shiftRight;
        this._and = config._and;
        this._or = config._or;
        this._xor = config._xor;
        this._not = config._not;
        this._negate = config._negate;
        this._eq = config._eq;
        this._lt = config._lt;
        this._le = config._le;
        this._gt = config._gt;
        this._ge = config._ge;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setExitHook(Executable hook) {
        this.exitHook = hook;
    }

    public Executable getExitHook() {
        return this.exitHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClassToImport(String className) {
        Context context = this;
        synchronized (context) {
            if (this.importEnv == this.defaultImports) {
                this.importEnv = (ImportEnv)this.importEnv.clone();
            }
        }
        this.importEnv.addClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPackageToImport(String pkgName) {
        Context context = this;
        synchronized (context) {
            if (this.importEnv == this.defaultImports) {
                this.importEnv = (ImportEnv)this.importEnv.clone();
            }
        }
        this.importEnv.addPackage(pkgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStaticMembers(String name, boolean wildcard) {
        Context context = this;
        synchronized (context) {
            if (this.importEnv == this.defaultImports) {
                this.importEnv = (ImportEnv)this.importEnv.clone();
            }
        }
        this.importEnv.addStaticMembers(name, wildcard, this);
    }

    synchronized void pushFile(Object file) {
        Cell cell = new Cell();
        cell.object = file;
        cell.next = this.loadingResource;
        this.loadingResource = cell;
    }

    synchronized void popFile() {
        if (this.exitHook != null) {
            this.exitHook.run(this);
        }
        if (this.loadingResource != null) {
            this.loadingResource = this.loadingResource.next;
        }
    }

    public synchronized boolean unusePackage(Package pkg) {
        if (this.moduleList != null && this.moduleList.remove(pkg)) {
            this.localModuleList = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean usePackage(Package pkg, boolean checkException) {
        Context context = this;
        synchronized (context) {
            if (this.moduleList == null) {
                this.moduleList = new ModuleList(this.currentPackage);
            }
            if (this.pendingModules == null) {
                this.pendingModules = new HashSet();
            }
        }
        boolean pending = this.pendingModules.contains(pkg);
        try {
            if (!pending && !this.moduleList.contains(pkg)) {
                if (pkg.usedAsModule) {
                    String m;
                    Context ctx = (Context)this.clone();
                    ctx.setCurrentPackage(pkg);
                    Enumeration e = pkg.providedModuleNames.elements();
                    while (e.hasMoreElements()) {
                        m = (String)e.nextElement();
                        ctx.usePackage(m);
                    }
                    if (pkg.requiredModuleNames.size() > 0) {
                        ctx = (Context)ctx.clone();
                        ctx.clearPackages();
                    }
                    e = pkg.requiredModuleNames.elements();
                    while (e.hasMoreElements()) {
                        m = (String)e.nextElement();
                        ctx.usePackage(m);
                    }
                } else {
                    pkg.initializeModule();
                }
                String name = pkg.getName();
                Object object = pkg.moduleIntializationLock;
                synchronized (object) {
                    this.pendingModules.add(pkg);
                    try {
                        if (!pkg.initialized) {
                            if (name != null) {
                                this.loadModule(name, pkg);
                            }
                            pkg.initialized = true;
                        }
                    }
                    finally {
                        this.pendingModules.remove(pkg);
                    }
                    if (name != null && this.moduleList != null && this.currentPackage.usedAsModule) {
                        if (this.moduleList.basePackage != this.currentPackage) {
                            this.currentPackage.providedModuleNames.addElement(name);
                        } else {
                            this.currentPackage.requiredModuleNames.addElement(name);
                        }
                    }
                }
            }
            if (!pending) {
                this.moduleList.add(pkg);
            }
            this.localModuleList = null;
            return true;
        }
        catch (Throwable t) {
            if (checkException) {
                Runtime.checkException(this, t);
            } else if (this.verbose && this.terminalWriter != null) {
                t.printStackTrace(this.terminalWriter);
            }
            return false;
        }
    }

    public boolean usePackage(String name) {
        return this.usePackage(name, false);
    }

    public boolean usePackage(String name, boolean checkException) {
        return this.usePackage(Package.getPackage(name, this), checkException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadModule(String name, Package pkg) throws IOException {
        FileNotFoundException notfound;
        block10: {
            URL url;
            Context ctx = (Context)this.clone();
            ctx.setCurrentPackage(pkg);
            ctx.config = defaultConfig;
            notfound = null;
            try {
                Pnuts.load(pkg.getInitScript(), ctx);
            }
            catch (FileNotFoundException e) {
                notfound = e;
            }
            if (notfound != null && (url = Pnuts.getResource("META-INF/pnuts/module/" + name, this)) != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                try {
                    String line = br.readLine();
                    if (line == null) break block10;
                    Pnuts.load(line.trim(), ctx);
                    notfound = null;
                }
                finally {
                    br.close();
                }
            }
        }
        if (notfound != null) {
            throw notfound;
        }
        if (!pkg.exports) {
            pkg.exportFunctions();
        }
    }

    public synchronized void clearPackages() {
        this.moduleList = new ModuleList(this.currentPackage);
        this.localModuleList = null;
    }

    synchronized ModuleList localModuleList() {
        ModuleList list = this.localModuleList;
        if (list == null && this.moduleList != null) {
            list = this.localModuleList = (ModuleList)this.moduleList.clone();
        }
        return list;
    }

    public String[] usedPackages() {
        if (this.moduleList == null) {
            return new String[0];
        }
        return this.moduleList.getPackageNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void require(String file, boolean checkForUpdate) throws FileNotFoundException {
        Binding b;
        SymbolTable table;
        Cloneable cloneable = table = this.provideTable;
        synchronized (cloneable) {
            b = table.lookup0(file);
            if (b == null) {
                table.set(file, null);
                b = table.lookup0(file);
            }
        }
        cloneable = b;
        synchronized (cloneable) {
            long m;
            Long timestamp = (Long)b.value;
            if (timestamp == null) {
                Pnuts.load(file, this);
            } else if (checkForUpdate && (m = this.lastModified(file)) > timestamp) {
                Pnuts.load(file, this);
            }
        }
    }

    long lastModified(String file) {
        try {
            URL url = Runtime.getScriptURL(file + ".pnut", this);
            if (url == null) {
                return -1L;
            }
            URLConnection c = url.openConnection();
            return c.getLastModified();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void provide(String file) {
        Binding b;
        SymbolTable table;
        file = file.intern();
        Cloneable cloneable = table = this.provideTable;
        synchronized (cloneable) {
            b = table.lookup0(file);
            if (b == null) {
                table.set(file, null);
                b = table.lookup0(file);
            }
        }
        cloneable = b;
        synchronized (cloneable) {
            b.set(new Long(System.currentTimeMillis()));
        }
    }

    void revoke(String file) {
        file = file.intern();
        this.provideTable.removeBinding(file);
    }

    protected Object getScriptSource() {
        if (this.frame != null) {
            return this.frame.file;
        }
        Cell c = this.loadingResource;
        if (c != null) {
            return c.object;
        }
        return null;
    }

    void updateLine(SimpleNode node) {
        this.updateLine(node, node.beginLine, node.beginColumn);
    }

    protected void updateLine(SimpleNode node, int beginLine, int beginColumn) {
        this.updateLine(beginLine);
        this.updateColumn(beginColumn);
    }

    protected void updateLine(int line) {
        if (line > 0) {
            this.beginLine = line;
            this.endLine = line;
            this.beginColumn = -1;
        }
    }

    protected void updateColumn(int column) {
        if (column > 0) {
            this.beginColumn = column;
        }
    }

    protected void onExit(Object arg) {
    }

    protected void onError(Throwable t) {
    }

    public Object getId(String interned) {
        Object v = this._getId(interned);
        if (v == UNDEF) {
            return this.undefined(interned);
        }
        return v;
    }

    public Object resolveSymbol(String interned) {
        Object v = this._getId(interned);
        if (v == UNDEF) {
            return null;
        }
        return v;
    }

    public Class resolveClass(String symbol) {
        Object value;
        Class type = (Class)primitiveTypes.get(symbol);
        if (type != null) {
            return type;
        }
        if (symbol.indexOf(46) > 0) {
            try {
                return Pnuts.loadClass(symbol, this);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        NamedValue binding = this.currentPackage.lookup(symbol);
        if (binding != null && (value = binding.get()) instanceof Class) {
            return (Class)value;
        }
        Object obj = this.importEnv.get(symbol, this);
        if (obj instanceof Class) {
            return (Class)obj;
        }
        obj = this._getId(symbol);
        if (obj instanceof Class) {
            return (Class)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object _getId(String symbol) {
        Value v = this.currentPackage.lookup(symbol, this);
        if (v != null) {
            return v.get();
        }
        v = globals.lookup0(symbol);
        if (v != null) {
            return v.get();
        }
        if (this.moduleList != null && (v = this.moduleList.resolve(symbol, this)) != null) {
            return v.get();
        }
        if (symbol.charAt(0) == '!') {
            return null;
        }
        boolean[] blArray = this.namespaceRefreshed;
        synchronized (this.namespaceRefreshed) {
            if (this.namespaceRefreshed[0]) {
                this.resetImportEnv();
            }
            this.namespaceRefreshed[0] = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Object c = this.importEnv.get(symbol, this);
            if (c != null) {
                return c;
            }
            Package parent = this.currentPackage.getParent();
            if (parent != null) {
                v = parent.lookupRecursively(symbol, this);
            }
            if (v != null) {
                return v.get();
            }
            return UNDEF;
        }
    }

    void resetImportEnv() {
        this.importEnv.reset();
        if (this.parent != null) {
            this.parent.resetImportEnv();
        }
    }

    public void autoload(String name, String file) {
        this.currentPackage.autoload(name, file, this);
    }

    public void autoload(String name, AutoloadHook hook) {
        this.currentPackage.autoload(name, hook);
    }

    Object undefined(String sym) {
        return this.config.handleUndefinedSymbol(sym, this);
    }

    public boolean defined(String name) {
        return this._getId(name.intern()) != UNDEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQuantityFactory(String unit, QuantityFactory fac) {
        Context context = this;
        synchronized (context) {
            if (this.unitTable == null) {
                this.unitTable = new Hashtable(8);
            }
        }
        if (fac != null) {
            this.unitTable.put(unit, fac);
        } else {
            this.unitTable.remove(unit);
        }
    }

    protected void open(Function f, Object[] args) {
        String[] locals = f.locals;
        StackFrame sf = this.stackFrame = new StackFrame(locals, this.stackFrame);
        for (int i = 0; i < args.length; ++i) {
            sf.bind(locals[i], args[i]);
        }
        if (f.outer != null && f.name != null) {
            sf.bind(f.name, f.function);
        }
    }

    protected void close(Function func, Object[] args) {
        this.stackFrame = this.stackFrame.parent;
    }

    void openLocal(String[] locals) {
        this.stackFrame.openLocal(locals);
    }

    void closeLocal() {
        this.stackFrame.closeLocal();
    }

    final void bind(String symbol, Object obj) {
        this.stackFrame.bind(symbol, obj);
    }

    void resetStackFrame() {
        if (this.stackFrame != null) {
            this.stackFrame = new StackFrame();
        }
    }

    protected Object getValue(String symbol) {
        Object val;
        if (this.stackFrame != null) {
            Binding b = (Binding)this.stackFrame.lookup(symbol);
            if (b != null) {
                return b.value;
            }
            Function ff = this.frame;
            while (ff != null) {
                Binding bb;
                SymbolTable ls = ff.lexicalScope;
                if (ls != null && (bb = ls.lookup0(symbol)) != null) {
                    return ((Binding)bb.value).value;
                }
                ff = ff.outer;
            }
        }
        if ((val = this._getId(symbol)) == UNDEF) {
            return this.undefined(symbol);
        }
        return val;
    }

    protected void setValue(String symbol, Object obj) {
        Binding b = (Binding)this.stackFrame.lookup(symbol);
        if (b != null) {
            b.value = obj;
            return;
        }
        Function ff = this.frame;
        while (ff != null) {
            Binding bb;
            SymbolTable ls = ff.lexicalScope;
            if (ls != null && (bb = ls.lookup0(symbol)) != null) {
                ((Binding)bb.value).value = obj;
                return;
            }
            ff = ff.outer;
        }
        if (this.stackFrame.parent != null) {
            this.stackFrame.declare(symbol, obj);
        } else {
            this.currentPackage.set(symbol, obj, this);
        }
    }

    void catchException(Class t, PnutsFunction f) {
        if (this.stackFrame.parent != null) {
            Runtime.TypeMap tmap = null;
            NamedValue b = this.stackFrame.lookup(exceptionHandlerTableSymbol);
            if (b != null) {
                tmap = (Runtime.TypeMap)b.get();
            }
            Runtime.TypeMap newtmap = new Runtime.TypeMap(t, f, tmap);
            this.stackFrame.declare(exceptionHandlerTableSymbol, newtmap);
        } else {
            Runtime.catchException(t, f, this);
        }
    }

    void setFinallyFunction(PnutsFunction func) {
        if (this.stackFrame.parent != null) {
            this.stackFrame.declare(finallyFunctionSymbol, func);
            if (this.frame != null) {
                this.frame.finallySet = true;
            }
        } else {
            Runtime.setExitHook(this, func);
        }
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setScriptEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getScriptEncoding() {
        return this.encoding;
    }

    static {
        defaultTerminalStream = defaultOutputStream = new PrintWriter(System.out, false);
        defaultErrorStream = new PrintWriter(System.err, true);
        UNDEF = new Object[0];
        exceptionHandlerTableSymbol = Runtime.EXCEPTOIN_FIELD_SYMBOL;
        finallyFunctionSymbol = "!finally".intern();
        defaultConfig = Configuration.getDefault();
        defaultVerboseMode = false;
        try {
            String vb = Runtime.getProperty("pnuts.verbose");
            if (vb != null) {
                defaultVerboseMode = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        defaultRuntime = new Runtime();
        defaultPnutsImpl = PnutsImpl.getDefault();
        globals = new SymbolTable();
        globals.set("pnuts_version".intern(), "1.1");
        globals.set(Runtime.INT_SYMBOL, Integer.TYPE);
        globals.set(Runtime.SHORT_SYMBOL, Short.TYPE);
        globals.set(Runtime.CHAR_SYMBOL, Character.TYPE);
        globals.set(Runtime.BYTE_SYMBOL, Byte.TYPE);
        globals.set(Runtime.LONG_SYMBOL, Long.TYPE);
        globals.set(Runtime.FLOAT_SYMBOL, Float.TYPE);
        globals.set(Runtime.DOUBLE_SYMBOL, Double.TYPE);
        globals.set(Runtime.BOOLEAN_SYMBOL, Boolean.TYPE);
        globals.set(Runtime.VOID_SYMBOL, Void.TYPE);
        PnutsFunction[] builtins = PnutsFunction.primitives;
        for (int i = 0; i < builtins.length; ++i) {
            globals.set(builtins[i].getName().intern(), builtins[i]);
        }
        primitiveTypes = new HashMap();
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
    }
}

