/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.pnuts.lang.CallableMethod;
import org.pnuts.util.LRUCache;
import pnuts.lang.Context;
import pnuts.lang.Import;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;

class ImportEnv
implements Serializable,
Cloneable {
    static final long serialVersionUID = -755390125835215465L;
    private HashMap imports = new HashMap();
    private HashMap importedClasses = new HashMap();
    private HashMap statics = new HashMap();
    private ArrayList pkgOrder = new ArrayList();
    private ArrayList classOrder = new ArrayList();
    private ArrayList staticsOrder = new ArrayList();
    private transient LRUCache cache = new LRUCache(32);
    private transient LRUCache failCache = new LRUCache(32);

    ImportEnv() {
    }

    private Import getImport(String name) {
        Import imp = (Import)this.imports.get(name);
        if (imp != null) {
            return imp;
        }
        return new Import(name);
    }

    synchronized void addClass(String className) {
        int idx = className.lastIndexOf(46);
        String name = className.substring(idx + 1);
        ArrayList<String> vec = (ArrayList<String>)this.importedClasses.get(name);
        if (vec == null) {
            vec = new ArrayList<String>();
            this.importedClasses.put(name, vec);
        }
        this.classOrder.remove(className);
        this.classOrder.add(className);
        vec.remove(className);
        vec.add(className);
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
    }

    synchronized void addPackage(String pkgname) {
        Import imp = (Import)this.imports.get(pkgname);
        if (imp != null) {
            this.pkgOrder.remove(imp);
        } else {
            imp = this.getImport(pkgname);
        }
        this.pkgOrder.add(imp);
        this.imports.put(pkgname, imp);
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
    }

    void addStaticMembers(String name, boolean wildcard, Context context) {
        String arg = wildcard ? name + ".*" : name;
        this.staticsOrder.remove(arg);
        this.staticsOrder.add(arg);
        try {
            if (wildcard) {
                Class cls = Pnuts.loadClass(name, context);
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field f = fields[i];
                    if (!Modifier.isStatic(f.getModifiers())) continue;
                    this.statics.put(f.getName(), f.get(null));
                }
                HashSet<String> names = new HashSet<String>();
                Method[] methods = cls.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    if (!Modifier.isStatic(m.getModifiers())) continue;
                    names.add(m.getName());
                }
                Iterator it = names.iterator();
                while (it.hasNext()) {
                    String memberName = (String)it.next();
                    this.statics.put(memberName, new CallableMethod(cls, memberName));
                }
            } else {
                int idx = name.lastIndexOf(46);
                if (idx > 0) {
                    String className = name.substring(0, idx);
                    String memberName = name.substring(idx + 1);
                    Class cls = Pnuts.loadClass(className, context);
                    try {
                        Field f = cls.getField(memberName);
                        if (Modifier.isStatic(f.getModifiers())) {
                            this.statics.put(memberName, f.get(null));
                            return;
                        }
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                    this.statics.put(memberName, new CallableMethod(cls, memberName));
                }
            }
            this.cache = new LRUCache(32);
            this.failCache = new LRUCache(32);
        }
        catch (ClassNotFoundException e1) {
            throw new PnutsException(e1, context);
        }
        catch (IllegalAccessException e2) {
            throw new PnutsException(e2, context);
        }
    }

    synchronized Object get(String sym, Context context) {
        Object v = this.cache.get(sym);
        if (v != null) {
            return v;
        }
        List vec = (List)this.importedClasses.get(sym);
        if (vec != null) {
            int size = vec.size();
            for (int i = size - 1; i >= 0; --i) {
                try {
                    return Pnuts.loadClass((String)vec.get(i), context);
                }
                catch (ClassNotFoundException cnf) {
                    continue;
                }
            }
        }
        int symlen = sym.length();
        StringBuffer buf = new StringBuffer(sym);
        boolean lowercase = !Character.isUpperCase(sym.charAt(0));
        int size = this.pkgOrder.size();
        for (int i = size - 1; i >= 0; --i) {
            Import imp = (Import)this.pkgOrder.get(i);
            buf.setLength(symlen);
            String name = imp.getName();
            if (lowercase && name.startsWith("java.")) continue;
            buf.append(name);
            String key = buf.toString();
            if (this.failCache.get(key) != null) continue;
            Class value = imp.get(sym, context);
            if (value != null) {
                this.cache.put(sym, value);
                return value;
            }
            this.failCache.put(key, key);
        }
        Object value = this.statics.get(sym);
        if (value != null) {
            this.cache.put(sym, value);
            return value;
        }
        return null;
    }

    String[] list() {
        String[] ret = new String[this.pkgOrder.size() + this.classOrder.size() + this.staticsOrder.size()];
        int i = ret.length - 1;
        Iterator it = this.staticsOrder.iterator();
        while (it.hasNext()) {
            ret[i--] = "static " + (String)it.next();
        }
        it = this.pkgOrder.iterator();
        while (it.hasNext()) {
            String name = ((Import)it.next()).getName();
            if ("".equals(name)) {
                ret[i--] = "*";
                continue;
            }
            ret[i--] = name + ".*";
        }
        it = this.classOrder.iterator();
        while (it.hasNext()) {
            ret[i--] = (String)it.next();
        }
        return ret;
    }

    void reset() {
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
        Iterator it = this.pkgOrder.iterator();
        while (it.hasNext()) {
            ((Import)it.next()).reset();
        }
    }

    public Object clone() {
        try {
            ImportEnv c = (ImportEnv)super.clone();
            c.imports = (HashMap)this.imports.clone();
            c.importedClasses = (HashMap)this.importedClasses.clone();
            c.pkgOrder = (ArrayList)this.pkgOrder.clone();
            c.classOrder = (ArrayList)this.classOrder.clone();
            c.statics = (HashMap)this.statics.clone();
            c.staticsOrder = (ArrayList)this.staticsOrder.clone();
            c.cache = new LRUCache(32);
            c.failCache = new LRUCache(32);
            return c;
        }
        catch (Throwable t) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
    }
}

