/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import org.pnuts.util.Stack;
import pnuts.lang.SimpleNode;

class JJTPnutsParserState {
    private Stack nodes = new Stack();
    private Stack marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;

    JJTPnutsParserState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    void pushNode(SimpleNode n) {
        this.nodes.push(n);
        ++this.sp;
    }

    SimpleNode popNode() {
        if (--this.sp < this.mk) {
            this.mk = (Integer)this.marks.pop();
        }
        return (SimpleNode)this.nodes.pop();
    }

    SimpleNode peekNode() {
        return (SimpleNode)this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void clearNodeScope(SimpleNode n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = (Integer)this.marks.pop();
    }

    void openNodeScope(SimpleNode n) {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
    }

    void closeNodeScope(SimpleNode n, int num) {
        this.mk = (Integer)this.marks.pop();
        while (num-- > 0) {
            SimpleNode c = this.popNode();
            c.jjtSetParent(n);
            n.jjtAddChild(c, num);
        }
        this.pushNode(n);
        this.node_created = true;
    }

    void closeNodeScope(SimpleNode n, boolean condition) {
        if (condition) {
            int a = this.nodeArity();
            this.mk = (Integer)this.marks.pop();
            while (a-- > 0) {
                SimpleNode c = this.popNode();
                c.jjtSetParent(n);
                n.jjtAddChild(c, a);
            }
            this.pushNode(n);
            this.node_created = true;
        } else {
            this.mk = (Integer)this.marks.pop();
            this.node_created = false;
        }
    }
}

