/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.pnuts.lang.DefaultParseEnv;
import org.pnuts.lang.PnutsClassLoader;
import org.pnuts.util.Stack;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.Executable;
import pnuts.lang.Function;
import pnuts.lang.Jump;
import pnuts.lang.Package;
import pnuts.lang.ParseEnvironment;
import pnuts.lang.ParseException;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsParser;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.Token;
import pnuts.lang.Visitor;

public class Pnuts
implements Executable,
Serializable {
    static final long serialVersionUID = -3167186981826418367L;
    public static final String pnuts_version = "1.1";
    public static String prompt = "> ";
    static String compiledClassPrefix;
    static Properties defaultSettings;
    private static Stack freeParsers;
    private static int java2;
    protected SimpleNode startNodes = null;
    protected Object scriptSource;

    static String getCompiledClassPrefix() {
        if (compiledClassPrefix == null) {
            try {
                compiledClassPrefix = Runtime.getProperty("pnuts.compiled.script.prefix");
                if (compiledClassPrefix == null) {
                    compiledClassPrefix = "";
                } else if (!"".equals(compiledClassPrefix) && !compiledClassPrefix.endsWith(".")) {
                    compiledClassPrefix = compiledClassPrefix + ".";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return compiledClassPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PnutsParser getParser(Reader reader) {
        Stack stack = freeParsers;
        synchronized (stack) {
            if (freeParsers.size() > 0) {
                PnutsParser parser = (PnutsParser)freeParsers.pop();
                parser.ReInit(reader);
                return parser;
            }
            return new PnutsParser(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recycleParser(PnutsParser parser) {
        Stack stack = freeParsers;
        synchronized (stack) {
            if (freeParsers.size() < 3) {
                freeParsers.push(parser);
            }
        }
    }

    public static final boolean isJava2() {
        if (java2 == 0) {
            try {
                if (Runtime.getProperty("pnuts.jdk11.compatible") != null) {
                    java2 = -1;
                } else {
                    Class.forName("java.lang.Package");
                    java2 = 1;
                }
            }
            catch (Throwable t) {
                java2 = -1;
            }
        }
        return java2 == 1;
    }

    public static void setDefaults(Properties properties) {
        defaultSettings = properties;
    }

    public static Properties getDefaults() {
        return defaultSettings;
    }

    public static final Class loadClass(String name, Context context) throws ClassNotFoundException {
        ClassLoader ccl;
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader != null) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e1) {
            }
            catch (LinkageError e2) {
                // empty catch block
            }
        }
        if (Pnuts.isJava2() && (ccl = Thread.currentThread().getContextClassLoader()) != null && ccl != classLoader) {
            try {
                return ccl.loadClass(name);
            }
            catch (ClassNotFoundException e1) {
            }
            catch (LinkageError e2) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    public static final URL getResource(String s, Context context) {
        URL url;
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(s)) != null) {
            return url;
        }
        if (Pnuts.isJava2()) {
            URL url2;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null && (url2 = ccl.getResource(s)) != null) {
                return url2;
            }
            return Pnuts.class.getResource(s);
        }
        return ClassLoader.getSystemResource(s);
    }

    public static void setPrompt(String str) {
        prompt = str;
    }

    public static void setVerbose(boolean b) {
        Context.defaultVerboseMode = b;
    }

    public static boolean isVerbose() {
        return Context.defaultVerboseMode;
    }

    public static String format(Object obj) {
        return Runtime.format(obj, 64);
    }

    public static Object get(String str) {
        return Pnuts.get(str, "");
    }

    public static Object get(String str, String pkg) {
        Package p = Package.find(pkg);
        if (p != null) {
            return p.get(str.intern());
        }
        return null;
    }

    public static void set(String str, Object val) {
        Pnuts.set(str, val, "");
    }

    public static void set(String str, Object val, String pkg) {
        Package p;
        if (str.length() > 0 && Character.isJavaIdentifierStart(str.charAt(0))) {
            p = Package.find(pkg);
            if (p == null) {
                throw new IllegalArgumentException(Runtime.getMessage("pnuts.lang.pnuts", "package.notFound", new Object[]{pkg}));
            }
        } else {
            throw new IllegalArgumentException(Runtime.getMessage("pnuts.lang.pnuts", "illegal.symbolForId", PnutsException.NO_PARAM));
        }
        p.set(str.intern(), val);
    }

    public static Object eval(String expr, Context context) {
        return context.pnutsImpl.eval(expr, context);
    }

    public static Object loadFile(String file, Context context) throws FileNotFoundException {
        return context.pnutsImpl.loadFile(file, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object load(String name, Context context) throws FileNotFoundException {
        String file = name;
        if (!name.endsWith(".pnut")) {
            file = name + ".pnut";
            Executable rt = Runtime.getCompiledScript(name, context);
            if (rt != null) {
                if (context.verbose) {
                    System.out.println("[loading " + Pnuts.format(rt.getClass()) + "]");
                }
                int depth = Pnuts.enter(context);
                context.pushFile(rt);
                boolean completed = false;
                Context old = Runtime.getThreadContext();
                try {
                    context.provide(name);
                    Runtime.setThreadContext(context);
                    Object ret = rt.run(context);
                    completed = true;
                    Object object = ret;
                    return object;
                }
                catch (Jump jump) {
                    completed = true;
                    Object object = jump.getValue();
                    return object;
                }
                finally {
                    if (!completed) {
                        context.revoke(name);
                    }
                    context.popFile();
                    context.depth = depth;
                    Runtime.setThreadContext(old);
                }
            }
        }
        return context.pnutsImpl.load(file, context);
    }

    public static Object load(URL url, Context context) {
        return context.pnutsImpl.load(url, context);
    }

    public static Object load(InputStream in, Context context) {
        return Pnuts.load(Runtime.getScriptReader(in, context), context);
    }

    public static Object load(InputStream in, boolean interactive, Context context) {
        return Pnuts.load(Runtime.getScriptReader(in, context), interactive, context);
    }

    /*
     * Exception decompiling
     */
    public static Object load(Reader reader, Context context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CASE], 8[SWITCH]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static int enter(Context context) {
        int depth;
        if ((depth = context.depth++) < Integer.MAX_VALUE) {
            // empty if block
        }
        return depth;
    }

    public static int evalDepth(Context context) {
        return context.depth;
    }

    public static Object load(Reader reader, boolean interactive, Context context) {
        if (interactive) {
            return Pnuts.session(reader, context);
        }
        return Pnuts.load(reader, context);
    }

    public static Pnuts parse(InputStream in) throws ParseException {
        return Pnuts.parse(new InputStreamReader(in));
    }

    public static Pnuts parse(Reader reader) throws ParseException {
        return Pnuts.parse(reader, DefaultParseEnv.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pnuts parse(Reader reader, ParseEnvironment env) throws ParseException {
        PnutsParser parser = Pnuts.getParser(reader);
        Pnuts p = new Pnuts();
        try {
            p.startNodes = parser.StartSet(env);
        }
        catch (ParseException e) {
            env.handleParseException(e);
        }
        finally {
            Pnuts.recycleParser(parser);
        }
        return p;
    }

    public static Pnuts parse(Reader reader, Object scriptSource, Context context) {
        return Pnuts.parse(reader, scriptSource, context, DefaultParseEnv.getInstance(scriptSource));
    }

    public static Pnuts parse(Reader reader, Object scriptSource, Context context, ParseEnvironment env) {
        Function frame = context.frame;
        context.frame = null;
        PnutsParser parser = Pnuts.getParser(reader);
        try {
            Pnuts p = new Pnuts();
            p.startNodes = parser.StartSet(env);
            p.setScriptSource(scriptSource);
            Pnuts pnuts = p;
            return pnuts;
        }
        catch (ParseException e) {
            throw new PnutsException(e, context);
        }
        finally {
            context.frame = frame;
            Pnuts.recycleParser(parser);
        }
    }

    public static Pnuts parse(String expr) throws ParseException {
        Pnuts p = Pnuts.parse(new StringReader(expr));
        p.scriptSource = expr;
        return p;
    }

    public static void require(String file, Context context) throws FileNotFoundException {
        Pnuts.require(file, context, false);
    }

    public static void require(String file, Context context, boolean checkForUpdate) throws FileNotFoundException {
        if (file.endsWith(".pnut")) {
            file = file.substring(0, file.length() - 5);
        }
        file = file.intern();
        context.require(file, checkForUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object session(Reader r, Context context) {
        BufferedReader br = new BufferedReader(r);
        StringBuffer sbuf = new StringBuffer();
        DefaultParseEnv parseEnv = DefaultParseEnv.getInstance();
        Object value = null;
        while (true) {
            PnutsParser parser = null;
            try {
                String line;
                PrintWriter term = null;
                Pnuts.flush(context);
                term = context.getTerminalWriter();
                if (term != null) {
                    term.print(prompt);
                    term.flush();
                }
                if ((line = br.readLine()) == null) {
                    return value;
                }
                sbuf.append(line);
                StringReader sr = new StringReader(sbuf.toString());
                parser = Pnuts.getParser(sr);
                try {
                    SimpleNode start = parser.Start(parseEnv);
                    sbuf.setLength(0);
                    try {
                        value = context.pnutsImpl.accept(start, context);
                    }
                    catch (Jump jump) {
                        value = jump.getValue();
                    }
                    finally {
                        context.onExit(value);
                    }
                    try {
                        term.println(context.getConfiguration().formatObject(value));
                        term.flush();
                        continue;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        Runtime.checkException(context, t);
                        continue;
                    }
                }
                catch (ParseException pe) {
                    Token t = pe.currentToken;
                    Token t2 = t.next;
                    while (t != null) {
                        t2 = t;
                        t = t.next;
                    }
                    if (t2.kind != 0) {
                        throw pe;
                    }
                    sbuf.append('\n');
                    continue;
                }
                finally {
                    Pnuts.recycleParser(parser);
                    continue;
                }
            }
            catch (ParseException p) {
                sbuf.setLength(0);
                if (context.depth > 1) {
                    Runtime.checkException(context, p);
                    continue;
                }
                int line = context.beginLine;
                try {
                    context.beginLine = p.currentToken.next.beginLine;
                    Runtime.checkException(context, p);
                }
                catch (Jump j) {
                    value = j.getValue();
                    PrintWriter term = context.getTerminalWriter();
                    if (term != null) {
                        term.println(value);
                        term.flush();
                    }
                }
                catch (PnutsException t) {
                    Runtime.printError(t, context);
                }
                finally {
                    context.beginLine = line;
                }
                Pnuts.reset(parser);
                Pnuts.recover(context);
                value = null;
                continue;
            }
            catch (Escape esc) {
                Pnuts.reset(parser);
                context.onExit(value);
                return esc.getValue();
            }
            catch (Throwable t) {
                if (context.depth > 1) {
                    if (t instanceof PnutsException) {
                        throw (PnutsException)t;
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    throw new PnutsException(t, context);
                }
                if (t instanceof ThreadDeath) {
                    return null;
                }
                Runtime.printError(t, context);
                if (parser != null) {
                    Pnuts.reset(parser);
                    Pnuts.recover(context);
                    value = null;
                    continue;
                }
                return null;
            }
            break;
        }
    }

    private static void reset(PnutsParser parser) {
        parser.jjtree.reset();
    }

    private static void recover(Context context) {
        context.resetStackFrame();
        context.loadingResource = null;
    }

    private static void flush(Context context) {
        PrintWriter out = context.getWriter();
        if (out != null) {
            out.flush();
        }
    }

    public static ClassLoader createClassLoader(Context context) {
        return Pnuts.createClassLoader(context, Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader createClassLoader(Context context, ClassLoader parent) {
        return new PnutsClassLoader(parent, context);
    }

    protected Pnuts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(Context context) {
        int depth = Pnuts.enter(context);
        context.pushFile(this.scriptSource);
        Function frame = context.frame;
        context.frame = null;
        try {
            Object object = this.accept(context);
            return object;
        }
        finally {
            context.depth = depth;
            context.frame = frame;
            context.popFile();
        }
    }

    public void setScriptSource(Object src) {
        this.scriptSource = src;
    }

    public Object getScriptSource() {
        return this.scriptSource;
    }

    public Object accept(Visitor visitor, Context context) {
        int depth = Pnuts.enter(context);
        Object value = null;
        Context old = Runtime.getThreadContext();
        Runtime.setThreadContext(context);
        try {
            value = this.startNodes.accept(visitor, context);
            context.onExit(value);
            Object object = value;
            return object;
        }
        catch (Escape esc) {
            context.onExit(value);
            Object val = esc.getValue();
            Pnuts.flush(context);
            Object object = val;
            return object;
        }
        catch (PnutsException pe) {
            context.onError(pe);
            throw pe;
        }
        catch (Throwable t) {
            PnutsException e = new PnutsException(t, context);
            context.onError(t);
            throw e;
        }
        finally {
            context.depth = depth;
            Runtime.setThreadContext(old);
        }
    }

    public String unparse() {
        return Runtime.unparse(this.startNodes, null);
    }

    public void unparse(Writer writer) throws IOException {
        writer.write(this.unparse());
    }

    protected Object accept(Context context) {
        Object value = null;
        try {
            value = context.pnutsImpl.accept(this.startNodes, context);
            context.onExit(value);
            return value;
        }
        catch (Escape esc) {
            context.onExit(value);
            Object val = esc.getValue();
            Pnuts.flush(context);
            context.onExit(val);
            return val;
        }
        catch (PnutsException pe) {
            context.onError(pe);
            throw pe;
        }
        catch (Throwable t) {
            PnutsException e = new PnutsException(t, context);
            context.onError(t);
            throw e;
        }
    }

    static {
        freeParsers = new Stack();
        java2 = 0;
    }
}

