/*
 * Decompiled with CFR 0.152.
 */
package pnuts.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import pnuts.ext.ImplementationAdapter;
import pnuts.lang.Context;
import pnuts.lang.Implementation;
import pnuts.lang.PnutsImpl;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;

public class SecurePnutsImpl
extends ImplementationAdapter {
    private CodeSource codeSource;

    public SecurePnutsImpl(PnutsImpl impl) {
        this(impl, null);
    }

    public SecurePnutsImpl(Implementation impl) {
        this(impl, null);
    }

    public SecurePnutsImpl(PnutsImpl impl, CodeSource codeSource) {
        super(impl);
        this.codeSource = codeSource;
    }

    public SecurePnutsImpl(Implementation impl, CodeSource codeSource) {
        super(impl);
        this.codeSource = codeSource;
    }

    public Object eval(final String expr, final Context context) {
        CodeSource cs = this.codeSource;
        if (cs == null) {
            cs = new CodeSource(null, (Certificate[])null);
        }
        AccessControlContext acc = this.getAccessControlContext(cs);
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurePnutsImpl.super.eval(expr, context);
            }
        }, acc);
    }

    public Object accept(final SimpleNode node, final Context context) {
        CodeSource cs = this.codeSource;
        if (cs == null) {
            cs = new CodeSource(null, (Certificate[])null);
        }
        AccessControlContext acc = this.getAccessControlContext(cs);
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurePnutsImpl.super.accept(node, context);
            }
        }, acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(final String file, final Context context) throws FileNotFoundException {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Runtime.getScriptURL(file, context);
            }
        });
        if (url == null) {
            throw new FileNotFoundException(file);
        }
        boolean completed = false;
        try {
            this.provide(file, context);
            Object ret = this.load(url, context);
            completed = true;
            Object object = ret;
            return object;
        }
        finally {
            if (!completed) {
                this.revoke(file, context);
            }
        }
    }

    public Object loadFile(String filename, Context context) throws FileNotFoundException {
        URL scriptURL = null;
        try {
            File f = new File(filename);
            if (!f.exists()) {
                throw new FileNotFoundException(filename);
            }
            scriptURL = Runtime.fileToURL(f);
        }
        catch (IOException e1) {
            throw new FileNotFoundException(filename);
        }
        return this.load(scriptURL, context);
    }

    public Object load(final URL scriptURL, final Context context) {
        CodeSource cs = this.codeSource;
        if (cs == null) {
            cs = SecurePnutsImpl.getCodeSource(scriptURL);
        }
        AccessControlContext acc = this.getAccessControlContext(cs);
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurePnutsImpl.super.load(scriptURL, context);
            }
        }, acc);
    }

    private static CodeSource getCodeSource(URL scriptURL) {
        final URL url = scriptURL;
        return (CodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    URLConnection con = url.openConnection();
                    if (con instanceof JarURLConnection) {
                        JarURLConnection jcon = (JarURLConnection)con;
                        return new CodeSource(jcon.getJarFileURL(), jcon.getCertificates());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new CodeSource(url, (Certificate[])null);
            }
        });
    }

    protected PermissionCollection getPolicyPermissions(final CodeSource codesource) {
        PermissionCollection perms = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Policy policy = Policy.getPolicy();
                if (policy != null) {
                    return policy.getPermissions(codesource);
                }
                return null;
            }
        });
        if (perms == null) {
            perms = new Permissions();
        }
        return perms;
    }

    protected void addSandBoxPermissions(URL codebase, PermissionCollection perms) {
        Permission p = null;
        try {
            if (codebase != null) {
                p = codebase.openConnection().getPermission();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (p instanceof FilePermission) {
            String path = p.getName();
            int endIndex = path.lastIndexOf(File.separatorChar);
            perms.add(p);
            if (endIndex != -1) {
                if ((path = path.substring(0, endIndex + 1)).endsWith(File.separator)) {
                    path = path + "-";
                }
                perms.add(new FilePermission(path, "read"));
            }
        } else if (codebase != null) {
            String host = codebase.getHost();
            if (host == null) {
                host = "localhost";
            }
            perms.add(new SocketPermission(host, "connect, accept"));
            if (p != null) {
                perms.add(p);
            }
        }
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection perms = this.getPolicyPermissions(codesource);
        this.addSandBoxPermissions(codesource.getLocation(), perms);
        return perms;
    }

    private AccessControlContext getAccessControlContext(CodeSource codesource) {
        PermissionCollection perms = this.getPermissions(codesource);
        ProtectionDomain domain = new ProtectionDomain(codesource, perms);
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    CodeSource getCodeSource() {
        return this.codeSource;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getBaseImpl() + ", " + this.codeSource + "]";
    }
}

