/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pnuts.ext.NonPublicMemberAccessor;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.tools.ContextEvent;
import pnuts.tools.ContextListener;
import pnuts.tools.VisualDebuggerView;

class ContextView {
    private static final Font monospaced = Font.getFont("monospaced");
    private static final Configuration debugConfig = new NonPublicMemberAccessor();
    private JTextField currentPackage;
    private JTextField classLoader;
    private JList imports;
    private JList modules;
    private JTable locals;
    private JTable contextLocals;
    private JTextField inspect;
    private JTextArea result;
    private Context context;
    private GridBagLayout gb;
    private VisualDebuggerView debuggerView;
    HashSet listeners = new HashSet();

    public ContextView(VisualDebuggerView debuggerView) {
        this.debuggerView = debuggerView;
    }

    public JFrame getFrame() {
        JFrame jfr = new JFrame();
        this.setupGUI(jfr.getContentPane());
        jfr.setSize(jfr.getPreferredSize());
        return jfr;
    }

    public Container getContainer() {
        JPanel panel = new JPanel();
        this.setupGUI(panel);
        panel.setSize(panel.getPreferredSize());
        return panel;
    }

    static void add(GridBagLayout gb, Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, int anchor, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.weightx = weightx;
        c.weighty = weighty;
        c.anchor = anchor;
        c.fill = fill;
        c.insets = new Insets(2, 2, 2, 2);
        gb.setConstraints(component, c);
        container.add(component);
    }

    void addLabel(Container container, Component component, int gridx, int gridy) {
        ContextView.add(this.gb, container, component, gridx, gridy, 1, 1, 0, 0, 12, 0);
    }

    void add_h(Container container, Component component, int gridx, int gridy) {
        ContextView.add(this.gb, container, component, gridx, gridy, 1, 1, 1, 0, 10, 2);
    }

    void add_b(Container container, Component component, int gridx, int gridy) {
        ContextView.add(this.gb, container, component, gridx, gridy, 1, 1, 1, 1, 10, 1);
    }

    void add_n(Container container, Component component, int gridx, int gridy) {
        ContextView.add(this.gb, container, component, gridx, gridy, 1, 1, 0, 0, 10, 0);
    }

    JLabel createJLabel(String key) {
        return new JLabel(this.debuggerView.getResourceString(key + ".label"));
    }

    public void setupGUI(Container contentPane) {
        this.gb = new GridBagLayout();
        Font monospaced = Font.getFont("monospaced");
        contentPane.setLayout(this.gb);
        String beansDef = this.debuggerView.getResourceString("inspector.beans");
        StringTokenizer st = new StringTokenizer(beansDef, ",");
        int idx = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String clsName = this.debuggerView.getResourceString("inspector.bean." + token + ".class");
            if (clsName == null) continue;
            try {
                Class<?> cls = Class.forName(clsName);
                Component bean = (Component)cls.newInstance();
                if (bean instanceof ContextListener) {
                    this.addContextlistener((ContextListener)((Object)bean));
                }
                this.addLabel(contentPane, this.createJLabel(token), 0, idx);
                String layoutHint = this.debuggerView.getResourceString("inspector.bean." + token + ".layout");
                if (layoutHint != null && layoutHint.toLowerCase().equals("both")) {
                    this.add_b(contentPane, bean, 1, idx);
                } else if (layoutHint != null && layoutHint.toLowerCase().equals("none")) {
                    this.add_n(contentPane, bean, 1, idx);
                } else {
                    this.add_h(contentPane, bean, 1, idx);
                }
                ++idx;
            }
            catch (ClassNotFoundException cnf) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InstantiationException ie) {}
        }
    }

    public void addContextlistener(ContextListener listener) {
        this.listeners.add(listener);
    }

    public void setContext(Context context) {
        this.context = context;
        Set listeners = (Set)this.listeners.clone();
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ContextListener listener = (ContextListener)it.next();
            listener.update(new ContextEvent(context));
        }
    }
}

