/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.Font;
import java.io.IOException;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import pnuts.tools.Console;
import pnuts.tools.ConsoleUI;

public class JTextComponentConsoleUI
implements ConsoleUI {
    private static final int defaultColumns = 80;
    private static final int defaultRows = 24;
    JTextComponent textComponent;
    Console model;
    int mark;

    protected JTextComponentConsoleUI() {
        this.setJTextComponent(this.createTextComponent());
    }

    public void setModel(Console console2) {
        this.model = console2;
    }

    public Console getModel() {
        return this.model;
    }

    public JTextComponent getJTextComponent() {
        return this.textComponent;
    }

    public void setJTextComponent(JTextComponent c) {
        this.textComponent = c;
    }

    protected JTextComponent createTextComponent() {
        JTextArea textarea = new JTextArea();
        textarea.setLineWrap(true);
        textarea.setFont(new Font("Monospaced", 0, 12));
        textarea.setRows(24);
        textarea.setColumns(80);
        return textarea;
    }

    static void runCommand(Runnable command) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(command);
        } else {
            command.run();
        }
    }

    public void append(final String str) {
        JTextComponentConsoleUI.runCommand(new Runnable(){

            public void run() {
                JTextComponentConsoleUI.this.insert(str, JTextComponentConsoleUI.this.mark);
                JTextComponentConsoleUI.this.mark += str.length();
                int pos = JTextComponentConsoleUI.this.getLength();
                JTextComponentConsoleUI.this.setCursorPosition(pos);
            }
        });
    }

    public void insert(String str, int mark) {
        Document doc = this.textComponent.getDocument();
        if (doc != null) {
            try {
                doc.insertString(mark, str, null);
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public int getLength() {
        return this.textComponent.getDocument().getLength();
    }

    public void setCursorPosition(int pos) {
        this.textComponent.select(pos, pos);
    }

    public int getMarkPosition() {
        return this.mark;
    }

    public void setMarkPosition(int pos) {
        this.mark = pos;
    }

    synchronized void enter() {
        try {
            int len = this.getLength();
            this.sendText(this.mark, len - this.mark);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void entered(String command) {
    }

    void sendText(int start, int len) throws IOException {
        Document doc = this.textComponent.getDocument();
        int doclen = doc.getLength();
        Segment segment = new Segment();
        try {
            doc.getText(this.mark, doclen - this.mark, segment);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.entered(segment.toString());
        char[] cbuf = segment.array;
        int offset = segment.offset;
        int count = segment.count;
        this.model.enter(cbuf, offset, count);
        this.insert("\n", this.getLength());
        this.mark = doc.getLength();
    }

    public void close() {
    }
}

