/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.BorderLayout;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import pnuts.compiler.CompilerPnutsImpl;
import pnuts.lang.Context;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsImpl;
import pnuts.lang.Runtime;
import pnuts.tools.Console;
import pnuts.tools.PnutsConsoleUI;

public class PnutsConsoleApplet
extends JApplet {
    private static final String PNUTS_APPLET = "pnuts.applet".intern();
    static final String[] runtimePermissions = new String[]{"createClassLoader", "getProtectionDomain"};
    private Context context;
    private Console console;

    public void init() {
        boolean canCreateClassLoader = false;
        try {
            for (int i = 0; i < runtimePermissions.length; ++i) {
                RuntimePermission perm = new RuntimePermission(runtimePermissions[i], null);
                AccessController.checkPermission(perm);
            }
            canCreateClassLoader = true;
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Package pkg = new Package("", null);
        this.context = new Context(pkg);
        if (canCreateClassLoader) {
            this.context.setImplementation(new CompilerPnutsImpl());
        } else {
            this.context.setImplementation(new PnutsImpl());
        }
        this.context.set(PNUTS_APPLET, this);
        PnutsConsoleApplet.initializeModuleProperty(Runtime.getProperty("pnuts.tools.modules"), this.context);
        PnutsConsoleApplet.initializeModuleProperty(this.getParameter("modules"), this.context);
        this.getContentPane().setLayout(new BorderLayout());
        this.console = new Console();
        PnutsConsoleUI ui = new PnutsConsoleUI(this.console);
        JTextComponent component = ui.getJTextComponent();
        JScrollPane sp = new JScrollPane(component);
        this.console.setConsoleUI(ui);
        this.getContentPane().add("Center", sp);
        sp.setBorder(new EmptyBorder(0, 0, 0, 0));
        Writer w = this.console.getWriter();
        this.context.setWriter(w);
        this.context.setTerminalWriter(w);
        this.context.setErrorWriter(w);
    }

    public void start() {
        Thread th = new Thread(){

            public void run() {
                Pnuts.load(PnutsConsoleApplet.this.console.getReader(), true, PnutsConsoleApplet.this.context);
                PrintWriter tw = PnutsConsoleApplet.this.context.getTerminalWriter();
                tw.println("Terminated.");
                tw.flush();
            }
        };
        th.setDaemon(true);
        th.start();
    }

    static void initializeModuleProperty(String property, Context context) {
        if (property != null) {
            StringTokenizer stoken = new StringTokenizer(property, ",");
            while (stoken.hasMoreTokens()) {
                context.usePackage(stoken.nextToken());
            }
        }
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

