/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import pnuts.lang.Context;
import pnuts.lang.Function;

public class StackFrameInspector {
    static Field stackFrameField;
    static Field symbolTableField;
    static Field parentField;
    static Field nameField;
    static Field valueField;
    static Field parentFrame;
    static Method bindingsMethod;
    static Field frameField;
    static Field lexicalScopeField;

    public static Map localSymbols(Context context) {
        try {
            HashMap map = new HashMap();
            StackFrameInspector.localSymbols(context, map);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void localSymbols(Context context, Map map) throws IllegalAccessException, InvocationTargetException {
        Object lexicalScope;
        Object frame;
        Object stackFrame = stackFrameField.get(context);
        if (stackFrame != null) {
            StackFrameInspector.scanSymbolTable(symbolTableField.get(stackFrame), map, false);
        }
        if ((frame = frameField.get(context)) != null && (lexicalScope = lexicalScopeField.get(frame)) != null) {
            StackFrameInspector.scanSymbolTable(lexicalScope, map, true);
        }
    }

    static void scanSymbolTable(Object st, Map map, boolean lexicalScope) throws IllegalAccessException, InvocationTargetException {
        while (st != null) {
            Enumeration bindings = (Enumeration)bindingsMethod.invoke(st, new Object[0]);
            while (bindings.hasMoreElements()) {
                Object b = bindings.nextElement();
                String name = (String)nameField.get(b);
                int idx = name.indexOf(33);
                if (idx > 0) {
                    name = name.substring(0, idx);
                } else if (idx == 0) continue;
                Object value = valueField.get(b);
                if (lexicalScope) {
                    value = valueField.get(value);
                }
                if (map.keySet().contains(name)) continue;
                map.put(name, value);
            }
            st = parentField.get(st);
        }
    }

    static {
        try {
            Class<?> StackFrameClass = Class.forName("pnuts.lang.StackFrame");
            Class<?> SymbolTableClass = Class.forName("pnuts.lang.SymbolTable");
            Class<?> BindingClass = Class.forName("pnuts.lang.Binding");
            stackFrameField = Context.class.getDeclaredField("stackFrame");
            stackFrameField.setAccessible(true);
            frameField = Context.class.getDeclaredField("frame");
            frameField.setAccessible(true);
            lexicalScopeField = Function.class.getDeclaredField("lexicalScope");
            lexicalScopeField.setAccessible(true);
            symbolTableField = StackFrameClass.getDeclaredField("symbolTable");
            symbolTableField.setAccessible(true);
            parentField = SymbolTableClass.getDeclaredField("parent");
            parentField.setAccessible(true);
            nameField = BindingClass.getDeclaredField("name");
            nameField.setAccessible(true);
            valueField = BindingClass.getDeclaredField("value");
            valueField.setAccessible(true);
            bindingsMethod = SymbolTableClass.getMethod("bindings", new Class[0]);
            bindingsMethod.setAccessible(true);
            parentFrame = StackFrameClass.getDeclaredField("parent");
            parentFrame.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

