/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import tratz.featgen.fer.FeatureExtractionRule;
import tratz.featgen.wfr.WordFindingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WfrEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WordFindingRule mRule;
    private String mName;
    private String mPrefix;
    private List<FeatureExtractionRule> mFERs;

    public String getName() {
        return this.mName;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public List<FeatureExtractionRule> getFERs() {
        return this.mFERs;
    }

    public WfrEntry(String name, String prefix, List<FeatureExtractionRule> fers, String className, Map<String, String> params) throws Exception {
        this.mName = name;
        this.mPrefix = prefix;
        this.mFERs = fers;
        this.mRule = (WordFindingRule)Class.forName(className).newInstance();
        this.mRule.init(params);
    }

    public WfrEntry(String name, String prefix, List<FeatureExtractionRule> fers, WordFindingRule wfr) {
        this.mName = name;
        this.mPrefix = prefix;
        this.mFERs = fers;
        this.mRule = wfr;
    }

    public WordFindingRule getWfrRule() {
        return this.mRule;
    }
}

