/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tratz.featgen.InitException;
import tratz.featgen.fer.FERProductionException;
import tratz.featgen.fer.FeatureExtractionRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureRule
implements FeatureExtractionRule,
Serializable {
    public static final long serialVersionUID = 1L;
    private String mPrefix;

    @Override
    public void init(Map<String, String> params) throws InitException {
    }

    @Override
    public Set<String> getProductions(String base, String type) throws FERProductionException {
        return this.getProductions(base, type, new HashSet<String>());
    }

    protected void addSet(Set<String> features, Collection<String> newFeatures, String prefix, Map<String, String> canonFeats) {
        for (String s : newFeatures) {
            String newFeat = prefix + s;
            if (canonFeats.containsKey(newFeat)) {
                features.add(canonFeats.get(newFeat));
                continue;
            }
            canonFeats.put(newFeat, newFeat);
            features.add(newFeat);
        }
    }

    protected void addSet(Set<String> features, Collection<String> newFeatures, String prefix) {
        for (String s : newFeatures) {
            features.add(prefix + s);
        }
    }

    @Override
    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    @Override
    public String getPrefix() {
        return this.mPrefix;
    }
}

