/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Map;
import java.util.Set;
import tratz.featgen.InitException;
import tratz.featgen.fer.AbstractFeatureRule;
import tratz.jwni.IndexEntry;
import tratz.jwni.LexPointer;
import tratz.jwni.POS;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;
import tratz.util.TreebankConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWordNetFER
extends AbstractFeatureRule {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_DEFAULT_POS = "DefaultPos";
    public static final String PARAM_OVERRIDE_POS = "OverridePos";
    public static final String PARAM_MAX_SENSE_NUM = "MaxSenseNum";
    public static final String PARAM_DERIVED_POS = "DerivedInputPos";
    protected String mDefaultPos;
    protected String mOverridePos;
    protected int mMaxSenseNum = Integer.MAX_VALUE;
    protected POS mDerivedInputPos;

    @Override
    public void init(Map<String, String> params) throws InitException {
        String maxSenseString;
        this.mDefaultPos = params.get(PARAM_DEFAULT_POS);
        this.mOverridePos = params.get(PARAM_OVERRIDE_POS);
        String mDerivedPosString = params.get(PARAM_DERIVED_POS);
        if (mDerivedPosString != null) {
            this.mDerivedInputPos = this.getPosForType(mDerivedPosString);
            if (this.mDerivedInputPos == null) {
                throw new InitException("Invalid derived pos type: " + mDerivedPosString);
            }
        }
        if ((maxSenseString = params.get(PARAM_MAX_SENSE_NUM)) != null) {
            this.mMaxSenseNum = Integer.parseInt(maxSenseString);
        }
    }

    @Override
    public final Set<String> getProductions(String input, String type, Set<String> productions) {
        if (this.mOverridePos != null) {
            type = this.mOverridePos;
        } else if (type == null) {
            type = this.mDefaultPos;
        }
        if (this.mDerivedInputPos != null) {
            input = AbstractWordNetFER.getDerived(input, this.mDerivedInputPos, this.getPosForType(type));
        }
        return input == null ? productions : this.generateFeatures(input, type, productions);
    }

    public abstract Set<String> generateFeatures(String var1, String var2, Set<String> var3);

    protected POS getPosForType(String type) {
        POS pos = null;
        if (TreebankConstants.NOUN_LABELS.contains(type)) {
            pos = POS.NOUN;
        } else if (TreebankConstants.VERB_LABELS.contains(type)) {
            pos = POS.VERB;
        } else if (TreebankConstants.ADJ_LABELS.contains(type)) {
            pos = POS.ADJECTIVE;
        } else if (TreebankConstants.ADV_LABELS.contains(type)) {
            pos = POS.ADVERB;
        }
        return pos;
    }

    protected static String getDerived(String s, POS pos, POS target) {
        IndexEntry ie = WordNet.getInstance().lookupIndexEntry(pos, s);
        Sense.Key result = null;
        if (ie != null) {
            block0: for (Sense sense : ie.getSenses()) {
                LexPointer[][] lps = sense.getLexPointers(PointerType.DERIVED_FORM);
                int index = sense.getKeyIndex(s);
                if (index <= -1) continue;
                for (int i = 0; i < lps[index].length; ++i) {
                    Sense tSense;
                    if (lps[index][i].getTargetSense().getPOS() == target && (result = (tSense = lps[index][i].getTargetSense()).getKeys()[lps[index][i].getTargetWordIndex()]) != null) break block0;
                }
            }
        }
        String lemma = result == null ? null : result.getLemma();
        return lemma;
    }
}

