/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tratz.featgen.fer.AbstractFeatureRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffixFER
extends AbstractFeatureRule {
    private static final long serialVersionUID = 1L;
    private static final String DEVERBAL_AGENT_SUFFIX = "[a-zA-Z]*(ant|ee|er|ar|or)s?";
    private static final String DENOMINAL_AGENT_SUFFIX = "[a-zA-Z]*(ian|ist|ster|yst)s?";
    private static final String DENOMINAL_SUFFIX = "[a-zA-Z]*(age|dom|hood|ism|ship|ry|ocracy|ese|ite)s?";
    private static final String DEADJECTIVAL_SUFFIX = "[a-zA-Z]*(ce|cy|ty|ness)";
    private static final String DEVERBAL_SUFFIX = "[a-zA-Z]*(al|ce|ion|ment|ure|ing)s?";
    private static final String TIMEORDER_PREFIX = "(pre|post|fore|ex|re|mid)[a-zA-Z]+";
    private static final String DEGREE_PREFIX = "(arch|super|out|sur|sub|over|under|hyper|ultra|mini)[a-zA-Z]+";
    private static final String LOC_PREFIX = "(super|sub|inter|trans|intra|endo|exo|ecto|ent|ante|circum|cata|peri|para|fore|mid|opistho|supra)[a-zA-Z]+";
    private static final String NUM_PREFIX = "(ennea|uni|mono|bi|di|tri|multi|poly|quad|penta|hexa|hepta|octo|octa|novem|noven|dec|dodec|milli|peta|centi|tetra|singul)[a-zA-Z]+";
    private static final String FRONT_BACK_SIDE = "(back|front|side).*|.*(back|front|side)";
    private static final String NEGATIVE_PREFIX = "(un|non|in|im|dis|dys|ab|a|anti|contr|counter).+";
    private static final String COLOR_PREFIX = "(cupro|chlor|chrys|erythro|leuk|flav|lute|melan|polio|xanth|cyan|purp|cirrho|aureo|fulvi|viridi|prasini|glauc|amaur|cinere)[a-zA-Z]+";
    private static final String CAUSE_TO_BECOME_SUFFIX = "[a-zA-Z]+(en|ize|ise|ate|fy)";
    private static final String PARTICIPLE_SUFFIX = "[a-zA-Z]+(en|ed|ing)";
    private static final String VOWEL_SUFFIX = "[a-zA-Z]+[aeiouy]";
    private static final String STARTS_WITH_A = "[aA][a-zA-Z]+";
    private static final String BODY_PREFIX = "(thyro|pyel|pylor|sangui|syndesmo|syring|laryng|phleb|pulmo|rhin|reni|reno|ptero|phyll|oro|oto|enter|dent|adren|arteri|blephar|cephal|brachi|bronch|cervic|arth|cardi|caud|chondr|cost|crani|cuti|cyst|dactyl|derm|encephal|gastr|gnath|hepat|kerat|myo|nephr|neuro|ocul|odont|ophthalm|oste|ped|pell|pleur|pneum|pod|soma|stome|thorac|trache)[a-zA-Z]+";
    private static final String DISEASE_SUFFIX = "[a-zA-Z].*(centesis|cele|itis|lepsy|oma|phobia|lagnia|phonia|plegia|asis|derma|lalia|malacia|megaly|melia|metropia|odynia|onychia|opsia|opia|osmia|pathy|penia|phasia|phrenia|thymia)";
    private static final String HAVING_SUFFIX = "[a-zA-Z]+(ous|ful|y|ive|ant|ent|ose)";
    private static final String ABLE_SUFFIX = "[a-zA-Z]+(ble)";
    private static final String RELATEDTO_SUFFIX = "[a-zA-Z]+(al|il|ic)";
    private static final String EN_SUFFIX = "[a-zA-Z]+(en)";
    private static final String ESCENT_SUFFIX = "[a-zA-Z]+(escent)";
    private static final String OID_SUFFIX = "[a-zA-Z]+(oid)";
    private static final String SUPERLATIVE_SUFFIX = "[A-Za-z]+(est|most)";
    private static final String ABSENCE_SUFFIX = "[A-Za-z]+less";
    private static final String LIKE_SUFFIX = "[A-Za-z]+(ical|ish|ory)";
    private transient Matcher mDeverbalAgent;
    private transient Matcher mDenominalAgent;
    private transient Matcher mDenominalSuffix;
    private transient Matcher mDeadjectivalSuffix;
    private transient Matcher mDeverbalSuffix;
    private transient Matcher mTimeOrderPrefix;
    private transient Matcher mDegPrefix;
    private transient Matcher mLocPrefix;
    private transient Matcher mNumPrefix;
    private transient Matcher mFrontBackSide;
    private transient Matcher mNegativePrefix;
    private transient Matcher mColorPrefix;
    private transient Matcher mCauseToBecomeSuffix;
    private transient Matcher mParticipleSuffix;
    private transient Matcher mVowelSuffix;
    private transient Matcher mStartsWithA;
    private transient Matcher mBodySuffix;
    private transient Matcher mDiseaseSuffix;
    private transient Matcher mHavingSuffix;
    private transient Matcher mAbleSuffix;
    private transient Matcher mRelatedToSuffix;
    private transient Matcher mEnSuffix;
    private transient Matcher mEscentSuffix;
    private transient Matcher mOidSuffix;
    private transient Matcher mSuperlativeSuffix;
    private transient Matcher mAbsenceSuffix;
    private transient Matcher mLikeSuffix;

    private final boolean matches(Matcher matcher, String s) {
        return matcher.reset(s).matches();
    }

    private void reinit() {
        if (this.mDeverbalAgent == null) {
            this.mDeverbalAgent = Pattern.compile(DEVERBAL_AGENT_SUFFIX, 2).matcher("");
            this.mDenominalAgent = Pattern.compile(DENOMINAL_AGENT_SUFFIX, 2).matcher("");
            this.mDenominalSuffix = Pattern.compile(DENOMINAL_SUFFIX, 2).matcher("");
            this.mDeadjectivalSuffix = Pattern.compile(DEADJECTIVAL_SUFFIX, 2).matcher("");
            this.mDeverbalSuffix = Pattern.compile(DEVERBAL_SUFFIX, 2).matcher("");
            this.mTimeOrderPrefix = Pattern.compile(TIMEORDER_PREFIX, 2).matcher("");
            this.mDegPrefix = Pattern.compile(DEGREE_PREFIX, 2).matcher("");
            this.mLocPrefix = Pattern.compile(LOC_PREFIX, 2).matcher("");
            this.mNumPrefix = Pattern.compile(NUM_PREFIX, 2).matcher("");
            this.mFrontBackSide = Pattern.compile(FRONT_BACK_SIDE, 2).matcher("");
            this.mNegativePrefix = Pattern.compile(NEGATIVE_PREFIX, 2).matcher("");
            this.mColorPrefix = Pattern.compile(COLOR_PREFIX, 2).matcher("");
            this.mCauseToBecomeSuffix = Pattern.compile(CAUSE_TO_BECOME_SUFFIX, 2).matcher("");
            this.mParticipleSuffix = Pattern.compile(PARTICIPLE_SUFFIX, 2).matcher("");
            this.mVowelSuffix = Pattern.compile(VOWEL_SUFFIX, 2).matcher("");
            this.mStartsWithA = Pattern.compile(STARTS_WITH_A, 2).matcher("");
            this.mBodySuffix = Pattern.compile(BODY_PREFIX, 2).matcher("");
            this.mDiseaseSuffix = Pattern.compile(DISEASE_SUFFIX, 2).matcher("");
            this.mHavingSuffix = Pattern.compile(HAVING_SUFFIX, 2).matcher("");
            this.mAbleSuffix = Pattern.compile(ABLE_SUFFIX, 2).matcher("");
            this.mRelatedToSuffix = Pattern.compile(RELATEDTO_SUFFIX, 2).matcher("");
            this.mEnSuffix = Pattern.compile(EN_SUFFIX, 2).matcher("");
            this.mEscentSuffix = Pattern.compile(ESCENT_SUFFIX, 2).matcher("");
            this.mOidSuffix = Pattern.compile(OID_SUFFIX, 2).matcher("");
            this.mSuperlativeSuffix = Pattern.compile(SUPERLATIVE_SUFFIX, 2).matcher("");
            this.mAbsenceSuffix = Pattern.compile(ABSENCE_SUFFIX, 2).matcher("");
            this.mLikeSuffix = Pattern.compile(LIKE_SUFFIX, 2).matcher("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getProductions(String term, String type, Set<String> features) {
        AffixFER affixFER = this;
        synchronized (affixFER) {
            boolean startsWithA;
            boolean endsInVowel;
            boolean participleSuffixes;
            boolean causeToBecomeSuffix;
            this.reinit();
            boolean deverbalAgentSuffix = this.matches(this.mDeverbalAgent, term);
            boolean denomAgentSuffix = this.matches(this.mDenominalAgent, term);
            boolean denomSuffix = this.matches(this.mDenominalSuffix, term);
            boolean deadjSuffix = this.matches(this.mDeadjectivalSuffix, term);
            boolean deverbSuffix = this.matches(this.mDeverbalSuffix, term);
            boolean timeOrOrderPrefix = this.matches(this.mTimeOrderPrefix, term);
            boolean degreePrefix = this.matches(this.mDegPrefix, term);
            boolean locativePrefix = this.matches(this.mLocPrefix, term);
            boolean numberPrefix = this.matches(this.mNumPrefix, term);
            boolean frontBackSideAffix = this.matches(this.mFrontBackSide, term);
            boolean negativePrefix = this.matches(this.mNegativePrefix, term);
            boolean colorPrefix = this.matches(this.mColorPrefix, term);
            if (negativePrefix) {
                features.add("neg:" + negativePrefix);
            }
            if (timeOrOrderPrefix) {
                features.add("to:");
            }
            if (degreePrefix) {
                features.add("deg:");
            }
            if (locativePrefix) {
                features.add("loc:");
            }
            if (numberPrefix) {
                features.add("num:");
            }
            if (deverbalAgentSuffix) {
                features.add("deva:");
            }
            if (denomAgentSuffix) {
                features.add("denoa:");
            }
            if (denomAgentSuffix | deverbalAgentSuffix) {
                features.add("age:");
            }
            if (denomSuffix) {
                features.add("deno:");
            }
            if (deadjSuffix) {
                features.add("dead:");
            }
            if (deverbSuffix) {
                features.add("dev:");
            }
            if (frontBackSideAffix) {
                features.add("fsb:");
            }
            if (causeToBecomeSuffix = this.matches(this.mCauseToBecomeSuffix, term)) {
                features.add("ctb:");
            }
            if (participleSuffixes = this.matches(this.mParticipleSuffix, term)) {
                features.add("ps:");
            }
            if (endsInVowel = this.matches(this.mVowelSuffix, term)) {
                features.add("ev:");
            }
            if (startsWithA = this.matches(this.mStartsWithA, term)) {
                features.add("sa:");
            }
            this.doMedicalAffixes(term, features);
            this.doAdjectiveAffixes(term, features);
        }
        return features;
    }

    private void doMedicalAffixes(String term, Set<String> features) {
        boolean bodyPrefix = this.matches(this.mBodySuffix, term);
        if (bodyPrefix) {
            features.add("bod:" + bodyPrefix);
        }
        if (this.matches(this.mDiseaseSuffix, term)) {
            features.add("dis");
        }
    }

    private void doAdjectiveAffixes(String term, Set<String> features) {
        boolean having = this.matches(this.mHavingSuffix, term);
        boolean able = this.matches(this.mAbleSuffix, term);
        boolean relatedTo = this.matches(this.mRelatedToSuffix, term);
        boolean en = this.matches(this.mEnSuffix, term);
        boolean escent = this.matches(this.mEscentSuffix, term);
        boolean oid = this.matches(this.mOidSuffix, term);
        boolean superlative = this.matches(this.mSuperlativeSuffix, term);
        boolean absence = this.matches(this.mAbsenceSuffix, term);
        boolean like = this.matches(this.mLikeSuffix, term);
        if (like) {
            features.add("lik:");
        }
        if (superlative) {
            features.add("sup:");
        }
        if (having) {
            features.add("hv:");
        }
        if (able) {
            features.add("ble:");
        }
        if (relatedTo) {
            features.add("rel:");
        }
        if (en) {
            features.add("en:");
        }
        if (escent) {
            features.add("esc:");
        }
        if (oid) {
            features.add("oid:");
        }
        if (absence) {
            features.add("abs:");
        }
    }
}

