/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.LexPointer;
import tratz.jwni.POS;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FramesFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String term, String type, Set<String> productions) {
        IndexEntry ie;
        POS pos = this.getPosForType(type);
        if (pos != null && (ie = WordNet.getInstance().lookupIndexEntry(pos, term)) != null) {
            Sense[] senses = ie.getSenses();
            for (int s = 0; s < senses.length && s < this.mMaxSenseNum; ++s) {
                if (pos == POS.NOUN) {
                    LexPointer[][] lps = senses[s].getLexPointers(PointerType.DERIVED_FORM);
                    int index = senses[s].getKeyIndex(term);
                    if (index <= -1) continue;
                    for (int i = 0; i < lps[index].length; ++i) {
                        Sense targetSense = lps[index][i].getTargetSense();
                        for (Sense.Key key : targetSense.getKeys()) {
                            int[] frames = key.getFrames();
                            if (frames == null) continue;
                            for (int j = 0; j < frames.length; ++j) {
                                productions.add(Integer.toString(frames[j]));
                            }
                        }
                    }
                    continue;
                }
                for (Sense.Key key : senses[s].getKeys()) {
                    int[] frames = key.getFrames();
                    if (frames == null) continue;
                    int numFrames = frames.length;
                    for (int j = 0; j < numFrames; ++j) {
                        productions.add(Integer.toString(frames[j]));
                    }
                }
            }
        }
        return productions;
    }
}

