/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Pointer;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoloMemberOfFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String input, String type, Set<String> productions) {
        IndexEntry entry;
        POS pos = this.getPosForType(type);
        if (pos != null && (entry = WordNet.getInstance().getMorpho().lookupIndexEntry(pos, input, true)) != null) {
            Sense[] senses = entry.getSenses();
            for (int i = 0; i < senses.length && i < this.mMaxSenseNum; ++i) {
                Sense sense = senses[i];
                this.addHypernymsMembers(productions, sense, 1);
            }
        }
        int size = productions.size();
        productions.clear();
        if (size > 0) {
            productions.add("hasmem");
        }
        return productions;
    }

    private void addHypernymsMembers(Set<String> productions, Sense sense, int level) {
        if (level < 15) {
            Pointer[] hyperPointers = sense.getPointers(PointerType.HYPERNYM);
            this.addParts(sense, productions);
            for (Pointer p : hyperPointers) {
                this.addHypernymsMembers(productions, p.getTargetSense(), level + 1);
            }
        }
    }

    private void addParts(Sense sense, Set<String> productions) {
        Pointer[] pointers;
        for (Pointer p : pointers = sense.getPointers(PointerType.MEMBER_HOLONYM)) {
            for (Sense.Key key : p.getTargetSense().getKeys()) {
                productions.add(key.getLemma());
            }
        }
    }
}

