/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LemmaFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String input, String type, Set<String> productions) {
        POS pos = this.getPosForType(type);
        if (pos != null) {
            IndexEntry entry = WordNet.getInstance().lookupIndexEntry(pos, input);
            if (entry != null) {
                productions.add(entry.getLemma());
            }
        } else {
            productions.add(input.toLowerCase());
        }
        return productions;
    }
}

