/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.io.Serializable;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tratz.featgen.fer.AbstractFeatureRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LikelyTimeFER
extends AbstractFeatureRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Matcher mYearMatcher;
    protected Matcher mTimePeriods;
    protected Matcher mTimeWithColon;

    @Override
    public Set<String> getProductions(String s, String type, Set<String> feats) {
        if (this.mYearMatcher == null) {
            this.mYearMatcher = Pattern.compile("(1[0-9]{3}|2[0-2][0-9]{2})s?").matcher("");
            this.mTimePeriods = Pattern.compile("EDT|EST|MST|MDT|PST|PDT|CST|CDT|GMT|p\\.m\\.|a\\.m\\.", 2).matcher("");
            this.mTimeWithColon = Pattern.compile("[012]?[0-9]:[0-9][0-9]").matcher("");
        }
        if (this.mYearMatcher.reset(s).matches()) {
            feats.add("liTime");
        }
        if (this.mTimePeriods.reset(s).matches()) {
            feats.add("liTime");
        }
        if (this.mTimeWithColon.reset(s).matches()) {
            feats.add("liTime");
        }
        return feats;
    }
}

