/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import tratz.featgen.fer.AbstractFeatureRule;
import tratz.jwikt.WEntry;
import tratz.jwikt.WPOS;
import tratz.jwikt.Wiktionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WiktionaryGlossTermsFER
extends AbstractFeatureRule {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_DEFAULT_POS = "DefaultPos";
    public static final String PARAM_WIKTIONARY_PATH = "WiktionaryFile";
    protected String mDefaultPos;

    @Override
    public void init(Map<String, String> params) {
        this.mDefaultPos = params.get(PARAM_DEFAULT_POS);
        String wiktionaryPath = params.get(PARAM_WIKTIONARY_PATH);
        Wiktionary wiktionary = Wiktionary.getGlobal();
        if (wiktionary == null) {
            try {
                wiktionary = Wiktionary.readWiktionary(wiktionaryPath);
                Wiktionary.setGlobal(wiktionary);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public Set<String> getProductions(String input, String type, Set<String> productions) {
        WEntry entry;
        if (type == null) {
            type = this.mDefaultPos;
        }
        Wiktionary wiktionary = Wiktionary.getGlobal();
        WPOS pos = WPOS.NOUN;
        if (type.startsWith("VB")) {
            pos = WPOS.VERB;
        } else if (type.startsWith("JJ")) {
            pos = WPOS.ADJECTIVE;
        }
        if (pos != null && (entry = wiktionary.getEntry(pos, input)) != null) {
            for (WEntry.Definition def : entry.getDefinitions()) {
                String[] glossTerms;
                for (String term : glossTerms = def.getGloss().split("\\s+")) {
                    productions.add(term);
                }
            }
        }
        return productions;
    }
}

