/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.wfr;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.featgen.wfr.AbstractWordFindingRule;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.WordNet;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetPossessor
extends AbstractWordFindingRule {
    private static final long serialVersionUID = 1L;

    @Override
    public void init(Map<String, String> params) {
    }

    @Override
    public Set<Token> getProductions(List<Token> tokenList, Parse parse, int tokIndex) {
        HashSet<Token> results = new HashSet<Token>();
        Token proposedPossessee = tokenList.get(tokIndex);
        List children = parse.getDependentArcLists()[proposedPossessee.getIndex()];
        if (children != null) {
            for (Arc childArc : children) {
                IndexEntry ie;
                if (!childArc.getDependency().equals("poss")) continue;
                Token modifier = childArc.getChild();
                String pl = modifier.getText();
                if (modifier.getText().toLowerCase().matches("(corp|co|plc|inc|ag|ltd|llc)\\.?")) {
                    pl = "corporation";
                } else if (modifier.getPos().startsWith("NNP") && (ie = WordNet.getInstance().lookupIndexEntry(POS.NOUN, pl)) == null) {
                    StringBuilder nounMods = new StringBuilder();
                    List arcs = parse.getDependentArcLists()[modifier.getIndex()];
                    if (arcs != null) {
                        for (Arc a : arcs) {
                            if (!a.getDependency().equals("nn")) continue;
                            nounMods.append(a.getChild().getText() + " ");
                        }
                        if (nounMods.length() > 0) {
                            String newLeftString = nounMods.toString() + pl;
                            ie = WordNet.getInstance().lookupIndexEntry(POS.NOUN, newLeftString);
                            if (ie != null) {
                                pl = ie.getLemma();
                            }
                        }
                    }
                }
                String pos = modifier.getPos();
                if (pl.toLowerCase().equals("her") || pl.toLowerCase().equals("his") || pl.toLowerCase().equals("my") || pl.toLowerCase().equals("your")) {
                    pl = "person";
                    pos = "NN";
                }
                results.add(new Token(pl, pos, modifier.getIndex()));
                break;
            }
        }
        return results;
    }
}

