/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.wfr;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.featgen.wfr.AbstractWordFindingRule;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSiblingsByType
extends AbstractWordFindingRule {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_DEP_TYPE = "DEP_TYPE";
    private Set<String> mDepType;

    @Override
    public void init(Map<String, String> params) {
        String deps = params.get(PARAM_DEP_TYPE);
        if (deps != null) {
            this.mDepType = new HashSet<String>();
            for (String dep : deps.split(",")) {
                this.mDepType.add(dep);
            }
        }
    }

    @Override
    public Set<Token> getProductions(List<Token> tokenList, Parse parse, int tokenIndex) {
        HashSet<Token> results = new HashSet<Token>();
        Token childOfArc = tokenList.get(tokenIndex);
        Arc toHead = parse.getHeadArcs()[childOfArc.getIndex()];
        if (toHead != null && toHead.getHead() != null) {
            List children = parse.getDependentArcLists()[toHead.getHead().getIndex()];
            for (Arc childArc : children) {
                if (this.mDepType != null && !this.mDepType.contains(childArc.getDependency())) continue;
                results.add(childArc.getChild());
            }
        }
        return results;
    }
}

