/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.wfr;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tratz.featgen.wfr.AbstractWordFindingRule;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;
import tratz.util.TreebankConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepositionComplementHeuristic
extends AbstractWordFindingRule {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<Token> getProductions(List<Token> tokenList, Parse parse, int headIndex) {
        HashSet<Token> results = new HashSet<Token>();
        int numTokens = tokenList.size();
        Token prevNoun = null;
        for (int i = headIndex + 1; i < numTokens; ++i) {
            Token tok = tokenList.get(i);
            String pos = tok.getPos();
            String text = tok.getText().toLowerCase();
            if (prevNoun != null) {
                if (pos.equals("POS")) {
                    prevNoun = null;
                    continue;
                }
                if (pos.startsWith("NN") || !prevNoun.getPos().startsWith("NN") && pos.matches("JJ(R|S)?|RB.*")) {
                    prevNoun = tok;
                    continue;
                }
                results.add(prevNoun);
                break;
            }
            if (pos.equals("VBG") || pos.equals("WRB") || pos.equals("PRP") || pos.equals("WP")) {
                results.add(tok);
                break;
            }
            if (!text.matches("this|these|those|that|all|some|few|each|another|most|more|less") && !TreebankConstants.NOUN_LABELS.contains(pos)) continue;
            prevNoun = tok;
        }
        return results;
    }
}

