/*
 * Decompiled with CFR 0.152.
 */
package tratz.jwni;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import tratz.jwni.LexPointer;
import tratz.jwni.POS;
import tratz.jwni.Pointer;
import tratz.jwni.PointerType;
import tratz.jwni.WordNet;

public class Sense {
    private int mOffset;
    private String mGloss;
    private String[] mGlossTerms;
    private byte mLexFileNum;
    private POS mPos;
    private Key[] mKeys;
    private LexPointer[][] mLexPointers;
    private Pointer[] mSemPointers;

    public Sense(int offset, String gloss, String[] glossTerms, byte lexfilenum, POS pos, Key[] keys, LexPointer[][] lexPointers, Pointer[] semPointers) {
        this.mOffset = offset;
        this.mGloss = gloss;
        this.mGlossTerms = glossTerms;
        this.mLexFileNum = lexfilenum;
        this.mPos = pos;
        this.mKeys = keys;
        for (Key key : keys) {
            key.mSense = this;
        }
        this.mLexPointers = lexPointers;
        this.mSemPointers = semPointers;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public String getGloss() {
        return this.mGloss;
    }

    public String[] getGlossTerms() {
        return this.mGlossTerms;
    }

    public byte getLexFileNum() {
        return this.mLexFileNum;
    }

    public POS getPOS() {
        return this.mPos;
    }

    public Key[] getKeys() {
        return this.mKeys;
    }

    public Pointer[][] getLexPointers() {
        return this.mLexPointers;
    }

    public int getKeyIndex(String keyString) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (keyString.compareToIgnoreCase(this.mKeys[i].getLemma()) != 0) continue;
            return i;
        }
        return -1;
    }

    public Pointer[] getPointers(PointerType ... pointerType) {
        HashSet<PointerType> ptrTypes = new HashSet<PointerType>(Arrays.asList(pointerType));
        ArrayList<Object> pointers = new ArrayList<Object>();
        LexPointer[][] arr$ = this.mLexPointers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LexPointer[] lexPointerArray;
            for (LexPointer lptr : lexPointerArray = arr$[i$]) {
                if (!ptrTypes.contains((Object)lptr.mPointerType)) continue;
                pointers.add(lptr);
            }
        }
        for (LexPointer[] lexPointerArray : this.mSemPointers) {
            if (!ptrTypes.contains((Object)lexPointerArray.mPointerType)) continue;
            pointers.add(lexPointerArray);
        }
        return pointers.toArray(new Pointer[pointers.size()]);
    }

    public LexPointer[][] getLexPointers(PointerType ... pointerTypes) {
        HashSet<PointerType> pTypes = new HashSet<PointerType>(Arrays.asList(pointerTypes));
        List[] pointers = new List[this.mLexPointers.length];
        for (int i = 0; i < this.mLexPointers.length; ++i) {
            pointers[i] = new ArrayList();
            for (int j = 0; j < this.mLexPointers[i].length; ++j) {
                if (!pTypes.contains((Object)this.mLexPointers[i][j].getPointerType())) continue;
                pointers[i].add(this.mLexPointers[i][j]);
            }
        }
        LexPointer[][] lPointers = new LexPointer[this.mLexPointers.length][];
        for (int i = 0; i < this.mLexPointers.length; ++i) {
            lPointers[i] = pointers[i].toArray(new LexPointer[pointers[i].size()]);
        }
        return lPointers;
    }

    public Pointer[] getSemPointers() {
        return this.mSemPointers;
    }

    public Pointer[] getSemPointers(PointerType ... pointerTypes) {
        ArrayList<Pointer> pointers = new ArrayList<Pointer>();
        for (Pointer p : this.mSemPointers) {
            for (PointerType pType : pointerTypes) {
                if (p.mPointerType != pType) continue;
                pointers.add(p);
            }
        }
        return pointers.toArray(new Pointer[pointers.size()]);
    }

    public String toString() {
        return Arrays.toString(this.getKeys()) + "\t" + (Object)((Object)this.getPOS()) + "\t" + this.getOffset() + "\t" + this.getLexFileNum() + "\t" + this.getGloss();
    }

    public static class Key {
        private String mLemma;
        private byte mLexId;
        private POS mPos;
        private Sense mSense;
        private int mTagCount;
        private String mSenseKey;
        private int[] mFrames = new int[0];
        private WordNet mWordNet;

        public Key(WordNet wordNet, String lemma, byte lexid, POS pos) {
            this.mWordNet = wordNet;
            this.mLemma = lemma;
            this.mLexId = lexid;
            this.mPos = pos;
        }

        public void addFrame(int frame) {
            int[] newFrameArray = new int[this.mFrames.length + 1];
            System.arraycopy(this.mFrames, 0, newFrameArray, 0, this.mFrames.length);
            newFrameArray[this.mFrames.length] = frame;
            this.mFrames = newFrameArray;
        }

        public int[] getFrames() {
            return this.mFrames;
        }

        public String getLemma() {
            return this.mLemma;
        }

        public POS getPOS() {
            return this.mPos;
        }

        public byte getLexId() {
            return this.mLexId;
        }

        public String getLexFileName() {
            return this.mWordNet.getLexName(this.mSense.getLexFileNum());
        }

        public Sense getSense() {
            return this.mSense;
        }

        public String toString() {
            return this.mSenseKey;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public int getTagCount() {
            return this.mTagCount;
        }

        void setSenseKey(String senseKey) {
            this.mSenseKey = senseKey;
        }

        void setTagCount(int tagCount) {
            this.mTagCount = tagCount;
        }
    }
}

