/*
 * Decompiled with CFR 0.152.
 */
package tratz.ml;

import java.io.Serializable;
import java.util.Map;
import tratz.types.ChecksumMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDictionary
implements Serializable {
    public static final long serialVersionUID = 1L;
    private ChecksumMap mDict = new ChecksumMap();
    private int maxIndex;

    public Map<ChecksumMap.TwoPartKey, Integer> getKeySet() {
        return this.mDict.getKeyToIndexMap();
    }

    public void override(String key, int index) {
        this.mDict.put(key, index);
        if (index > this.maxIndex) {
            this.maxIndex = index;
        }
    }

    public int lookupIndex(String key, boolean add) {
        int result = -1;
        int index = this.mDict.get(key);
        if (index == Integer.MIN_VALUE) {
            if (add) {
                ++this.maxIndex;
                this.mDict.put(key, this.maxIndex);
                result = this.maxIndex;
            }
        } else {
            result = index;
        }
        return result;
    }

    public int lookupIndex(ChecksumMap.TwoPartKey twoPartKey, boolean add) {
        int result = -1;
        int index = this.mDict.get(twoPartKey.hash, twoPartKey.checksum);
        if (index == Integer.MIN_VALUE) {
            if (add) {
                ++this.maxIndex;
                this.mDict.put(twoPartKey.hash, twoPartKey.checksum, this.maxIndex);
                result = this.maxIndex;
            }
        } else {
            result = index;
        }
        return result;
    }

    public int size() {
        return this.mDict.size();
    }
}

