/*
 * Decompiled with CFR 0.152.
 */
package tratz.ml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Random;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;

public class SplitToFolds {
    public static final String OPT_INPUT_FILE = "infile";
    public static final String OPT_TRAINFOLD_PREFIX = "trainfoldprefix";
    public static final String OPT_TESTFOLD_PREFIX = "testfoldprefix";
    public static final String OPT_NUM_FOLDS = "numfolds";
    public static final String OPT_RANDOM_SEED = "randomseed";
    public static final int DEFAULT_NUM_FOLDS = 10;

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOptions = new CommandLineOptions();
        cmdOptions.addOption(OPT_INPUT_FILE, "file", "file containing instances");
        cmdOptions.addOption(OPT_TRAINFOLD_PREFIX, "string", "prefix of training fold files (e.g., trainfolds/fold");
        cmdOptions.addOption(OPT_TESTFOLD_PREFIX, "string", "prefix of testing fold files (e.g., testfolds/fold");
        cmdOptions.addOption(OPT_NUM_FOLDS, "integer", "number of folds");
        cmdOptions.addOption(OPT_RANDOM_SEED, "long", "seed for random number generator");
        return cmdOptions;
    }

    public static void main(String[] args) throws Exception {
        File[] filesToProcess;
        File[] fileArray;
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(SplitToFolds.createOptions(), args);
        File inFile = new File(cmdLine.getStringValue(OPT_INPUT_FILE));
        String trainingFoldOutprefix = cmdLine.getStringValue(OPT_TRAINFOLD_PREFIX);
        String testFoldOutprefix = cmdLine.getStringValue(OPT_TESTFOLD_PREFIX);
        int numFolds = cmdLine.getIntegerValue(OPT_NUM_FOLDS, 10);
        long randomSeed = cmdLine.getIntegerValue(OPT_RANDOM_SEED).intValue();
        if (inFile.isDirectory()) {
            fileArray = inFile.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = inFile;
        }
        for (File fileToProcess : filesToProcess = fileArray) {
            int numLines = SplitToFolds.countLines(fileToProcess);
            double numPerFold = (double)numLines / (double)numFolds;
            int[] selections = new int[numLines];
            Random rng = new Random(randomSeed);
            for (int i = 0; i < numLines; ++i) {
                selections[i] = rng.nextInt(numFolds);
            }
            System.err.println("Num per fold: " + numPerFold);
            BufferedReader reader = new BufferedReader(new FileReader(fileToProcess));
            String line = null;
            PrintWriter[] trainWriters = new PrintWriter[numFolds];
            PrintWriter[] testWriters = new PrintWriter[numFolds];
            for (int i = 0; i < numFolds; ++i) {
                File trainFile = new File(trainingFoldOutprefix + (inFile.isDirectory() ? "_" + fileToProcess.getName() + "_" : "") + i);
                File testFile = new File(testFoldOutprefix + (inFile.isDirectory() ? "_" + fileToProcess.getName() + "_" : "") + i);
                trainFile.getAbsoluteFile().getParentFile().mkdirs();
                testFile.getAbsoluteFile().getParentFile().mkdirs();
                trainWriters[i] = new PrintWriter(new FileWriter(trainFile));
                testWriters[i] = new PrintWriter(new FileWriter(testFile));
            }
            int x = 0;
            while ((line = reader.readLine()) != null) {
                int selection = selections[x];
                testWriters[selection].println(line);
                for (int j = 0; j < numFolds; ++j) {
                    if (selection == j) continue;
                    trainWriters[j].println(line);
                }
                ++x;
            }
            reader.close();
            for (int i = 0; i < numFolds; ++i) {
                trainWriters[i].close();
                testWriters[i].close();
            }
        }
    }

    public static int countLines(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int count = 0;
        while (reader.readLine() != null) {
            ++count;
        }
        reader.close();
        return count;
    }
}

