/*
 * Decompiled with CFR 0.152.
 */
package tratz.ml;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;

public class TrainSvmModels {
    public static final String OPT_INPUT = "input";
    public static final String OPT_OUTPUT = "output";
    public static final String OPT_C_PARAM = "svmcparam";
    public static final String OPT_WAIT_FOR = "waitfor";
    public static final String OPT_MAX_AT_ONE_TIME = "maxprocesses";
    public static final int DEFAULT_MAX_AT_ONE_TIME = 100;

    public static CommandLineOptions createOptions() {
        CommandLineOptions cmdOpts = new CommandLineOptions();
        cmdOpts.addOption(OPT_INPUT, "file", "file/directory containing LIBLINEAR-style training information");
        cmdOpts.addOption(OPT_OUTPUT, "file", "file/directory for saving the trained model(s)");
        cmdOpts.addOption(OPT_C_PARAM, "double", "the C parameter for training the SVMs");
        cmdOpts.addOption(OPT_MAX_AT_ONE_TIME, "integer", "the maximum number of SVMs to be training at once");
        cmdOpts.addOption(OPT_WAIT_FOR, "boolean", "wait for one model to complete training before moving on");
        return cmdOpts;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(TrainSvmModels.createOptions(), args);
        File input = new File(cmdLine.getStringValue(OPT_INPUT));
        File output = new File(cmdLine.getStringValue(OPT_OUTPUT));
        double cParam = cmdLine.getDoubleValue(OPT_C_PARAM);
        boolean waitFor = cmdLine.getBooleanValue(OPT_WAIT_FOR);
        int maxAtOneTime = cmdLine.getIntegerValue(OPT_MAX_AT_ONE_TIME, 100);
        if (!output.getAbsoluteFile().exists() && input.isDirectory()) {
            System.err.print("Attempting to create non-existent output directory...");
            boolean madeDirectories = output.getAbsoluteFile().mkdirs();
            System.err.println(madeDirectories ? "success" : "failure");
        }
        Runtime runtime = Runtime.getRuntime();
        Object[] files = null;
        files = input.isDirectory() ? input.listFiles() : new File[]{input};
        Arrays.sort(files);
        ArrayList<Process> processesToWaitOn = new ArrayList<Process>();
        for (int i = 0; i < files.length; ++i) {
            Object f = files[i];
            String outputFilename = input.isDirectory() ? output.getAbsolutePath() + "/" + ((File)f).getName() + ".model" : output.getAbsolutePath();
            String command = "./trainSVM -q -c " + cParam + " " + ((File)f).getAbsolutePath() + " " + outputFilename;
            System.err.println("Executing: " + command);
            Process p = runtime.exec(command);
            if (waitFor) {
                int result = p.waitFor();
                System.err.println("Process return value: " + result);
            } else {
                System.err.println("Will proceed to start the next process immediately if fewer than " + maxAtOneTime + " have been started.");
                processesToWaitOn.add(p);
            }
            if (processesToWaitOn.size() < maxAtOneTime) continue;
            boolean stillMoreToWait = true;
            while (stillMoreToWait) {
                stillMoreToWait = false;
                for (Process process : processesToWaitOn) {
                    try {
                        process.exitValue();
                    }
                    catch (Exception e) {
                        stillMoreToWait = true;
                        Thread.sleep(2000L);
                    }
                }
            }
            for (Process pro : processesToWaitOn) {
                pro.destroy();
            }
            processesToWaitOn.clear();
        }
        boolean stillMoreToWait = true;
        while (stillMoreToWait) {
            stillMoreToWait = false;
            for (Process p : processesToWaitOn) {
                try {
                    p.exitValue();
                }
                catch (Exception e) {
                    stillMoreToWait = true;
                    Thread.sleep(2000L);
                }
            }
        }
    }
}

