/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import tratz.parse.ParseAction;
import tratz.parse.featgen.ParseFeatureGenerator;
import tratz.parse.ml.ParseModel;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.parse.types.TokenPointer;
import tratz.types.IntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLParser {
    public static long sFeatGenTime = 0L;
    public static long sDotProductTime = 0L;
    private ParseModel mModel;
    private ParseFeatureGenerator mFeatGen;

    public NLParser(ParseModel model, ParseFeatureGenerator featGen) {
        this.mModel = model;
        this.mFeatGen = featGen;
    }

    public NLParser(String modelFile) throws IOException, ClassNotFoundException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(modelFile));
        if (modelFile.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        ObjectInputStream ois = new ObjectInputStream(is);
        this.mModel = (ParseModel)ois.readObject();
        this.mFeatGen = (ParseFeatureGenerator)ois.readObject();
        ois.close();
    }

    private IntArrayList getValues(ParseModel model, Set<String> fts, IntArrayList values, boolean addFeats) {
        for (String f : fts) {
            int index = model.getIndex(f, addFeats);
            if (index == Integer.MIN_VALUE) continue;
            values.add(index);
        }
        return values;
    }

    public Parse parseSentence(Sentence sentence) {
        Parse returnValue = null;
        List<Token> tokens = sentence.getTokens();
        int numTokens = tokens.size();
        if (numTokens >= 1) {
            List[] currentArcs = new List[numTokens + 1];
            int creationOrderIndex = 1;
            double[] scores = new double[this.mModel.getActions().size()];
            int[] indices = new int[this.mModel.getActions().size()];
            TokenPointer first = null;
            TokenPointer[] tokenToPtr = new TokenPointer[numTokens + 1];
            TokenPointer prev = null;
            for (int i = 0; i < numTokens; ++i) {
                Token t = tokens.get(i);
                TokenPointer ptr = new TokenPointer(t, null, prev);
                if (i == 0) {
                    first = ptr;
                }
                tokenToPtr[t.getIndex()] = ptr;
                if (prev != null) {
                    prev.next = ptr;
                }
                prev = ptr;
            }
            IntArrayList[] featureCache = new IntArrayList[numTokens + 1];
            List[] actionCache = new ArrayList[numTokens + 1];
            boolean[] actionListStale = new boolean[numTokens + 1];
            for (int i = 0; i < numTokens + 1; ++i) {
                actionListStale[i] = true;
            }
            HashSet<String> ftSet = new HashSet<String>();
            while (first != null && first.next != null) {
                TokenPointer ptr = first;
                while (ptr != null) {
                    if (actionListStale[ptr.tok.getIndex()]) {
                        int i;
                        Token token = ptr.tok;
                        ArrayList<ParseAction> actions = actionCache[token.getIndex()];
                        IntArrayList features = featureCache[token.getIndex()];
                        long sfeat = System.nanoTime();
                        this.mFeatGen.genFeats(ftSet, this.mModel, tokens, tokenToPtr[token.getIndex()], currentArcs);
                        if (features == null) {
                            featureCache[token.getIndex()] = features = new IntArrayList(ftSet.size());
                        }
                        features.clear();
                        featureCache[token.getIndex()] = features = this.getValues(this.mModel, ftSet, features, false);
                        ftSet.clear();
                        sFeatGenTime += System.nanoTime() - sfeat;
                        List<String> actionNames = this.mModel.getActions(ptr.tok, ptr.next == null ? null : ptr.next.tok, null);
                        if (actions == null) {
                            actionCache[token.getIndex()] = actions = new ArrayList<ParseAction>();
                        }
                        int numActions = actionNames.size();
                        int currentSize = actions.size();
                        for (i = currentSize - 1; i >= numActions; --i) {
                            actions.remove(i);
                        }
                        for (i = currentSize = actions.size(); i < numActions; ++i) {
                            actions.add(new ParseAction(token, ptr, actionNames.get(i), 0.0));
                        }
                        currentSize = actions.size();
                        long start = System.nanoTime();
                        this.mModel.score(actionNames, features, indices, scores);
                        sDotProductTime += System.nanoTime() - start;
                        for (int i2 = 0; i2 < numActions; ++i2) {
                            String action = actionNames.get(i2);
                            ParseAction oldAction = (ParseAction)actions.get(i2);
                            oldAction.actionName = action;
                            oldAction.score = scores[i2];
                        }
                        actionListStale[ptr.tok.getIndex()] = false;
                    }
                    ptr = ptr.next;
                }
                ParseAction bestAction = this.getBestAction(first, actionCache, tokenToPtr, currentArcs);
                if (bestAction != null) {
                    first = NLParser.performAction(tokens, first, tokenToPtr, bestAction, actionListStale, featureCache, currentArcs, creationOrderIndex, this.mFeatGen.getContextWidth());
                    if (bestAction.actionName.startsWith("SWAP")) continue;
                    ++creationOrderIndex;
                    continue;
                }
                for (Token tok : tokens) {
                    System.err.print(tok.getText() + "/" + tok.getPos() + " ");
                }
                System.err.println();
                TokenPointer tptr = first;
                while (tptr != null) {
                    System.err.print(tptr.tok.getText() + "/" + tptr.tok.getPos() + " ");
                    List actions = actionCache[tptr.tok.getIndex()];
                    if (actions != null) {
                        System.err.print("**");
                        for (ParseAction act : actions) {
                            System.err.print(act.actionName + "_" + act.token.getText() + "_" + this.isValid(act, tokenToPtr, currentArcs) + " ");
                        }
                        System.err.print("**");
                    }
                    tptr = tptr.next;
                }
                System.err.println();
                throw new RuntimeException("Bizarre. No valid action found. Unsupported part-of-speech perhaps?");
            }
            Token root = new Token("[ROOT]", 0);
            ArrayList<Arc> sentenceArcs = new ArrayList<Arc>();
            for (List arcs : currentArcs) {
                if (arcs == null) continue;
                sentenceArcs.addAll(arcs);
            }
            sentenceArcs.add(new Arc(first.tok, root, "ROOT"));
            returnValue = new Parse(sentence, root, sentenceArcs);
        }
        return returnValue;
    }

    public ParseAction getBestAction(TokenPointer first, List[] actionCache, TokenPointer[] tokenToPtr, List[] currentArcs) {
        ParseAction bestAction = null;
        double bestActionScore = -9.9999999E7;
        TokenPointer ptr = first;
        while (ptr != null) {
            for (ParseAction action : actionCache[ptr.tok.getIndex()]) {
                if (!(action.score > bestActionScore) || !this.isValid(action, tokenToPtr, currentArcs)) continue;
                bestActionScore = action.score;
                bestAction = action;
            }
            ptr = ptr.next;
        }
        return bestAction;
    }

    protected boolean isValid(ParseAction action, TokenPointer[] tokenToPtr, List[] tokenToArcs) {
        TokenPointer ptr = tokenToPtr[action.token.getIndex()];
        boolean isValid = false;
        if (action.actionName.equals("SWAPRIGHT")) {
            isValid = ptr.next != null && action.token.getIndex() < ptr.next.tok.getIndex();
        } else if (action.actionName.equals("SWAPLEFT")) {
            isValid = ptr.prev != null && action.token.getIndex() > ptr.prev.tok.getIndex();
        } else if (ptr.next != null) {
            isValid = true;
        }
        return isValid;
    }

    public static TokenPointer performAction(List<Token> sentence, TokenPointer first, TokenPointer[] tokenToPtr, ParseAction action, boolean[] actionListStale, IntArrayList[] tokenToFeatures, List[] currentArcs, int actionNum, int contextWidth) {
        int i;
        TokenPointer clearPtr;
        int widthToReset = contextWidth / 2 + 1;
        TokenPointer save = clearPtr = tokenToPtr[action.token.getIndex()];
        for (i = 0; i < widthToReset + 1 && clearPtr != null; ++i) {
            actionListStale[clearPtr.tok.getIndex()] = true;
            tokenToFeatures[clearPtr.tok.getIndex()].clear();
            clearPtr = clearPtr.next;
        }
        clearPtr = save.prev;
        for (i = 0; i < widthToReset && clearPtr != null; ++i) {
            actionListStale[clearPtr.tok.getIndex()] = true;
            tokenToFeatures[clearPtr.tok.getIndex()].clear();
            clearPtr = clearPtr.prev;
        }
        TokenPointer actionPtr = save;
        if (action.actionName.equals("SWAPRIGHT")) {
            TokenPointer nextptr = actionPtr.next;
            TokenPointer prevptr = actionPtr.prev;
            if (nextptr.next != null) {
                nextptr.next.prev = actionPtr;
            }
            actionPtr.next = nextptr.next;
            actionPtr.prev = nextptr;
            nextptr.next = actionPtr;
            nextptr.prev = prevptr;
            if (prevptr != null) {
                prevptr.next = nextptr;
            }
            if (actionPtr == first) {
                first = nextptr;
            }
        } else if (action.actionName.equals("SWAPLEFT")) {
            TokenPointer nextptr = actionPtr.next;
            TokenPointer prevptr = actionPtr.prev;
            if (prevptr.prev != null) {
                prevptr.prev.next = actionPtr;
            } else {
                first = actionPtr;
            }
            prevptr.next = actionPtr.next;
            actionPtr.next = prevptr;
            actionPtr.prev = prevptr.prev;
            prevptr.prev = actionPtr;
            if (nextptr != null) {
                nextptr.prev = prevptr;
            }
        } else {
            String dependency = action.actionName.substring(0, action.actionName.length() - 1);
            TokenPointer head = null;
            TokenPointer child = null;
            if (action.actionName.endsWith("l")) {
                head = actionPtr.next;
                child = actionPtr;
            } else if (action.actionName.endsWith("r")) {
                head = actionPtr;
                child = actionPtr.next;
            } else {
                throw new RuntimeException("ERROR. Unexpected action type: " + action.actionName);
            }
            ArrayList<Arc> arcs = currentArcs[head.tok.getIndex()];
            if (arcs == null) {
                currentArcs[head.tok.getIndex()] = arcs = new ArrayList<Arc>();
            }
            arcs.add(new Arc(child.tok, head.tok, dependency, actionNum));
            TokenPointer childprev = child.prev;
            TokenPointer childnext = child.next;
            if (childprev != null) {
                childprev.next = childnext;
            }
            if (childnext != null) {
                childnext.prev = childprev;
            }
            if (child == first) {
                first = childnext;
            }
        }
        return first;
    }
}

