/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.parse.FullSystemWrapper;
import tratz.parse.io.ConllxSentenceReader;
import tratz.parse.io.SentenceReader;
import tratz.parse.io.SentenceWriter;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

public class ParsingScript {
    public static final String OPT_POS_MODEL = "posmodel";
    public static final String OPT_PARSE_MODEL = "parsemodel";
    public static final String OPT_POSSESSIVES_MODEL = "possmodel";
    public static final String OPT_NOUN_COMPOUND_MODEL = "nnmodel";
    public static final String OPT_PREPOSITIONS_MODEL = "psdmodel";
    public static final String OPT_SRL_ARGS_MODEL = "srlargsmodel";
    public static final String OPT_SRL_PREDICATES_MODEL = "srlpredmodel";
    public static final String OPT_SENTENCE_READER = "sreader";
    public static final String OPT_SENTENCE_WRITER = "swriter";
    public static final String OPT_SENTENCE_WRITER_OPTIONS = "writeroptions";
    public static final String OPT_INPUT = "input";
    public static final String OPT_WORDNET_DIR = "wndir";
    public static final Boolean DEFAULT_VCH_CONVERT = Boolean.FALSE;
    public static final String DEFAULT_SENTENCE_READER_CLASS = ConllxSentenceReader.class.getName();

    private static CommandLineOptions createOptions() {
        CommandLineOptions cmdOpts = new CommandLineOptions();
        cmdOpts.addOption(OPT_POS_MODEL, "file", "part-of-speech tagging model file");
        cmdOpts.addOption(OPT_PARSE_MODEL, "file", "parser model file");
        cmdOpts.addOption(OPT_NOUN_COMPOUND_MODEL, "file", "noun compound interpretation model file");
        cmdOpts.addOption(OPT_PREPOSITIONS_MODEL, "file", "preposition disambiguation models file");
        cmdOpts.addOption(OPT_POSSESSIVES_MODEL, "file", "possessives interpretation model file");
        cmdOpts.addOption(OPT_SRL_PREDICATES_MODEL, "file", "semantic role labeling model file");
        cmdOpts.addOption(OPT_SRL_ARGS_MODEL, "file", "semantic role labeling model file");
        cmdOpts.addOption(OPT_SENTENCE_READER, "classname", "sentence reader class name (implements " + SentenceReader.class.getName() + " )");
        cmdOpts.addOption(OPT_SENTENCE_WRITER, "classname", "sentence writer class name (implements " + SentenceWriter.class.getName() + " )");
        cmdOpts.addOption(OPT_SENTENCE_WRITER_OPTIONS, "string", "string of colon-separated arguments for the writer");
        cmdOpts.addOption(OPT_WORDNET_DIR, "file", "WordNet dictionary (dict) directory");
        cmdOpts.addOption(OPT_INPUT, "file", "input file/directory (if left out, standard input will be used instead)");
        return cmdOpts;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(ParsingScript.createOptions(), args);
        String inputFilename = cmdLine.getStringValue(OPT_INPUT);
        String sentenceReaderClass = cmdLine.getStringValue(OPT_SENTENCE_READER, DEFAULT_SENTENCE_READER_CLASS);
        String sentenceWriterClass = cmdLine.getStringValue(OPT_SENTENCE_WRITER);
        SentenceReader sentenceReader = (SentenceReader)Class.forName(sentenceReaderClass).newInstance();
        SentenceWriter sentenceWriter = (SentenceWriter)Class.forName(sentenceWriterClass).newInstance();
        String writerArgs = cmdLine.getStringValue(OPT_SENTENCE_WRITER_OPTIONS);
        HashMap<String, String> writerArgsMap = new HashMap<String, String>();
        if (writerArgs != null) {
            String[] writerArgArray = writerArgs.split(":");
            for (int i = 0; i < writerArgArray.length; ++i) {
                String[] parts = writerArgArray[i].split("=");
                writerArgsMap.put(parts[0], parts[1]);
            }
        }
        sentenceWriter.initialize(writerArgsMap);
        String posModelFile = cmdLine.getStringValue(OPT_POS_MODEL);
        String wnDir = cmdLine.getStringValue(OPT_WORDNET_DIR);
        String parseModelFile = cmdLine.getStringValue(OPT_PARSE_MODEL);
        String possessivesModelFile = cmdLine.getStringValue(OPT_POSSESSIVES_MODEL);
        String nounCompoundModelFile = cmdLine.getStringValue(OPT_NOUN_COMPOUND_MODEL);
        String prepositionModelFile = cmdLine.getStringValue(OPT_PREPOSITIONS_MODEL);
        String srlArgsModelFile = cmdLine.getStringValue(OPT_SRL_ARGS_MODEL);
        String srlPredicatesModelFile = cmdLine.getStringValue(OPT_SRL_PREDICATES_MODEL);
        FullSystemWrapper fullSystemWrapper = new FullSystemWrapper(prepositionModelFile, nounCompoundModelFile, possessivesModelFile, srlArgsModelFile, srlPredicatesModelFile, posModelFile, parseModelFile, wnDir);
        System.err.println("Beginning sentence processing:");
        long parseStart = System.currentTimeMillis();
        int totalSentences = 0;
        int totalTokens = 0;
        BufferedReader reader = null;
        reader = inputFilename != null ? new BufferedReader(new FileReader(inputFilename), 1000000) : new BufferedReader(new InputStreamReader(System.in));
        Parse emptyOrOldParse = null;
        while ((emptyOrOldParse = sentenceReader.readSentence(reader)) != null) {
            Sentence sentence;
            List<Token> tokens = (sentence = emptyOrOldParse.getSentence()).getTokens();
            FullSystemWrapper.FullSystemResult result = fullSystemWrapper.process(sentence, tokens.size() > 0 && tokens.get(0).getPos() == null, true, true, true, true, true);
            sentenceWriter.appendSentence(sentence, result.getParse(), result.getSrlParse() == null ? null : result.getSrlParse().getHeadArcs());
            totalTokens += sentence.getTokens().size();
            if (++totalSentences % 100 != 0) continue;
            System.err.println(totalSentences);
        }
        reader.close();
        sentenceWriter.close();
        long totalTime = System.currentTimeMillis() - parseStart;
        System.err.println("Time: " + (double)totalTime / 1000.0 + " seconds");
        System.err.println("Total sentences: " + totalSentences);
        System.err.println("Total tokens: " + totalTokens);
    }
}

