/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tratz.parse.io.SentenceReader;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

public class FlatSentenceReader
implements SentenceReader {
    private static final String HIGH_DOUBLE_QUOTES;
    private static final String HIGH_SINGLE_QUOTES;
    private Matcher mDoubleQuoteMatcher = Pattern.compile(HIGH_DOUBLE_QUOTES).matcher("");
    private Matcher mSingleQuoteMatcher = Pattern.compile(HIGH_SINGLE_QUOTES).matcher("");

    public Parse readSentence(BufferedReader reader) throws IOException {
        Token root = new Token("[ROOT]", 0);
        ArrayList<Token> tokens = new ArrayList<Token>();
        ArrayList<Arc> arcs = new ArrayList<Arc>();
        HashMap<Integer, Token> numToToken = new HashMap<Integer, Token>();
        numToToken.put(0, root);
        String line = reader.readLine();
        if (line != null) {
            String[] split = line.split("\\t+");
            if (!line.trim().equals("")) {
                if (split.length % 2 == 1) {
                    System.err.println("Strange line: " + line);
                    System.err.println("NumElements:" + split.length);
                    throw new RuntimeException("Error: odd number of tab-separated elements detected");
                }
                line = this.mDoubleQuoteMatcher.reset(line).replaceAll("\"");
                line = this.mSingleQuoteMatcher.reset(line).replaceAll("\"");
                for (int i = 0; i < split.length; i += 2) {
                    String tokenString = split[i];
                    String pos = split[i + 1];
                    int tokenNum = i / 2 + 1;
                    Token token = new Token(tokenString, tokenNum);
                    token.setPos(pos);
                    tokens.add(token);
                    numToToken.put(tokenNum, token);
                }
            }
        }
        Parse result = null;
        if (line != null) {
            result = new Parse(new Sentence(tokens), root, arcs);
        }
        return result;
    }

    static {
        int[] doubleQuoteInts = new int[]{132, 171, 187, 147, 148, 8220, 8221, 8222, 8223, 8243, 8244, 8246, 8247};
        int[] singleQuoteInts = new int[]{145, 146, 8216, 8217, 8218, 8219, 8242, 8245};
        StringBuilder buf = new StringBuilder();
        for (int i : doubleQuoteInts) {
            buf.append((char)i).append("|");
        }
        buf.setLength(buf.length() - 1);
        HIGH_DOUBLE_QUOTES = buf.toString();
        buf = new StringBuilder();
        for (int i : singleQuoteInts) {
            buf.append((char)i).append("|");
        }
        buf.setLength(buf.length() - 1);
        HIGH_SINGLE_QUOTES = buf.toString();
    }
}

