/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.train;

import java.util.List;
import tratz.parse.ParseAction;
import tratz.parse.train.PenaltyFunction;
import tratz.parse.types.Arc;
import tratz.parse.types.Token;
import tratz.parse.types.TokenPointer;

public class DefaultPenaltyFunction
implements PenaltyFunction {
    public double calculatePenalty(TokenPointer ptr, ParseAction action, Arc[] tokenToHead, List[] gold, List[] current, Token[] tokenToSubcomponentHead, int[] projectiveIndices) {
        double penalty = 0.0;
        Token tok = action.token;
        if (action.actionName.equals("SWAPRIGHT")) {
            penalty = ptr.next != null && projectiveIndices[tok.getIndex()] > projectiveIndices[ptr.next.tok.getIndex()] ? 0.0 : 1.0;
        } else if (action.actionName.equals("SWAPLEFT")) {
            penalty = ptr.prev != null && projectiveIndices[tok.getIndex()] < projectiveIndices[ptr.prev.tok.getIndex()] ? 0.0 : 1.0;
        } else {
            TokenPointer head = null;
            TokenPointer child = null;
            if (action.actionName.endsWith("l")) {
                head = ptr.next;
                child = ptr;
            } else if (action.actionName.endsWith("r")) {
                head = ptr;
                child = ptr.next;
            } else {
                throw new IllegalArgumentException("ERROR! Unexpected action (" + action.actionName + ") encountered!!! Doesn't end with 'l' or 'r'");
            }
            if (child == null) {
                penalty = 1.0;
            } else {
                List goldArcs = gold[child.tok.getIndex()];
                List currentArcs = current[child.tok.getIndex()];
                int numGoldArcs = goldArcs == null ? 0 : goldArcs.size();
                int numCurrentArcs = currentArcs == null ? 0 : currentArcs.size();
                String dependency = action.actionName.substring(0, action.actionName.length() - 1);
                Arc headArc = tokenToHead[child.tok.getIndex()];
                if (headArc == null || head == null || headArc.getHead() != head.tok) {
                    penalty = 1.0;
                } else if (!headArc.getDependency().equals(dependency)) {
                    penalty = 1.0;
                }
                if (numGoldArcs > numCurrentArcs) {
                    penalty = 1.0;
                }
            }
        }
        return penalty;
    }
}

